/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.assemble;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Archive;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.JavaArchiveAssembler;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;

public abstract class JavaArchiveAssemblerResolver
extends Validator {
    public static void resolveJavaArchiveOutputs(JReleaserContext context, Errors errors) {
        List<JavaArchiveAssembler> activeArchives = context.getModel().getAssemble().getActiveJavaArchives();
        if (!activeArchives.isEmpty()) {
            context.getLogger().debug("assemble.java-archive");
        }
        for (JavaArchiveAssembler archive : activeArchives) {
            if (!archive.isExported()) continue;
            JavaArchiveAssemblerResolver.resolveJavaArchiveOutputs(context, archive, errors);
        }
    }

    private static void resolveJavaArchiveOutputs(JReleaserContext context, JavaArchiveAssembler archive, Errors errors) {
        Path baseOutputDirectory = context.getAssembleDirectory().resolve(archive.getName()).resolve(archive.getType());
        String archiveName = archive.getResolvedArchiveName(context);
        for (Archive.Format format : archive.getFormats()) {
            Path path = baseOutputDirectory.resolve(archiveName + "." + format.extension()).toAbsolutePath();
            if (!Files.exists(path, new LinkOption[0])) {
                errors.assembly(RB.$((String)"validation_missing_assembly", (Object[])new Object[]{archive.getType(), archive.getName(), archive.getName()}));
                continue;
            }
            Artifact artifact = Artifact.of(path);
            artifact.setExtraProperties(archive.getExtraProperties());
            artifact.activate();
            archive.addOutput(artifact);
        }
    }
}

