/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.deploy.maven;

import java.util.Locale;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.deploy.maven.GitlabMavenDeployer;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.deploy.maven.MavenDeployersValidator;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class GitlabMavenDeployerValidator
extends Validator {
    public static void validateGitlabMavenDeployer(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, GitlabMavenDeployer> gitlab = context.getModel().getDeploy().getMaven().getGitlab();
        if (!gitlab.isEmpty()) {
            context.getLogger().debug("deploy.maven.gitlab");
        }
        for (Map.Entry<String, GitlabMavenDeployer> e : gitlab.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateDeploy() && !mode.validateConfig()) continue;
            GitlabMavenDeployerValidator.validateGitlabMavenDeployer(context, mode, e.getValue(), errors);
        }
    }

    private static void validateGitlabMavenDeployer(JReleaserContext context, JReleaserContext.Mode mode, GitlabMavenDeployer mavenDeployer, Errors errors) {
        MavenDeployersValidator.validateMavenDeployer(context, mode, mavenDeployer, errors);
        if (!mavenDeployer.isEnabled()) {
            return;
        }
        String baseEnvKey = mavenDeployer.getType().toUpperCase(Locale.ENGLISH);
        mavenDeployer.setUsername(GitlabMavenDeployerValidator.checkProperty(context, baseEnvKey + "_" + Env.toVar((String)mavenDeployer.getName()) + "_USERNAME", "maven.deploy." + mavenDeployer.getType() + ".username", mavenDeployer.getUsername(), errors, true));
        if (StringUtils.isBlank((String)mavenDeployer.getUsername())) {
            mavenDeployer.setUsername(context.getModel().getRelease().getReleaser().getUsername());
        }
        if (StringUtils.isBlank((String)mavenDeployer.getProjectIdentifier())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"deploy.maven.gitea." + mavenDeployer.getName() + ".projectIdentifier"}));
        }
    }
}

