/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.download;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.download.Download;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.download.FtpDownloaderValidator;
import org.jreleaser.model.internal.validation.download.HttpDownloaderValidator;
import org.jreleaser.model.internal.validation.download.ScpDownloaderValidator;
import org.jreleaser.model.internal.validation.download.SftpDownloaderValidator;
import org.jreleaser.util.Errors;

public abstract class DownloadersValidator
extends Validator {
    public static void validateDownloaders(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Download download = context.getModel().getDownload();
        context.getLogger().debug("download");
        FtpDownloaderValidator.validateFtpDownloader(context, mode, errors);
        HttpDownloaderValidator.validateHttpDownloader(context, mode, errors);
        ScpDownloaderValidator.validateScpDownloader(context, mode, errors);
        SftpDownloaderValidator.validateSftpDownloader(context, mode, errors);
        if (mode.validateConfig() || mode.validateDownload()) {
            boolean activeSet = download.isActiveSet();
            download.resolveEnabled(context.getModel().getProject());
            if (download.isEnabled()) {
                boolean enabled;
                boolean bl = enabled = !download.getActiveFtps().isEmpty() || !download.getActiveHttps().isEmpty() || !download.getActiveScps().isEmpty() || !download.getActiveSftps().isEmpty();
                if (!activeSet && !enabled) {
                    context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
                    download.disable();
                }
            }
        }
    }
}

