/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.packagers;

import java.util.List;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserModel;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.Icon;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.FlatpakPackager;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.validation.common.ExtraPropertiesValidator;
import org.jreleaser.model.internal.validation.common.TemplateValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.distributions.DistributionsValidator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class FlatpakPackagerValidator
extends Validator {
    public static void validateFlatpak(JReleaserContext context, JReleaserContext.Mode mode, Distribution distribution, FlatpakPackager packager, Errors errors) {
        context.getLogger().debug("distribution.{}.flatpak", new Object[]{distribution.getName()});
        JReleaserModel model = context.getModel();
        FlatpakPackager parentPackager = model.getPackagers().getFlatpak();
        if (!packager.isActiveSet() && parentPackager.isActiveSet()) {
            packager.setActive(parentPackager.getActive());
        }
        if (!packager.resolveEnabled(context.getModel().getProject(), distribution)) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            packager.disable();
            return;
        }
        BaseReleaser<?, ?> service = model.getRelease().getReleaser();
        if (!service.isReleaseSupported()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.release", (Object[])new Object[0]));
            packager.disable();
            return;
        }
        List<Artifact> candidateArtifacts = packager.resolveCandidateArtifacts(context, distribution);
        if (candidateArtifacts.size() == 0) {
            packager.setActive(Active.NEVER);
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            errors.warning(RB.$((String)"WARNING.validation.packager.no.artifacts", (Object[])new Object[]{distribution.getName(), packager.getType(), packager.getSupportedFileExtensions(distribution.getType())}));
            packager.disable();
            return;
        }
        if (candidateArtifacts.stream().filter(artifact -> StringUtils.isBlank((String)artifact.getPlatform())).count() > 1L) {
            errors.configuration(RB.$((String)"validation_packager_multiple_artifacts", (Object[])new Object[]{"distribution." + distribution.getName() + ".flatpak"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.multiple.artifacts", (Object[])new Object[0]));
            errors.warning(RB.$((String)"WARNING.validation.packager.multiple.artifacts", (Object[])new Object[]{distribution.getName(), packager.getType(), candidateArtifacts.stream().filter(artifact -> StringUtils.isBlank((String)artifact.getPlatform())).map(Artifact::getPath).collect(Collectors.toList())}));
            packager.disable();
            return;
        }
        if (StringUtils.isBlank((String)packager.getComponentId()) && StringUtils.isNotBlank((String)parentPackager.getComponentId())) {
            packager.setComponentId(parentPackager.getComponentId());
        }
        if (StringUtils.isBlank((String)packager.getComponentId())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"distribution." + distribution.getName() + ".flatpak.componentId"}));
        }
        if (packager.getCategories().isEmpty()) {
            packager.setCategories(parentPackager.getCategories());
        }
        if (packager.getCategories().isEmpty()) {
            errors.configuration(RB.$((String)"validation_is_empty", (Object[])new Object[]{"distribution." + distribution.getName() + ".flatpak.categories"}));
        }
        if (StringUtils.isBlank((String)packager.getDeveloperName())) {
            packager.setDeveloperName(parentPackager.getDeveloperName());
        }
        if (packager.getScreenshots().isEmpty()) {
            packager.setScreenshots(parentPackager.getScreenshots());
        }
        if (packager.getScreenshots().isEmpty()) {
            errors.configuration(RB.$((String)"validation_is_empty", (Object[])new Object[]{"distribution." + distribution.getName() + ".flatpak.screenshots"}));
        }
        FlatpakPackagerValidator.validateScreenshots(context, mode, packager.getScreenshots(), errors, "distribution." + distribution.getName() + ".flatpak");
        packager.getScreenshots().removeIf(screenshot -> StringUtils.isTrue((Object)screenshot.getExtraProperties().get("skipFlatpak")));
        if (packager.getScreenshots().isEmpty()) {
            errors.configuration(RB.$((String)"validation_is_empty", (Object[])new Object[]{"distribution." + distribution.getName() + ".flatpak.screenshots"}));
        }
        if (packager.getIcons().isEmpty()) {
            packager.setIcons(parentPackager.getIcons());
        }
        if (packager.getIcons().isEmpty()) {
            errors.configuration(RB.$((String)"validation_is_empty", (Object[])new Object[]{"distribution." + distribution.getName() + ".flatpak.icons"}));
        }
        FlatpakPackagerValidator.validateIcons(context, mode, packager.getIcons(), errors, "distribution." + distribution.getName() + ".flatpak", false);
        packager.getIcons().removeIf(icon -> StringUtils.isTrue((Object)icon.getExtraProperties().get("skipFlatpak")));
        if (packager.getIcons().isEmpty()) {
            errors.configuration(RB.$((String)"validation_is_empty", (Object[])new Object[]{"distribution." + distribution.getName() + ".flatpak.icons"}));
        }
        for (int i = 0; i < packager.getIcons().size(); ++i) {
            Icon icon2 = packager.getIcons().get(i);
            if (icon2.getWidth() == null || icon2.getWidth().equals(icon2.getHeight())) continue;
            errors.configuration(RB.$((String)"validation_must_be_equal", (Object[])new Object[]{"distribution." + distribution.getName() + ".flatpak.icons[" + i + "].width", icon2.getWidth(), "distribution." + distribution.getName() + ".flatpak.icons[" + i + "].height", icon2.getHeight()}));
        }
        if (null == packager.getRuntime()) {
            packager.setRuntime(parentPackager.getRuntime());
        }
        if (null == packager.getRuntime()) {
            errors.configuration(RB.$((String)"validation_is_missing", (Object[])new Object[]{"distribution." + distribution.getName() + ".flatpak.runtime"}));
        }
        if (StringUtils.isBlank((String)packager.getRuntimeVersion())) {
            packager.setRuntimeVersion(parentPackager.getRuntimeVersion());
        }
        if (StringUtils.isBlank((String)packager.getRuntimeVersion())) {
            errors.configuration(RB.$((String)"validation_is_missing", (Object[])new Object[]{"distribution." + distribution.getName() + ".flatpak.runtimeVersion"}));
        }
        if (packager.getSdkExtensions().isEmpty()) {
            packager.setSdkExtensions(parentPackager.getSdkExtensions());
        }
        if (packager.getFinishArgs().isEmpty()) {
            packager.setFinishArgs(parentPackager.getFinishArgs());
        }
        if (distribution.getType() == Distribution.DistributionType.JAVA_BINARY && StringUtils.isFalse((Object)packager.getExtraProperties().get("skipOpenjdk"))) {
            packager.getSdkExtensions().add("org.freedesktop.Sdk.Extension.openjdk");
            packager.getFinishArgs().add("--env=PATH=/app/jre/bin:/usr/bin:/app/bin");
            packager.getFinishArgs().add("--env=JAVA_HOME=/app/jre");
        }
        if (StringUtils.isBlank((String)packager.getRepository().getName())) {
            packager.getRepository().setName(packager.getComponentId());
        }
        packager.getRepository().setTapName(packager.getComponentId());
        if (distribution.getStereotype() != Stereotype.CLI && distribution.getStereotype() != Stereotype.DESKTOP) {
            errors.configuration(RB.$((String)"validation_stereotype_invalid", (Object[])new Object[]{"distribution." + distribution.getName() + ".stereotype", distribution.getStereotype(), CollectionUtils.listOf((Object[])new Stereotype[]{Stereotype.CLI, Stereotype.DESKTOP})}));
        }
        FlatpakPackagerValidator.validateCommitAuthor(packager, parentPackager);
        FlatpakPackager.FlatpakRepository repository = packager.getRepository();
        repository.resolveEnabled(model.getProject());
        FlatpakPackagerValidator.validateTap(context, distribution, repository, parentPackager.getRepository(), "flatpak.repository");
        TemplateValidator.validateTemplate(context, distribution, packager, parentPackager, errors);
        ExtraPropertiesValidator.mergeExtraProperties(packager, parentPackager);
        FlatpakPackagerValidator.validateContinueOnError(packager, parentPackager);
        if (StringUtils.isBlank((String)packager.getDownloadUrl())) {
            packager.setDownloadUrl(parentPackager.getDownloadUrl());
        }
        DistributionsValidator.validateArtifactPlatforms(context, distribution, packager, candidateArtifacts, errors);
    }
}

