/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.upload;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.upload.ArtifactoryUploader;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;

public abstract class ArtifactoryUploaderValidator
extends Validator {
    public static void validateArtifactory(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, ArtifactoryUploader> artifactory = context.getModel().getUpload().getArtifactory();
        if (!artifactory.isEmpty()) {
            context.getLogger().debug("upload.artifactory");
        }
        for (Map.Entry<String, ArtifactoryUploader> e : artifactory.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig()) continue;
            ArtifactoryUploaderValidator.validateArtifactory(context, mode, e.getValue(), errors);
        }
    }

    private static void validateArtifactory(JReleaserContext context, JReleaserContext.Mode mode, ArtifactoryUploader artifactory, Errors errors) {
        context.getLogger().debug("upload.artifactory.{}", new Object[]{artifactory.getName()});
        if (!artifactory.isActiveSet()) {
            artifactory.setActive(Active.NEVER);
        }
        if (!artifactory.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (!(artifactory.isArtifacts() || artifactory.isFiles() || artifactory.isSignatures())) {
            errors.warning(RB.$((String)"WARNING.validation.uploader.no.artifacts", (Object[])new Object[]{artifactory.getType(), artifactory.getName()}));
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            artifactory.disable();
            return;
        }
        if (artifactory.getRepositories().isEmpty()) {
            errors.configuration(RB.$((String)"validation_artifactory_no_repositories", (Object[])new Object[]{"artifactory." + artifactory.getName()}));
            context.getLogger().debug(RB.$((String)"validation.disabled.no.repositories", (Object[])new Object[0]));
            artifactory.disable();
            return;
        }
        String baseKey = "upload.artifactory" + artifactory.getName() + ".";
        artifactory.setHost(ArtifactoryUploaderValidator.checkProperty(context, "ARTIFACTORY_" + Env.toVar((String)artifactory.getName()) + "_HOST", baseKey + "host", artifactory.getHost(), errors));
        switch (artifactory.resolveAuthorization()) {
            case BEARER: {
                artifactory.setPassword(ArtifactoryUploaderValidator.checkProperty(context, "ARTIFACTORY_" + Env.toVar((String)artifactory.getName()) + "_PASSWORD", baseKey + "password", artifactory.getPassword(), errors, context.isDryrun()));
                break;
            }
            case BASIC: {
                artifactory.setUsername(ArtifactoryUploaderValidator.checkProperty(context, "ARTIFACTORY_" + Env.toVar((String)artifactory.getName()) + "_USERNAME", baseKey + "username", artifactory.getUsername(), errors, context.isDryrun()));
                artifactory.setPassword(ArtifactoryUploaderValidator.checkProperty(context, "ARTIFACTORY_" + Env.toVar((String)artifactory.getName()) + "_PASSWORD", baseKey + "password", artifactory.getPassword(), errors, context.isDryrun()));
                break;
            }
            case NONE: {
                errors.configuration(RB.$((String)"validation_value_cannot_be", (Object[])new Object[]{"artifactory." + artifactory.getName() + ".authorization", "NONE"}));
                context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
                artifactory.disable();
            }
        }
        ArtifactoryUploaderValidator.validateTimeout(artifactory);
        for (ArtifactoryUploader.ArtifactoryRepository repository : artifactory.getRepositories()) {
            if (!repository.isActiveSet()) {
                repository.setActive(artifactory.getActive());
            }
            repository.resolveEnabled(context.getModel().getProject());
        }
        if (artifactory.getRepositories().stream().noneMatch(ArtifactoryUploader.ArtifactoryRepository::isEnabled)) {
            errors.warning(RB.$((String)"validation_artifactory_disabled_repositories", (Object[])new Object[]{"artifactory." + artifactory.getName()}));
            context.getLogger().debug(RB.$((String)"validation.disabled.no.repositories", (Object[])new Object[0]));
            artifactory.disable();
        }
    }
}

