/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.hooks;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.hooks.CommandHook;

public final class CommandHooks
extends AbstractActivatable<CommandHooks>
implements Domain {
    private static final long serialVersionUID = 2902577556347608164L;
    private final List<CommandHook> before = new ArrayList<CommandHook>();
    private final List<CommandHook> success = new ArrayList<CommandHook>();
    private final List<CommandHook> failure = new ArrayList<CommandHook>();
    @JsonIgnore
    private final org.jreleaser.model.api.hooks.CommandHooks immutable = new org.jreleaser.model.api.hooks.CommandHooks(){
        private static final long serialVersionUID = 5109938718153117453L;
        private List<? extends org.jreleaser.model.api.hooks.CommandHook> before;
        private List<? extends org.jreleaser.model.api.hooks.CommandHook> success;
        private List<? extends org.jreleaser.model.api.hooks.CommandHook> failure;

        public List<? extends org.jreleaser.model.api.hooks.CommandHook> getBefore() {
            if (null == this.before) {
                this.before = CommandHooks.this.before.stream().map(CommandHook::asImmutable).collect(Collectors.toList());
            }
            return this.before;
        }

        public List<? extends org.jreleaser.model.api.hooks.CommandHook> getSuccess() {
            if (null == this.success) {
                this.success = CommandHooks.this.success.stream().map(CommandHook::asImmutable).collect(Collectors.toList());
            }
            return this.success;
        }

        public List<? extends org.jreleaser.model.api.hooks.CommandHook> getFailure() {
            if (null == this.failure) {
                this.failure = CommandHooks.this.failure.stream().map(CommandHook::asImmutable).collect(Collectors.toList());
            }
            return this.failure;
        }

        public Active getActive() {
            return CommandHooks.this.getActive();
        }

        public boolean isEnabled() {
            return CommandHooks.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(CommandHooks.this.asMap(full));
        }
    };

    public CommandHooks() {
        this.enabledSet(true);
    }

    public org.jreleaser.model.api.hooks.CommandHooks asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(CommandHooks source) {
        super.merge(source);
        this.setBefore(this.merge(this.before, source.before));
        this.setSuccess(this.merge(this.success, source.success));
        this.setFailure(this.merge(this.failure, source.failure));
    }

    @Override
    public boolean isSet() {
        return super.isSet() || !this.before.isEmpty() || !this.success.isEmpty() || !this.failure.isEmpty();
    }

    public List<CommandHook> getBefore() {
        return this.before;
    }

    public void setBefore(List<CommandHook> before) {
        this.before.clear();
        this.before.addAll(before);
    }

    public List<CommandHook> getSuccess() {
        return this.success;
    }

    public void setSuccess(List<CommandHook> success) {
        this.success.clear();
        this.success.addAll(success);
    }

    public List<CommandHook> getFailure() {
        return this.failure;
    }

    public void setFailure(List<CommandHook> failure) {
        this.failure.clear();
        this.failure.addAll(failure);
    }

    public void addBefore(CommandHook hook) {
        if (null != hook) {
            this.before.add(hook);
        }
    }

    public void addSuccess(CommandHook hook) {
        if (null != hook) {
            this.success.add(hook);
        }
    }

    public void addFailure(CommandHook hook) {
        if (null != hook) {
            this.failure.add(hook);
        }
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", this.getActive());
        LinkedHashMap<String, Map<String, Object>> m = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (CommandHook hook : this.getBefore()) {
            m.put("hook " + i++, hook.asMap(full));
        }
        map.put("before", m);
        m = new LinkedHashMap();
        i = 0;
        for (CommandHook hook : this.getSuccess()) {
            m.put("hook " + i++, hook.asMap(full));
        }
        map.put("success", m);
        m = new LinkedHashMap();
        i = 0;
        for (CommandHook hook : this.getFailure()) {
            m.put("hook " + i++, hook.asMap(full));
        }
        map.put("failure", m);
        return map;
    }
}

