/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collection;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.TwitterAnnouncer;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class TwitterAnnouncerValidator {
    private TwitterAnnouncerValidator() {
    }

    public static void validateTwitter(JReleaserContext context, TwitterAnnouncer twitter, Errors errors) {
        context.getLogger().debug("announce.twitter");
        Validator.resolveActivatable(context, (Activatable)twitter, "announce.twitter", "NEVER");
        if (!twitter.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        twitter.setConsumerKey(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.twitter.consumer.key", "TWITTER_CONSUMER_KEY"}), "announce.twitter.consumerKey", twitter.getConsumerKey(), errors, context.isDryrun()));
        twitter.setConsumerSecret(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.twitter.consumer.secret", "TWITTER_CONSUMER_SECRET"}), "announce.twitter.consumerSecret", twitter.getConsumerSecret(), errors, context.isDryrun()));
        twitter.setAccessToken(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.twitter.access.token", "TWITTER_ACCESS_TOKEN"}), "announce.twitter.accessToken", twitter.getAccessToken(), errors, context.isDryrun()));
        twitter.setAccessTokenSecret(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.twitter.access.token.secret", "TWITTER_ACCESS_TOKEN_SECRET"}), "announce.twitter.accessTokenSecret", twitter.getAccessTokenSecret(), errors, context.isDryrun()));
        if (StringUtils.isNotBlank((String)twitter.getStatusTemplate()) && !Files.exists(context.getBasedir().resolve(twitter.getStatusTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"twitter.statusTemplate", twitter.getStatusTemplate()}));
        }
        if (StringUtils.isBlank((String)twitter.getStatus()) && StringUtils.isBlank((String)twitter.getStatusTemplate()) && twitter.getStatuses().isEmpty()) {
            twitter.setStatus(RB.$((String)"default.release.message", (Object[])new Object[0]));
        }
        Validator.validateTimeout(twitter);
    }
}

