/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.upload;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.upload.FtpUploader;
import org.jreleaser.model.internal.validation.common.FtpValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class FtpUploaderValidator {
    private FtpUploaderValidator() {
    }

    public static void validateFtpUploader(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, FtpUploader> ftp = context.getModel().getUpload().getFtp();
        if (!ftp.isEmpty()) {
            context.getLogger().debug("upload.ftp");
        }
        for (Map.Entry<String, FtpUploader> e : ftp.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig()) continue;
            FtpUploaderValidator.validateFtp(context, e.getValue(), errors);
        }
    }

    private static void validateFtp(JReleaserContext context, FtpUploader ftp, Errors errors) {
        context.getLogger().debug("upload.ftp.{}", new Object[]{ftp.getName()});
        Validator.resolveActivatable(context, (Activatable)ftp, CollectionUtils.listOf((Object[])new String[]{"upload.ftp." + ftp.getName(), "upload.ftp"}), "NEVER");
        if (!ftp.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (!(ftp.isArtifacts() || ftp.isFiles() || ftp.isSignatures())) {
            errors.warning(RB.$((String)"WARNING.validation.uploader.no.artifacts", (Object[])new Object[]{ftp.getType(), ftp.getName()}));
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            ftp.disable();
            return;
        }
        FtpValidator.validateFtp(context, ftp, "upload", ftp.getName(), errors, context.isDryrun());
        if (StringUtils.isBlank((String)ftp.getPath())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"upload.ftp." + ftp.getName() + ".path"}));
        }
        Validator.validateTimeout(ftp);
    }
}

