/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.twitter;

import java.util.Objects;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.sdk.twitter.Twitter;
import org.jreleaser.sdk.twitter.TwitterCommand;
import org.jreleaser.util.StringUtils;

abstract class AbstractTwitterCommand
implements TwitterCommand {
    protected final boolean dryrun;
    protected final Twitter twitter;

    protected AbstractTwitterCommand(JReleaserLogger logger, String apiHost, int connectTimeout, int readTimeout, String consumerKey, String consumerToken, String accessToken, String accessTokenSecret, boolean dryrun) {
        this.twitter = new Twitter(logger, apiHost, connectTimeout, readTimeout, consumerKey, consumerToken, accessToken, accessTokenSecret, dryrun);
        this.dryrun = dryrun;
    }

    static class Builder<S extends Builder<S>> {
        protected final JReleaserLogger logger;
        protected boolean dryrun;
        protected String consumerKey;
        protected String consumerToken;
        protected String accessToken;
        protected String accessTokenSecret;
        protected String apiHost = "https://api.twitter.com/1.1/";
        protected int connectTimeout = 20;
        protected int readTimeout = 60;

        protected Builder(JReleaserLogger logger) {
            this.logger = Objects.requireNonNull(logger, "'logger' must not be null");
        }

        protected final S self() {
            return (S)this;
        }

        public S dryrun(boolean dryrun) {
            this.dryrun = dryrun;
            return this.self();
        }

        public S consumerKey(String consumerKey) {
            this.consumerKey = StringUtils.requireNonBlank((String)consumerKey, (String)"'consumerKey' must not be blank").trim();
            return this.self();
        }

        public S consumerToken(String consumerToken) {
            this.consumerToken = StringUtils.requireNonBlank((String)consumerToken, (String)"'consumerToken' must not be blank").trim();
            return this.self();
        }

        public S accessToken(String accessToken) {
            this.accessToken = StringUtils.requireNonBlank((String)accessToken, (String)"'accessToken' must not be blank").trim();
            return this.self();
        }

        public S accessTokenSecret(String accessTokenSecret) {
            this.accessTokenSecret = StringUtils.requireNonBlank((String)accessTokenSecret, (String)"'accessTokenSecret' must not be blank").trim();
            return this.self();
        }

        public S apiHost(String apiHost) {
            this.apiHost = StringUtils.requireNonBlank((String)apiHost, (String)"'apiHost' must not be blank").trim();
            return this.self();
        }

        public S connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this.self();
        }

        public S readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this.self();
        }

        protected void validate() {
            StringUtils.requireNonBlank((String)this.apiHost, (String)"'apiHost' must not be blank");
            StringUtils.requireNonBlank((String)this.consumerKey, (String)"'consumerKey' must not be blank");
            StringUtils.requireNonBlank((String)this.consumerToken, (String)"'consumerToken' must not be blank");
            StringUtils.requireNonBlank((String)this.accessToken, (String)"'accessToken' must not be blank");
            StringUtils.requireNonBlank((String)this.accessTokenSecret, (String)"'accessTokenSecret' must not be blank");
        }
    }
}

