/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.twitter;

import java.util.List;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.sdk.twitter.AbstractTwitterCommand;
import org.jreleaser.sdk.twitter.TwitterException;
import org.jreleaser.util.ObjectUtils;

public class UpdateStatusTwitterCommand
extends AbstractTwitterCommand {
    private final List<String> statuses;

    private UpdateStatusTwitterCommand(JReleaserLogger logger, String apiHost, int connectTimeout, int readTimeout, String consumerKey, String consumerToken, String accessToken, String accessTokenSecret, boolean dryrun, List<String> statuses) {
        super(logger, apiHost, connectTimeout, readTimeout, consumerKey, consumerToken, accessToken, accessTokenSecret, dryrun);
        this.statuses = statuses;
    }

    @Override
    public void execute() throws TwitterException {
        this.twitter.updateStatus(this.statuses);
    }

    public static Builder builder(JReleaserLogger logger) {
        return new Builder(logger);
    }

    public static class Builder
    extends AbstractTwitterCommand.Builder<Builder> {
        private List<String> statuses;

        protected Builder(JReleaserLogger logger) {
            super(logger);
        }

        public Builder statuses(List<String> statuses) {
            this.statuses = (List)ObjectUtils.requireNonEmpty(statuses, (String)"'statuses' must not be empty");
            return this;
        }

        public UpdateStatusTwitterCommand build() {
            this.validate();
            this.statuses = (List)ObjectUtils.requireNonEmpty(this.statuses, (String)"'statuses' must not be empty");
            return new UpdateStatusTwitterCommand(this.logger, this.apiHost, this.connectTimeout, this.readTimeout, this.consumerKey, this.consumerToken, this.accessToken, this.accessTokenSecret, this.dryrun, this.statuses);
        }
    }
}

