/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.assemblers;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.ZonedDateTime;
import org.jreleaser.assemblers.AbstractAssemblerProcessor;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Archive;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.ArchiveAssembler;
import org.jreleaser.model.spi.assemble.AssemblerProcessingException;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.PlatformUtils;

public class ArchiveAssemblerProcessor
extends AbstractAssemblerProcessor<org.jreleaser.model.api.assemble.ArchiveAssembler, ArchiveAssembler> {
    public ArchiveAssemblerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doAssemble(TemplateContext props) throws AssemblerProcessingException {
        Path assembleDirectory = (Path)props.get("distributionAssembleDirectory");
        String archiveName = ((ArchiveAssembler)this.assembler).getResolvedArchiveName(this.context);
        Path workDirectory = assembleDirectory.resolve("work");
        Path archiveDirectory = workDirectory.resolve(archiveName);
        try {
            FileUtils.deleteFiles((Path)workDirectory);
            Files.createDirectories(archiveDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_delete_archive", (Object[])new Object[]{archiveName}), (Throwable)e);
        }
        this.copyTemplates(this.context, props, archiveDirectory);
        this.context.getLogger().debug(RB.$((String)"assembler.copy.files", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(archiveDirectory)});
        this.copyArtifacts(this.context, archiveDirectory, PlatformUtils.getCurrentFull(), ((ArchiveAssembler)this.assembler).isAttachPlatform());
        this.copyFiles(this.context, archiveDirectory);
        this.copyFileSets(this.context, archiveDirectory);
        for (Archive.Format format : ((ArchiveAssembler)this.assembler).getFormats()) {
            this.archive(workDirectory, assembleDirectory, archiveName, format);
        }
    }

    private void archive(Path workDirectory, Path assembleDirectory, String archiveName, Archive.Format format) throws AssemblerProcessingException {
        String finalArchiveName = archiveName + "." + format.extension();
        this.context.getLogger().info("- {}", new Object[]{finalArchiveName});
        try {
            Path archiveFile = assembleDirectory.resolve(finalArchiveName);
            FileUtils.packArchive((Path)workDirectory, (Path)archiveFile, (ZonedDateTime)this.context.getModel().resolveArchiveTimestamp());
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }
}

