/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.git;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.UnsupportedSigningFormatException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.lib.GpgObjectSigner;
import org.eclipse.jgit.lib.GpgSignature;
import org.eclipse.jgit.lib.GpgSigner;
import org.eclipse.jgit.lib.ObjectBuilder;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Signing;
import org.jreleaser.model.api.signing.Keyring;
import org.jreleaser.model.api.signing.SigningException;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.signing.Signing;
import org.jreleaser.sdk.command.CommandException;
import org.jreleaser.sdk.signing.GpgCommandSigner;
import org.jreleaser.util.StringUtils;

public class JReleaserGpgSigner
extends GpgSigner
implements GpgObjectSigner {
    private final JReleaserContext context;
    private final boolean enabled;

    public JReleaserGpgSigner(JReleaserContext context, boolean enabled) {
        this.context = context;
        this.enabled = enabled;
    }

    public boolean canLocateSigningKey(String gpgSigningKey, PersonIdent committer, CredentialsProvider credentialsProvider, GpgConfig config) throws CanceledException, UnsupportedSigningFormatException {
        return this.enabled;
    }

    public boolean canLocateSigningKey(String gpgSigningKey, PersonIdent committer, CredentialsProvider credentialsProvider) throws CanceledException {
        return this.enabled;
    }

    public void sign(CommitBuilder commit, String gpgSigningKey, PersonIdent committer, CredentialsProvider credentialsProvider) throws CanceledException {
        if (!this.enabled) {
            return;
        }
        try {
            this.signObject((ObjectBuilder)commit, gpgSigningKey, committer, credentialsProvider, null);
        }
        catch (UnsupportedSigningFormatException unsupportedSigningFormatException) {
            // empty catch block
        }
    }

    public void signObject(ObjectBuilder object, String gpgSigningKey, PersonIdent committer, CredentialsProvider credentialsProvider, GpgConfig config) throws CanceledException, UnsupportedSigningFormatException {
        if (!this.enabled) {
            return;
        }
        try {
            if (this.context.getModel().getSigning().resolveMode() == Signing.Mode.COMMAND) {
                new CommandSigner(this.context).sign(object);
            } else {
                new BCSigner(this.context, committer).sign(object);
            }
        }
        catch (SigningException e) {
            throw new JGitInternalException(e.getMessage(), (Throwable)e);
        }
    }

    static {
        Provider bcProvider = Security.getProvider("BC");
        Security.removeProvider("BC");
        Security.setProperty("crypto.policy", "unlimited");
        Security.addProvider(null != bcProvider ? bcProvider : new BouncyCastleProvider());
    }

    private static class BCSigner
    extends AbstractSigner {
        private final PersonIdent committer;

        protected BCSigner(JReleaserContext context, PersonIdent committer) {
            super(context);
            this.committer = committer;
        }

        @Override
        public void sign(ObjectBuilder object) throws SigningException {
            Keyring keyring = this.context.createKeyring();
            PGPSignatureGenerator signatureGenerator = this.initSignatureGenerator(this.context.getModel().getSigning(), keyring);
            this.adjustCommitterId(signatureGenerator, this.committer, keyring);
            this.signObject(signatureGenerator, object);
        }

        private PGPSignatureGenerator initSignatureGenerator(Signing signing, Keyring keyring) throws SigningException {
            try {
                PGPSecretKey secretKey = keyring.readSecretKey();
                PGPPrivateKey privateKey = secretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider("BC").build(signing.getPassphrase().toCharArray()));
                PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)new JcaPGPContentSignerBuilder(secretKey.getPublicKey().getAlgorithm(), 8).setProvider("BC"));
                signatureGenerator.init(0, privateKey);
                return signatureGenerator;
            }
            catch (PGPException e) {
                throw new SigningException(RB.$((String)"ERROR_unexpected_error_signature_gen", (Object[])new Object[0]), (Throwable)e);
            }
        }

        private void adjustCommitterId(PGPSignatureGenerator signatureGenerator, PersonIdent committer, Keyring keyring) throws SigningException {
            String keyUserId;
            PGPPublicKey publicKey = keyring.readPublicKey();
            PGPSignatureSubpacketGenerator subpackets = new PGPSignatureSubpacketGenerator();
            subpackets.setIssuerFingerprint(false, publicKey);
            String userId = committer.getEmailAddress();
            Iterator userIds = publicKey.getUserIDs();
            if (userIds.hasNext() && StringUtils.isNotBlank((String)(keyUserId = (String)userIds.next())) && (StringUtils.isBlank((String)userId) || !keyUserId.contains(userId))) {
                userId = this.extractSignerId(keyUserId);
            }
            if (StringUtils.isNotBlank((String)userId)) {
                subpackets.addSignerUserID(false, userId);
            }
            signatureGenerator.setHashedSubpackets(subpackets.generate());
        }

        private String extractSignerId(String pgpUserId) {
            int to;
            int from = pgpUserId.indexOf(60);
            if (from >= 0 && (to = pgpUserId.indexOf(62, from + 1)) > from + 1) {
                return pgpUserId.substring(from + 1, to);
            }
            return pgpUserId;
        }

        private void signObject(PGPSignatureGenerator signatureGenerator, ObjectBuilder object) throws SigningException {
            try {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                try (BCPGOutputStream out = new BCPGOutputStream((OutputStream)new ArmoredOutputStream((OutputStream)buffer));){
                    signatureGenerator.update(object.build());
                    signatureGenerator.generate().encode((OutputStream)out);
                }
                object.setGpgSignature(new GpgSignature(buffer.toByteArray()));
            }
            catch (IOException | PGPException e) {
                throw new SigningException(e.getMessage(), e);
            }
        }
    }

    private static class CommandSigner
    extends AbstractSigner {
        protected CommandSigner(JReleaserContext context) {
            super(context);
        }

        @Override
        public void sign(ObjectBuilder object) throws SigningException {
            try {
                Signing signing = this.context.getModel().getSigning();
                GpgCommandSigner cmd = new GpgCommandSigner(this.context.getLogger());
                cmd.setExecutable(signing.getCommand().getExecutable());
                cmd.setPassphrase(signing.getPassphrase());
                cmd.setHomeDir(signing.getCommand().getHomeDir());
                cmd.setKeyName(signing.getCommand().getKeyName());
                cmd.setPublicKeyring(signing.getCommand().getPublicKeyring());
                cmd.setDefaultKeyring(signing.getCommand().isDefaultKeyring());
                cmd.setArgs(signing.getCommand().getArgs());
                object.setGpgSignature(new GpgSignature(cmd.sign(object.build())));
            }
            catch (IOException | CommandException e) {
                throw new SigningException(e.getMessage(), e);
            }
        }
    }

    private static abstract class AbstractSigner
    implements Signer {
        protected final JReleaserContext context;

        protected AbstractSigner(JReleaserContext context) {
            this.context = context;
        }
    }

    private static interface Signer {
        public void sign(ObjectBuilder var1) throws SigningException;
    }
}

