/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.telegram;

import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.announce.Announcer;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.sdk.telegram.TelegramException;
import org.jreleaser.sdk.telegram.TelegramSdk;
import org.jreleaser.util.StringUtils;

public class TelegramAnnouncer
implements Announcer<org.jreleaser.model.api.announce.TelegramAnnouncer> {
    private final JReleaserContext context;
    private final org.jreleaser.model.internal.announce.TelegramAnnouncer telegram;

    public TelegramAnnouncer(JReleaserContext context) {
        this.context = context;
        this.telegram = context.getModel().getAnnounce().getTelegram();
    }

    public org.jreleaser.model.api.announce.TelegramAnnouncer getAnnouncer() {
        return this.telegram.asImmutable();
    }

    public String getName() {
        return "telegram";
    }

    public boolean isEnabled() {
        return this.telegram.isEnabled();
    }

    public void announce() throws AnnounceException {
        String message = "";
        if (StringUtils.isNotBlank((String)this.telegram.getMessage())) {
            message = this.telegram.getResolvedMessage(this.context);
        } else {
            TemplateContext props = new TemplateContext();
            this.context.getModel().getRelease().getReleaser().fillProps(props, this.context.getModel());
            message = this.telegram.getResolvedMessageTemplate(this.context, props);
        }
        String chatId = this.telegram.getChatId();
        this.context.getLogger().info("message: {}", new Object[]{message});
        try {
            TelegramSdk sdk = TelegramSdk.builder(this.context.getLogger()).token(this.telegram.getToken()).connectTimeout(this.telegram.getConnectTimeout()).readTimeout(this.telegram.getReadTimeout()).dryrun(this.context.isDryrun()).build();
            sdk.sendMessage(chatId, message);
        }
        catch (TelegramException e) {
            throw new AnnounceException((Throwable)e);
        }
    }
}

