/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.command;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.sdk.command.Command;
import org.jreleaser.sdk.command.CommandException;
import org.jreleaser.util.IoUtils;

public class CommandExecutor {
    private final JReleaserLogger logger;
    private final Output output;
    private final Map<String, String> environment = new LinkedHashMap<String, String>();

    public CommandExecutor(JReleaserLogger logger) {
        this(logger, Output.DEBUG);
    }

    public CommandExecutor(JReleaserLogger logger, Output output) {
        this.logger = logger;
        this.output = output;
    }

    public CommandExecutor environment(Map<String, String> env) {
        this.environment.putAll(env);
        return this;
    }

    public CommandExecutor environment(String name, String value) {
        this.environment.put(name, value);
        return this;
    }

    private Command.Result executeCommand(ProcessExecutor processExecutor) throws CommandException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            int exitValue = processExecutor.execute(this.logger, this.output, out, err);
            return Command.Result.of(IoUtils.toString((ByteArrayOutputStream)out), IoUtils.toString((ByteArrayOutputStream)err), exitValue);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CommandException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), e);
        }
        catch (Exception e) {
            throw new CommandException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), e);
        }
    }

    public Command.Result executeCommand(Command command) throws CommandException {
        return this.executeCommand(this.createProcessExecutor(command));
    }

    public Command.Result executeCommand(Path directory, Command command) throws CommandException {
        return this.executeCommand(this.createProcessExecutor(command).directory(directory.toFile()));
    }

    public Command.Result executeCommand(Command command, InputStream in) throws CommandException {
        return this.executeCommand(this.createProcessExecutor(command).redirectInput(in));
    }

    public Command.Result executeCommand(Path directory, Command command, InputStream in) throws CommandException {
        return this.executeCommand(this.createProcessExecutor(command).redirectInput(in).directory(directory.toFile()));
    }

    private ProcessExecutor createProcessExecutor(Command command) throws CommandException {
        try {
            return new ProcessExecutor(command, this.environment);
        }
        catch (IOException e) {
            throw new CommandException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), e);
        }
    }

    private static class ProcessExecutor {
        private final ProcessBuilder builder;
        private InputStream input;
        private static final ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(2, new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                t.setName("jreleaser-command-executor-" + this.counter.getAndIncrement());
                return t;
            }
        });

        private ProcessExecutor(Command command, Map<String, String> environment) throws IOException {
            this.builder = new ProcessBuilder(command.asCommandLine());
            this.builder.environment().putAll(environment);
        }

        private ProcessExecutor directory(File directory) {
            this.builder.directory(directory);
            return this;
        }

        private ProcessExecutor redirectInput(InputStream input) {
            this.input = input;
            return this;
        }

        private int execute(JReleaserLogger logger, Output output, OutputStream out, OutputStream err) throws IOException, InterruptedException {
            Process process = this.builder.start();
            if (null != this.input) {
                PrintWriter writer = IoUtils.newPrintWriter((OutputStream)process.getOutputStream(), (boolean)true);
                IoUtils.withInputStream((InputStream)this.input, writer::write);
                writer.println();
            }
            IOException[] outException = this.handleStream(process.getInputStream(), out, s -> {
                switch (output) {
                    case DEBUG: {
                        logger.debug(s);
                        break;
                    }
                    case VERBOSE: {
                        logger.plain(s);
                        break;
                    }
                }
            });
            IOException[] errException = this.handleStream(process.getErrorStream(), err, s -> {
                switch (output) {
                    case DEBUG: 
                    case VERBOSE: {
                        logger.error(s);
                        break;
                    }
                }
            });
            int exitValue = process.waitFor();
            if (null != outException[0]) {
                throw outException[0];
            }
            if (null != errException[0]) {
                throw errException[0];
            }
            return exitValue;
        }

        private IOException[] handleStream(InputStream input, OutputStream target, Consumer<? super String> log) {
            IOException[] capture = new IOException[1];
            EXECUTOR_SERVICE.submit(() -> {
                try {
                    PrintWriter writer = IoUtils.newPrintWriter((OutputStream)target, (boolean)true);
                    IoUtils.withLines((InputStream)input, s -> {
                        log.accept((String)s);
                        writer.println((String)s);
                    });
                }
                catch (IOException e) {
                    capture[0] = e;
                }
            });
            return capture;
        }
    }

    public static enum Output {
        QUIET,
        DEBUG,
        VERBOSE;

    }
}

