/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.extensions.internal;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.jreleaser.bundle.RB;
import org.jreleaser.extensions.api.Extension;
import org.jreleaser.extensions.api.ExtensionManager;
import org.jreleaser.extensions.api.ExtensionPoint;
import org.jreleaser.extensions.api.workflow.WorkflowListener;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.sdk.command.CommandException;
import org.jreleaser.sdk.tool.Mvn;
import org.jreleaser.sdk.tool.ToolException;
import org.jreleaser.templates.TemplateResource;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.DefaultVersions;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.StringUtils;

public final class DefaultExtensionManager
implements ExtensionManager {
    private final Map<String, ExtensionDef> extensionDefs = new LinkedHashMap<String, ExtensionDef>();
    private final Set<ExtensionPoint> allExtensionPoints = new LinkedHashSet<ExtensionPoint>();
    private final Map<String, Set<ExtensionPoint>> extensionPoints = new LinkedHashMap<String, Set<ExtensionPoint>>();

    public ExtensionBuilder configureExtension(String name) {
        return new ExtensionBuilder(name, this);
    }

    public void load(JReleaserContext context) {
        this.extensionPoints.clear();
        this.allExtensionPoints.clear();
        LinkedHashSet<String> visitedExtensionNames = new LinkedHashSet<String>();
        LinkedHashSet<String> visitedExtensionTypes = new LinkedHashSet<String>();
        for (Extension extension : DefaultExtensionManager.resolveServiceLoader()) {
            this.processExtension(context, extension, visitedExtensionNames, visitedExtensionTypes);
        }
        for (Map.Entry entry : this.extensionDefs.entrySet()) {
            String extensionName = (String)entry.getKey();
            ExtensionDef extensionDef = (ExtensionDef)entry.getValue();
            if (visitedExtensionNames.contains(extensionName)) continue;
            if (!extensionDef.isEnabled()) {
                context.getLogger().debug(RB.$((String)"extension.manager.disabled", (Object[])new Object[]{extensionName}));
                return;
            }
            this.createClassLoader(context, extensionDef).ifPresent(classLoader -> {
                for (Extension extension : ServiceLoader.load(Extension.class, classLoader)) {
                    this.processExtension(context, extension, visitedExtensionNames, visitedExtensionTypes);
                }
            });
        }
        context.setWorkflowListeners(this.findExtensionPoints(WorkflowListener.class));
    }

    public <T extends ExtensionPoint> Set<T> findExtensionPoints(Class<T> extensionPointType) {
        return this.extensionPoints.computeIfAbsent(extensionPointType.getName(), k -> {
            LinkedHashSet<ExtensionPoint> set = new LinkedHashSet<ExtensionPoint>();
            for (ExtensionPoint extensionPoint : this.allExtensionPoints) {
                if (!extensionPointType.isAssignableFrom(extensionPoint.getClass())) continue;
                set.add(extensionPoint);
            }
            return Collections.unmodifiableSet(set);
        });
    }

    private Optional<ClassLoader> createClassLoader(JReleaserContext context, ExtensionDef extensionDef) {
        Path directoryPath;
        String directory = extensionDef.getDirectory();
        if (StringUtils.isNotBlank((String)extensionDef.getGav())) {
            directory = this.resolveJARs(context, extensionDef);
        }
        if (!(directoryPath = Paths.get(directory, new String[0])).isAbsolute()) {
            directoryPath = context.getBasedir().resolve(directoryPath);
        }
        if (!Files.exists(directoryPath, new LinkOption[0])) {
            context.getLogger().warn(RB.$((String)"extension.manager.load.directory.missing", (Object[])new Object[]{extensionDef.getName(), directoryPath.toAbsolutePath()}));
            return Optional.empty();
        }
        List jars = null;
        try (Stream<Path> jarPaths = Files.list(directoryPath);){
            jars = jarPaths.filter(path -> path.getFileName().toString().endsWith(".jar")).collect(Collectors.toList());
        }
        catch (IOException e) {
            context.getLogger().trace((Throwable)e);
            context.getLogger().warn(RB.$((String)"extension.manager.load.directory.error", (Object[])new Object[]{extensionDef.getName(), directoryPath.toAbsolutePath()}));
            return Optional.empty();
        }
        if (jars.isEmpty()) {
            context.getLogger().warn(RB.$((String)"extension.manager.load.empty.jars", (Object[])new Object[]{extensionDef.getName(), directoryPath.toAbsolutePath()}));
            return Optional.empty();
        }
        URL[] urls = new URL[jars.size()];
        for (int i = 0; i < jars.size(); ++i) {
            Path jar = (Path)jars.get(i);
            try {
                urls[i] = jar.toUri().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                context.getLogger().trace((Throwable)e);
                context.getLogger().warn(RB.$((String)"extension.manager.load.jar.error", (Object[])new Object[]{extensionDef.getName(), jar.toAbsolutePath()}));
                return Optional.empty();
            }
        }
        return Optional.of(new URLClassLoader(urls, this.getClass().getClassLoader()));
    }

    private String resolveJARs(JReleaserContext context, ExtensionDef extensionDef) {
        Path target = context.getOutputDirectory().resolve("extensions").resolve(extensionDef.getName()).toAbsolutePath();
        Mvn mvn = new Mvn(context.asImmutable(), DefaultVersions.getInstance().getMvnVersion());
        try {
            if (!mvn.setup()) {
                throw new JReleaserException(RB.$((String)"tool_unavailable", (Object[])new Object[]{"mvn"}));
            }
        }
        catch (ToolException e) {
            throw new JReleaserException(RB.$((String)"tool_unavailable", (Object[])new Object[]{"mvn"}), (Throwable)e);
        }
        try {
            FileUtils.deleteFiles((Path)target, (boolean)true);
            Path pom = Files.createTempFile("jreleaser-extensions", "pom.xml", new FileAttribute[0]);
            TemplateResource template = TemplateUtils.resolveTemplate((JReleaserLogger)context.getLogger(), (String)"extensions/pom.xml.tpl");
            String[] gav = extensionDef.getGav().split(":");
            String content = IOUtils.toString((Reader)template.getReader());
            content = content.replace("@groupId@", gav[0]).replace("@artifactId@", gav[1]).replace("@version@", gav[2]);
            Files.write(pom, content.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            ArrayList<String> args = new ArrayList<String>();
            args.add("-B");
            args.add("-q");
            args.add("-f");
            args.add(pom.toAbsolutePath().toString());
            args.add("dependency:resolve");
            context.getLogger().debug(RB.$((String)"extension.manager.resolve.jars", (Object[])new Object[]{extensionDef.getGav()}));
            mvn.invoke(context.getBasedir(), args);
            args.clear();
            args.add("-B");
            args.add("-q");
            args.add("-f");
            args.add(pom.toAbsolutePath().toString());
            args.add("dependency:copy-dependencies");
            args.add("-DoutputDirectory=" + target);
            context.getLogger().debug(RB.$((String)"extension.manager.copy.jars", (Object[])new Object[]{extensionDef.getGav(), context.relativizeToBasedir(target)}));
            mvn.invoke(context.getBasedir(), args);
        }
        catch (IOException | CommandException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), e);
        }
        return target.toString();
    }

    private void processExtension(JReleaserContext context, Extension extension, Set<String> visitedExtensionNames, Set<String> visitedExtensionTypes) {
        String extensionName = extension.getName();
        String extensionType = extension.getClass().getName();
        if (visitedExtensionNames.contains(extensionName) || visitedExtensionTypes.contains(extensionType)) {
            return;
        }
        context.getLogger().debug(RB.$((String)"extension.manager.load", (Object[])new Object[]{extensionName, extensionType}));
        visitedExtensionNames.add(extensionName);
        visitedExtensionTypes.add(extensionType);
        ExtensionDef extensionDef = this.extensionDefs.get(extensionName);
        if (null != extensionDef && !extensionDef.isEnabled()) {
            context.getLogger().debug(RB.$((String)"extension.manager.disabled", (Object[])new Object[]{extensionName}));
            return;
        }
        for (ExtensionPoint extensionPoint : extension.provides()) {
            String extensionPointTypeName = extensionPoint.getClass().getName();
            if (null != extensionDef && extensionDef.getExtensionPoints().containsKey(extensionPointTypeName)) {
                extensionPoint.init(context.asImmutable(), ((ExtensionPointDef)extensionDef.getExtensionPoints().get(extensionPointTypeName)).getProperties());
            } else {
                extensionPoint.init(context.asImmutable(), Collections.emptyMap());
            }
            context.getLogger().debug(RB.$((String)"extension.manager.add.extension.point", (Object[])new Object[]{extensionPointTypeName, extensionName}));
            this.allExtensionPoints.add(extensionPoint);
        }
    }

    private static ServiceLoader<Extension> resolveServiceLoader() {
        ServiceLoader<Extension> handlers = ServiceLoader.load(Extension.class, Extension.class.getClassLoader());
        if (handlers.iterator().hasNext()) {
            return handlers;
        }
        return ServiceLoader.load(Extension.class);
    }

    public static class ExtensionBuilder {
        private final Map<String, ExtensionPointDef> extensionPoints = new LinkedHashMap<String, ExtensionPointDef>();
        private final String name;
        private final DefaultExtensionManager defaultExtensionManager;
        private String gav;
        private String directory;
        private boolean enabled;

        public ExtensionBuilder(String name, DefaultExtensionManager defaultExtensionManager) {
            this.name = name;
            this.defaultExtensionManager = defaultExtensionManager;
            String jreleaserHome = System.getenv("JRELEASER_USER_HOME");
            if (StringUtils.isBlank((String)jreleaserHome)) {
                jreleaserHome = System.getProperty("user.home") + File.separator + ".jreleaser";
            }
            Path baseExtensionsDirectory = Paths.get(jreleaserHome, new String[0]).resolve("extensions");
            this.directory = baseExtensionsDirectory.resolve(name).toAbsolutePath().toString();
        }

        public ExtensionBuilder withGav(String gav) {
            this.gav = gav;
            return this;
        }

        public ExtensionBuilder withDirectory(String directory) {
            this.directory = directory;
            return this;
        }

        public ExtensionBuilder withEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public ExtensionBuilder withExtensionPoint(String type, Map<String, Object> properties) {
            this.extensionPoints.put(type, new ExtensionPointDef(type, properties));
            return this;
        }

        public void build() {
            this.defaultExtensionManager.extensionDefs.put(this.name, new ExtensionDef(this.name, this.directory, this.gav, this.enabled, this.extensionPoints));
        }
    }

    private static class ExtensionPointDef {
        private final String type;
        private final Map<String, Object> properties = new LinkedHashMap<String, Object>();

        private ExtensionPointDef(String type, Map<String, Object> properties) {
            this.type = type;
            this.properties.putAll(properties);
        }

        private String getType() {
            return this.type;
        }

        private Map<String, Object> getProperties() {
            return this.properties;
        }
    }

    private static class ExtensionDef {
        private final String name;
        private final String gav;
        private final String directory;
        private final boolean enabled;
        private final Map<String, ExtensionPointDef> extensionPoints = new LinkedHashMap<String, ExtensionPointDef>();

        private ExtensionDef(String name, String directory, String gav, boolean enabled, Map<String, ExtensionPointDef> extensionPoints) {
            this.name = name;
            this.gav = gav;
            this.directory = directory;
            this.enabled = enabled;
            this.extensionPoints.putAll(extensionPoints);
        }

        private String getName() {
            return this.name;
        }

        public String getGav() {
            return this.gav;
        }

        private String getDirectory() {
            return this.directory;
        }

        private boolean isEnabled() {
            return this.enabled;
        }

        private Map<String, ExtensionPointDef> getExtensionPoints() {
            return this.extensionPoints;
        }
    }
}

