/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.MethodScope;
import com.github.victools.jsonschema.generator.TypeContext;
import com.github.victools.jsonschema.generator.impl.LazyValue;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class FieldScope
extends MemberScope<ResolvedField, Field> {
    private final LazyValue<MethodScope> getter = new LazyValue<MethodScope>(this::doFindGetter);

    protected FieldScope(ResolvedField field, ResolvedTypeWithMembers declaringTypeMembers, TypeContext context) {
        this(field, (ResolvedType)null, (String)null, declaringTypeMembers, (Integer)null, context);
    }

    protected FieldScope(ResolvedField field, ResolvedType overriddenType, String overriddenName, ResolvedTypeWithMembers declaringTypeMembers, Integer fakeContainerItemIndex, TypeContext context) {
        super(field, overriddenType, overriddenName, declaringTypeMembers, fakeContainerItemIndex, context);
    }

    public FieldScope withOverriddenType(ResolvedType overriddenType) {
        return new FieldScope((ResolvedField)this.getMember(), overriddenType, this.getOverriddenName(), this.getDeclaringTypeMembers(), this.getFakeContainerItemIndex(), this.getContext());
    }

    public FieldScope withOverriddenName(String overriddenName) {
        return new FieldScope((ResolvedField)this.getMember(), this.getOverriddenType(), overriddenName, this.getDeclaringTypeMembers(), this.getFakeContainerItemIndex(), this.getContext());
    }

    public FieldScope asFakeContainerItemScope() {
        return (FieldScope)super.asFakeContainerItemScope();
    }

    @Override
    protected String doGetSchemaPropertyName() {
        return this.getName();
    }

    public boolean isTransient() {
        return ((ResolvedField)this.getMember()).isTransient();
    }

    public MethodScope findGetter() {
        return this.getter.get();
    }

    private MethodScope doFindGetter() {
        String declaredName = this.getDeclaredName();
        HashSet<String> possibleGetterNames = new HashSet<String>(5);
        if (declaredName.length() > 1 && Character.isUpperCase(declaredName.charAt(1))) {
            possibleGetterNames.add("get" + declaredName);
            possibleGetterNames.add("is" + declaredName);
        }
        String capitalisedFieldName = declaredName.substring(0, 1).toUpperCase() + declaredName.substring(1);
        possibleGetterNames.add("get" + capitalisedFieldName);
        possibleGetterNames.add("is" + capitalisedFieldName);
        if (declaredName.startsWith("is") && declaredName.length() > 2 && Character.isUpperCase(declaredName.charAt(2))) {
            possibleGetterNames.add(declaredName);
        }
        ResolvedMethod[] methods = this.getDeclaringTypeMembers().getMemberMethods();
        return Stream.of(methods).filter(method -> method.isPublic() && ((Method)method.getRawMember()).getParameterCount() == 0).filter(method -> possibleGetterNames.contains(method.getName())).findFirst().map(method -> this.getContext().createMethodScope((ResolvedMethod)method, this.getDeclaringTypeMembers())).orElse(null);
    }

    public boolean hasGetter() {
        return this.findGetter() != null;
    }

    @Override
    public <A extends Annotation> A getContainerItemAnnotation(Class<A> annotationClass, Predicate<Annotation> considerOtherAnnotation) {
        AnnotatedType annotatedType = ((Field)this.getRawMember()).getAnnotatedType();
        return this.getContext().getTypeParameterAnnotation(annotationClass, considerOtherAnnotation, annotatedType, this.getFakeContainerItemIndex());
    }

    @Override
    public <A extends Annotation> A getAnnotationConsideringFieldAndGetter(Class<A> annotationClass, Predicate<Annotation> considerOtherAnnotation) {
        A annotation = this.getAnnotation(annotationClass, considerOtherAnnotation);
        if (annotation == null) {
            MethodScope associatedGetter = this.findGetter();
            annotation = associatedGetter == null ? null : ((MemberScope)associatedGetter).getAnnotation(annotationClass, considerOtherAnnotation);
        }
        return annotation;
    }

    @Override
    public <A extends Annotation> A getContainerItemAnnotationConsideringFieldAndGetter(Class<A> annotationClass, Predicate<Annotation> considerOtherAnnotation) {
        A annotation = this.getContainerItemAnnotation(annotationClass, considerOtherAnnotation);
        if (annotation == null) {
            MethodScope associatedGetter = this.findGetter();
            annotation = associatedGetter == null ? null : ((MemberScope)associatedGetter).getContainerItemAnnotation(annotationClass, considerOtherAnnotation);
        }
        return annotation;
    }
}

