/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint;

import com.github.sbaudoin.yamllint.LintScanner;
import com.github.sbaudoin.yamllint.LintStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.yaml.snakeyaml.scanner.ScannerException;
import org.yaml.snakeyaml.tokens.StreamEndToken;
import org.yaml.snakeyaml.tokens.StreamStartToken;

public class Parser {
    private Parser() {
    }

    public static List<Line> getLines(String buffer) {
        ArrayList<Line> lines = new ArrayList<Line>();
        int lineNo = 1;
        int cur = 0;
        int next = buffer.indexOf(10);
        while (next != -1) {
            lines.add(new Line(lineNo, buffer, cur, next));
            cur = next + 1;
            next = buffer.indexOf(10, cur);
            ++lineNo;
        }
        lines.add(new Line(lineNo, buffer, cur, buffer.length()));
        return lines;
    }

    public static List<Comment> commentsBetweenTokens(org.yaml.snakeyaml.tokens.Token token1, @Nullable org.yaml.snakeyaml.tokens.Token token2) {
        String buf;
        ArrayList<Comment> comments = new ArrayList<Comment>();
        if (token2 == null) {
            buf = Parser.toString(Arrays.copyOfRange(token1.getEndMark().getBuffer(), token1.getEndMark().getPointer(), token1.getEndMark().getBuffer().length));
        } else {
            if (token1.getEndMark().getLine() == token2.getStartMark().getLine() && !(token1 instanceof StreamStartToken) && !(token2 instanceof StreamEndToken)) {
                return comments;
            }
            buf = Parser.toString(Arrays.copyOfRange(token1.getEndMark().getBuffer(), token1.getEndMark().getPointer(), token2.getStartMark().getPointer()));
        }
        int lineNo = token1.getEndMark().getLine() + 1;
        int columnNo = token1.getEndMark().getColumn() + 1;
        int pointer = token1.getEndMark().getPointer();
        Comment commentBefore = null;
        for (String line : buf.split("\n")) {
            int pos = line.indexOf(35);
            if (pos != -1) {
                Comment comment = new Comment(lineNo, columnNo + pos, Parser.toString(token1.getEndMark().getBuffer()), pointer + pos, token1, token2, commentBefore);
                comments.add(comment);
                commentBefore = comment;
            }
            pointer += line.length() + 1;
            ++lineNo;
            columnNo = 1;
        }
        return comments;
    }

    public static List<Lined> getTokensOrComments(String buffer) {
        LintScanner yamlLoader = new LintScanner(new LintStreamReader(buffer));
        ArrayList<Lined> tokensOrComments = new ArrayList<Lined>();
        try {
            org.yaml.snakeyaml.tokens.Token prev = null;
            org.yaml.snakeyaml.tokens.Token curr = yamlLoader.getToken();
            while (curr != null) {
                org.yaml.snakeyaml.tokens.Token next = yamlLoader.getToken();
                org.yaml.snakeyaml.tokens.Token nextnext = yamlLoader.peekToken();
                tokensOrComments.add(new Token(curr.getStartMark().getLine() + 1, curr, prev, next, nextnext));
                tokensOrComments.addAll(Parser.commentsBetweenTokens(curr, next));
                prev = curr;
                curr = next;
            }
        }
        catch (ScannerException scannerException) {
            // empty catch block
        }
        return tokensOrComments;
    }

    public static List<Lined> getTokensOrCommentsOrLines(String buffer) {
        Line line;
        ArrayList<Lined> objects = new ArrayList<Lined>();
        Iterator<Lined> tokensOrComments = Parser.getTokensOrComments(buffer).iterator();
        Iterator<Line> lines = Parser.getLines(buffer).iterator();
        Lined tokenOrComment = tokensOrComments.hasNext() ? tokensOrComments.next() : null;
        Line line2 = line = lines.hasNext() ? lines.next() : null;
        while (tokenOrComment != null || line != null) {
            if (tokenOrComment == null || line != null && tokenOrComment.getLineNo() > line.lineNo) {
                objects.add(line);
                line = lines.hasNext() ? lines.next() : null;
                continue;
            }
            objects.add(tokenOrComment);
            tokenOrComment = tokensOrComments.hasNext() ? tokensOrComments.next() : null;
        }
        return objects;
    }

    private static String toString(int[] array) {
        StringBuilder sb = new StringBuilder();
        Arrays.stream(array).forEach(i -> sb.append((char)i));
        return sb.toString();
    }

    public static class Comment
    implements Lined {
        private int lineNo;
        private int columnNo;
        private int pointer;
        private String buffer;
        private org.yaml.snakeyaml.tokens.Token tokenBefore;
        private org.yaml.snakeyaml.tokens.Token tokenAfter;
        private Comment commentBefore;

        public Comment(int lineNo, int columnNo, String buffer, int pointer, org.yaml.snakeyaml.tokens.Token tokenBefore, org.yaml.snakeyaml.tokens.Token tokenAfter, Comment commentBefore) {
            this.lineNo = lineNo;
            this.columnNo = columnNo;
            this.buffer = buffer;
            this.pointer = pointer;
            this.tokenBefore = tokenBefore;
            this.tokenAfter = tokenAfter;
            this.commentBefore = commentBefore;
        }

        public String toString() {
            int end = this.buffer.indexOf(10, this.pointer);
            if (end == -1) {
                end = this.buffer.indexOf(0, this.pointer);
            }
            if (end != -1) {
                return this.buffer.substring(this.pointer, end);
            }
            return this.buffer.substring(this.pointer);
        }

        public boolean equals(Object other) {
            return other instanceof Comment && this.lineNo == ((Comment)other).lineNo && this.columnNo == ((Comment)other).columnNo && this.toString().equals(other.toString());
        }

        public int hashCode() {
            return (this.lineNo + ":" + this.columnNo + ":" + this.toString()).hashCode();
        }

        public boolean isInline() {
            return !(this.tokenBefore instanceof StreamStartToken) && this.lineNo == this.tokenBefore.getEndMark().getLine() + 1 && this.buffer.charAt(this.tokenBefore.getEndMark().getPointer() - 1) != '\n';
        }

        @Override
        public int getLineNo() {
            return this.lineNo;
        }

        public int getColumnNo() {
            return this.columnNo;
        }

        public int getPointer() {
            return this.pointer;
        }

        public org.yaml.snakeyaml.tokens.Token getTokenBefore() {
            return this.tokenBefore;
        }

        public org.yaml.snakeyaml.tokens.Token getTokenAfter() {
            return this.tokenAfter;
        }

        public Comment getCommentBefore() {
            return this.commentBefore;
        }

        public String getBuffer() {
            return this.buffer;
        }
    }

    public static class Token
    implements Lined {
        private int lineNo;
        private org.yaml.snakeyaml.tokens.Token curr;
        private org.yaml.snakeyaml.tokens.Token prev;
        private org.yaml.snakeyaml.tokens.Token next;
        private org.yaml.snakeyaml.tokens.Token nextnext;

        public Token(int lineNo, org.yaml.snakeyaml.tokens.Token curr, org.yaml.snakeyaml.tokens.Token prev, org.yaml.snakeyaml.tokens.Token next, org.yaml.snakeyaml.tokens.Token nextnext) {
            this.lineNo = lineNo;
            this.curr = curr;
            this.prev = prev;
            this.next = next;
            this.nextnext = nextnext;
        }

        @Override
        public int getLineNo() {
            return this.lineNo;
        }

        public org.yaml.snakeyaml.tokens.Token getCurr() {
            return this.curr;
        }

        public org.yaml.snakeyaml.tokens.Token getPrev() {
            return this.prev;
        }

        public org.yaml.snakeyaml.tokens.Token getNext() {
            return this.next;
        }

        public org.yaml.snakeyaml.tokens.Token getNextNext() {
            return this.nextnext;
        }
    }

    public static class Line
    implements Lined {
        private int lineNo;
        private int start;
        private int end;
        private String buffer;

        public Line(int lineNo, String buffer, int start, int end) {
            this.lineNo = lineNo;
            this.start = start;
            this.end = end;
            this.buffer = buffer;
        }

        public String getContent() {
            return this.buffer.substring(this.start, this.end);
        }

        @Override
        public int getLineNo() {
            return this.lineNo;
        }

        public int getEnd() {
            return this.end;
        }

        public int getStart() {
            return this.start;
        }

        public String getBuffer() {
            return this.buffer;
        }
    }

    public static interface Lined {
        public int getLineNo();
    }
}

