/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.googlechat;

import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.WebhookAnnouncer;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.announce.Announcer;
import org.jreleaser.sdk.webhooks.WebhooksAnnouncer;

public class GoogleChatAnnouncer
implements Announcer<org.jreleaser.model.api.announce.GoogleChatAnnouncer> {
    private final JReleaserContext context;
    private final org.jreleaser.model.internal.announce.GoogleChatAnnouncer googleChat;

    public GoogleChatAnnouncer(JReleaserContext context) {
        this.context = context;
        this.googleChat = context.getModel().getAnnounce().getGoogleChat();
    }

    public org.jreleaser.model.api.announce.GoogleChatAnnouncer getAnnouncer() {
        return this.googleChat.asImmutable();
    }

    public String getName() {
        return "googlechat";
    }

    public boolean isEnabled() {
        return this.googleChat.isEnabled();
    }

    public void announce() throws AnnounceException {
        this.context.getLogger().setPrefix("webhook." + this.getName());
        try {
            WebhooksAnnouncer.announce((JReleaserContext)this.context, (WebhookAnnouncer)this.googleChat.asWebhookAnnouncer(), (boolean)false);
        }
        catch (AnnounceException x) {
            this.context.getLogger().warn(x.getMessage().trim());
        }
        finally {
            this.context.getLogger().restorePrefix();
        }
    }
}

