/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.LightClassUtil$getPsiMethodWrappers$;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.elements.KotlinLightTypeParameterListBuilder;
import org.jetbrains.kotlin.asJava.elements.KtLightElement;
import org.jetbrains.kotlin.asJava.elements.KtLightField;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.asJava.elements.KtLightMethodImplKt;
import org.jetbrains.kotlin.asJava.elements.KtLightTypeParameter;
import org.jetbrains.kotlin.asJava.finder.JavaElementFinder;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiNamedElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterListOwner;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiClassStub;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0002J,\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0016\u0010\u0015\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0017\u0012\u0004\u0012\u00020\n0\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001f2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\"\u001a\u0004\u0018\u00010\u000f2\u0006\u0010#\u001a\u00020$J\u0010\u0010\"\u001a\u0004\u0018\u00010\u000f2\u0006\u0010%\u001a\u00020&J\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001f2\u0006\u0010#\u001a\u00020$J\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010#\u001a\u00020$2\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020\f2\u0006\u0010%\u001a\u00020&J\u000e\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020/J\u0010\u00100\u001a\u0004\u0018\u00010!2\u0006\u00101\u001a\u000202J\u0012\u00103\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\"\u00104\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010,H\u0002J\u0012\u00105\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u00106\u001a\b\u0012\u0004\u0012\u00020\u00120)2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/asJava/LightClassUtil;", "", "()V", "buildLightTypeParameterList", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiTypeParameterList;", "owner", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiTypeParameterListOwner;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "canGenerateLightClass", "", "extractPropertyAccessors", "Lorg/jetbrains/kotlin/asJava/LightClassUtil$PropertyAccessorsPsiMethods;", "ktDeclaration", "specialGetter", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiMethod;", "specialSetter", "findClass", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiClass;", "stub", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/StubElement;", "predicate", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/PsiClassStub;", "findFileFacade", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getLightClassAccessorMethod", "accessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "getLightClassAccessorMethods", "", "getLightClassBackingField", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiField;", "getLightClassMethod", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "getLightClassMethods", "getLightClassMethodsByName", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/asJava/elements/KtLightMethod;", "name", "", "getLightClassPropertyMethods", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "getLightFieldForCompanionObject", "companionObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getPsiMethodWrapper", "getPsiMethodWrappers", "getWrappingClass", "getWrappingClasses", "PropertyAccessorsPsiMethods", "light-classes"})
public final class LightClassUtil {
    @NotNull
    public static final LightClassUtil INSTANCE = new LightClassUtil();

    private LightClassUtil() {
    }

    @Nullable
    public final PsiClass findClass(@NotNull StubElement<?> stub2, @NotNull Function1<? super PsiClassStub<?>, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(stub2, "stub");
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        if (stub2 instanceof PsiClassStub && predicate.invoke((PsiClassStub<?>)stub2).booleanValue()) {
            return (PsiClass)((PsiClassStub)stub2).getPsi();
        }
        if (stub2 instanceof PsiClassStub || stub2 instanceof PsiFileStub) {
            for (StubElement child : stub2.getChildrenStubs()) {
                Intrinsics.checkNotNullExpressionValue(child, "child");
                PsiClass answer = this.findClass(child, predicate);
                if (answer == null) continue;
                return answer;
            }
        }
        return null;
    }

    @Nullable
    public final PsiMethod getLightClassAccessorMethod(@NotNull KtPropertyAccessor accessor) {
        Intrinsics.checkNotNullParameter(accessor, "accessor");
        return CollectionsKt.firstOrNull(this.getLightClassAccessorMethods(accessor));
    }

    @NotNull
    public final List<PsiMethod> getLightClassAccessorMethods(@NotNull KtPropertyAccessor accessor) {
        Intrinsics.checkNotNullParameter(accessor, "accessor");
        PsiElement $this$getNonStrictParentOfType$iv = accessor;
        boolean $i$f$getNonStrictParentOfType = false;
        KtProperty ktProperty = PsiTreeUtil.getParentOfType($this$getNonStrictParentOfType$iv, KtProperty.class, false);
        if (ktProperty == null) {
            return CollectionsKt.emptyList();
        }
        KtProperty property2 = ktProperty;
        Sequence wrappers = LightClassUtil.getPsiMethodWrappers$default(this, property2, null, 2, null);
        return SequencesKt.toList(SequencesKt.filter(wrappers, (Function1)new Function1<KtLightMethod, Boolean>(accessor){
            final /* synthetic */ KtPropertyAccessor $accessor;
            {
                this.$accessor = $accessor;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull KtLightMethod wrapper) {
                boolean bl;
                block4: {
                    block3: {
                        String string2;
                        block2: {
                            Intrinsics.checkNotNullParameter(wrapper, "wrapper");
                            if (!this.$accessor.isGetter()) break block2;
                            string2 = wrapper.getName();
                            Intrinsics.checkNotNullExpressionValue(string2, "wrapper.name");
                            if (!JvmAbi.isSetterName(string2)) break block3;
                        }
                        if (!this.$accessor.isSetter()) break block4;
                        string2 = wrapper.getName();
                        Intrinsics.checkNotNullExpressionValue(string2, "wrapper.name");
                        if (!JvmAbi.isSetterName(string2)) break block4;
                    }
                    bl = true;
                    return bl;
                }
                bl = false;
                return bl;
            }
        }));
    }

    @Nullable
    public final PsiField getLightFieldForCompanionObject(@NotNull KtClassOrObject companionObject) {
        Intrinsics.checkNotNullParameter(companionObject, "companionObject");
        PsiClass outerPsiClass = this.getWrappingClass(companionObject);
        if (outerPsiClass != null) {
            PsiField[] psiFieldArray = outerPsiClass.getFields();
            Intrinsics.checkNotNullExpressionValue(psiFieldArray, "outerPsiClass.fields");
            for (PsiField fieldOfParent : psiFieldArray) {
                if (!(fieldOfParent instanceof KtLightElement) || ((KtLightElement)((Object)fieldOfParent)).getKotlinOrigin() != companionObject.getOriginalElement()) continue;
                return fieldOfParent;
            }
        }
        return null;
    }

    @NotNull
    public final PropertyAccessorsPsiMethods getLightClassPropertyMethods(@NotNull KtProperty property2) {
        Intrinsics.checkNotNullParameter(property2, "property");
        KtPropertyAccessor getter2 = property2.getGetter();
        KtPropertyAccessor setter2 = property2.getSetter();
        PsiMethod getterWrapper = getter2 != null ? this.getLightClassAccessorMethod(getter2) : null;
        PsiMethod setterWrapper = setter2 != null ? this.getLightClassAccessorMethod(setter2) : null;
        return this.extractPropertyAccessors(property2, getterWrapper, setterWrapper);
    }

    @Nullable
    public final PsiField getLightClassBackingField(@NotNull KtDeclaration declaration2) {
        KtLightClass containingLightClass;
        KtClass containingClass;
        KtClassOrObject origin;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        PsiField[] psiFieldArray = this.getWrappingClass(declaration2);
        if (psiFieldArray == null) {
            return null;
        }
        Object psiClass = psiFieldArray;
        if (psiClass instanceof KtLightClass && (origin = (KtClassOrObject)((KtLightClass)psiClass).getKotlinOrigin()) instanceof KtObjectDeclaration && ((KtObjectDeclaration)origin).isCompanion() && (containingClass = PsiTreeUtil.getParentOfType((PsiElement)origin, KtClass.class)) != null && (containingLightClass = LightClassUtilsKt.toLightClass(containingClass)) != null) {
            psiClass = containingLightClass;
        }
        PsiField[] psiFieldArray2 = psiClass.getFields();
        Intrinsics.checkNotNullExpressionValue(psiFieldArray2, "psiClass.fields");
        for (PsiField field2 : psiFieldArray2) {
            if (!(field2 instanceof KtLightField) || ((KtLightField)field2).getKotlinOrigin() != declaration2) continue;
            return field2;
        }
        return null;
    }

    @NotNull
    public final PropertyAccessorsPsiMethods getLightClassPropertyMethods(@NotNull KtParameter parameter) {
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        return this.extractPropertyAccessors(parameter, null, null);
    }

    @Nullable
    public final PsiMethod getLightClassMethod(@NotNull KtFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        return this.getPsiMethodWrapper(function2);
    }

    @Nullable
    public final PsiMethod getLightClassMethod(@NotNull KtParameter parameter) {
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        return this.getPsiMethodWrapper(parameter);
    }

    @NotNull
    public final List<PsiMethod> getLightClassMethods(@NotNull KtFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        return SequencesKt.toList(LightClassUtil.getPsiMethodWrappers$default(this, function2, null, 2, null));
    }

    @NotNull
    public final Sequence<KtLightMethod> getLightClassMethodsByName(@NotNull KtFunction function2, @NotNull String name2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(name2, "name");
        return this.getPsiMethodWrappers(function2, name2);
    }

    private final PsiMethod getPsiMethodWrapper(KtDeclaration declaration2) {
        return (PsiMethod)SequencesKt.firstOrNull(LightClassUtil.getPsiMethodWrappers$default(this, declaration2, null, 2, null));
    }

    private final Sequence<KtLightMethod> getPsiMethodWrappers(KtDeclaration declaration2, String name2) {
        Sequence $this$filterIsInstance$iv = SequencesKt.flatMap(this.getWrappingClasses(declaration2), getPsiMethodWrappers.1.INSTANCE);
        boolean $i$f$filterIsInstance = false;
        return SequencesKt.filter(SequencesKt.filter(SequencesKt.filter($this$filterIsInstance$iv, getPsiMethodWrappers$$inlined$filterIsInstance$1.INSTANCE), (Function1)new Function1<KtLightMethod, Boolean>(name2){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtLightMethod it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$name == null || Intrinsics.areEqual(this.$name, it.getName());
            }
        }), (Function1)new Function1<KtLightMethod, Boolean>(declaration2){
            final /* synthetic */ KtDeclaration $declaration;
            {
                this.$declaration = $declaration;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtLightMethod it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.getKotlinOrigin() == this.$declaration || it.getNavigationElement() == this.$declaration;
            }
        });
    }

    static /* synthetic */ Sequence getPsiMethodWrappers$default(LightClassUtil lightClassUtil, KtDeclaration ktDeclaration, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return lightClassUtil.getPsiMethodWrappers(ktDeclaration, string2);
    }

    private final PsiClass getWrappingClass(KtDeclaration declaration2) {
        KtClassOrObject constructorClass;
        if (declaration2 instanceof KtParameter && (constructorClass = KtPsiUtil.getClassIfParameterIsProperty((KtParameter)declaration2)) != null) {
            return LightClassUtilsKt.toLightClass(constructorClass);
        }
        KtDeclaration ktDeclaration = declaration2;
        if (ktDeclaration instanceof KtPropertyAccessor) {
            KtProperty ktProperty = ((KtPropertyAccessor)ktDeclaration).getProperty();
            Intrinsics.checkNotNullExpressionValue(ktProperty, "ktDeclaration.property");
            ktDeclaration = ktProperty;
        }
        if (ktDeclaration instanceof KtConstructor) {
            return LightClassUtilsKt.toLightClass(((KtConstructor)ktDeclaration).getContainingClassOrObject());
        }
        PsiElement parent2 = ktDeclaration.getParent();
        if (parent2 instanceof KtFile) {
            return this.findFileFacade((KtFile)parent2);
        }
        if (parent2 instanceof KtClassBody) {
            boolean value$iv = ((KtClassBody)parent2).getParent() instanceof KtClassOrObject;
            boolean $i$f$checkWithAttachment = false;
            if (!value$iv) {
                KotlinExceptionWithAttachments e$iv;
                String string2;
                boolean bl = false;
                PsiElement psiElement = ((KtClassBody)parent2).getParent();
                String string3 = string2 = Intrinsics.stringPlus("Bad parent: ", psiElement == null ? null : psiElement.getClass());
                KotlinExceptionWithAttachments it = e$iv = new KotlinExceptionWithAttachments(string3);
                boolean bl2 = false;
                it.withAttachment("parent", ((KtClassBody)parent2).getText());
                throw e$iv;
            }
            PsiElement psiElement = ((KtClassBody)parent2).getParent();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
            }
            return LightClassUtilsKt.toLightClass((KtClassOrObject)psiElement);
        }
        return null;
    }

    private final PsiClass findFileFacade(KtFile ktFile) {
        Object object;
        block3: {
            FqName fqName2 = JvmFileClassUtilKt.getJavaFileFacadeFqName(ktFile);
            Project project = ktFile.getProject();
            Intrinsics.checkNotNullExpressionValue(project, "ktFile.project");
            Project project2 = project;
            JavaElementFinder javaElementFinder = JavaElementFinder.Companion.getInstance(project2);
            Object object2 = fqName2.asString();
            Intrinsics.checkNotNullExpressionValue(object2, "fqName.asString()");
            String string2 = object2;
            object2 = GlobalSearchScope.allScope(project2);
            Intrinsics.checkNotNullExpressionValue(object2, "allScope(project)");
            PsiClass[] classesWithMatchingFqName = javaElementFinder.findClasses(string2, (GlobalSearchScope)object2);
            object2 = ArraysKt.singleOrNull(classesWithMatchingFqName);
            if (object2 == null) {
                PsiClass[] psiClassArray;
                PsiClass[] psiClassArray2;
                for (PsiClass psiClass : psiClassArray2 = (psiClassArray = classesWithMatchingFqName)) {
                    PsiClass it = psiClass;
                    boolean bl = false;
                    PsiFile psiFile = it.getContainingFile();
                    if (!Intrinsics.areEqual(psiFile == null ? null : psiFile.getVirtualFile(), ktFile.getVirtualFile())) continue;
                    object = psiClass;
                    break block3;
                }
                object = null;
            } else {
                object = object2;
            }
        }
        return object;
    }

    private final Sequence<PsiClass> getWrappingClasses(KtDeclaration declaration2) {
        PsiClass psiClass = this.getWrappingClass(declaration2);
        if (psiClass == null) {
            return SequencesKt.emptySequence();
        }
        PsiClass wrapperClass = psiClass;
        KtClassOrObject wrapperClassOrigin = (KtClassOrObject)((KtLightClass)wrapperClass).getKotlinOrigin();
        if (wrapperClassOrigin instanceof KtObjectDeclaration && ((KtObjectDeclaration)wrapperClassOrigin).isCompanion() && ((KtLightClass)wrapperClass).getParent() instanceof PsiClass) {
            PsiClass[] psiClassArray = new PsiClass[2];
            psiClassArray[0] = wrapperClass;
            PsiElement psiElement = ((KtLightClass)wrapperClass).getParent();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiClass");
            }
            psiClassArray[1] = (PsiClass)psiElement;
            return SequencesKt.sequenceOf(psiClassArray);
        }
        KtLightClass[] ktLightClassArray = new KtLightClass[]{(KtLightClass)wrapperClass};
        return SequencesKt.sequenceOf(ktLightClassArray);
    }

    public final boolean canGenerateLightClass(@NotNull KtDeclaration declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Class[] classArray = new Class[]{KtFunction.class, KtProperty.class};
        return PsiTreeUtil.getParentOfType((PsiElement)declaration2, classArray) == null;
    }

    /*
     * WARNING - void declaration
     */
    private final PropertyAccessorsPsiMethods extractPropertyAccessors(KtDeclaration ktDeclaration, PsiMethod specialGetter, PsiMethod specialSetter) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        void $this$filterNotTo$iv$iv2;
        void $this$filterNot$iv2;
        Object element$iv;
        Sequence $this$partition$iv = LightClassUtil.getPsiMethodWrappers$default(this, ktDeclaration, null, 2, null);
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        Iterable<Object> second$iv = new ArrayList();
        Iterator iterator2 = $this$partition$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            KtLightMethod it = (KtLightMethod)element$iv;
            boolean bl = false;
            if (KtLightMethodImplKt.isSetter(it)) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List setters = pair.component1();
        List getters = pair.component2();
        second$iv = getters;
        Collection collection = CollectionsKt.listOfNotNull(specialGetter);
        boolean $i$f$filterNot22 = false;
        element$iv = $this$filterNot$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv2) {
            KtLightMethod it = (KtLightMethod)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(it, specialGetter)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        List allGetters = CollectionsKt.plus(collection, (Iterable)list2);
        Iterable $i$f$filterNot22 = setters;
        collection = CollectionsKt.listOfNotNull(specialSetter);
        boolean $i$f$filterNot = false;
        destination$iv$iv = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo2 = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            KtLightMethod it = (KtLightMethod)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(it, specialSetter)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        list2 = (List)destination$iv$iv2;
        List allSetters = CollectionsKt.plus(collection, (Iterable)list2);
        PsiField backingField2 = this.getLightClassBackingField(ktDeclaration);
        List additionalAccessors = CollectionsKt.plus((Collection)CollectionsKt.drop(allGetters, 1), (Iterable)CollectionsKt.drop(allSetters, 1));
        return new PropertyAccessorsPsiMethods((PsiMethod)CollectionsKt.firstOrNull(allGetters), (PsiMethod)CollectionsKt.firstOrNull(allSetters), backingField2, additionalAccessors);
    }

    @NotNull
    public final PsiTypeParameterList buildLightTypeParameterList(@NotNull PsiTypeParameterListOwner owner, @NotNull KtDeclaration declaration2) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        KotlinLightTypeParameterListBuilder builder2 = new KotlinLightTypeParameterListBuilder(owner);
        if (declaration2 instanceof KtTypeParameterListOwner) {
            List<KtTypeParameter> list2 = ((KtTypeParameterListOwner)declaration2).getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list2, "declaration.typeParameters");
            List<KtTypeParameter> parameters2 = list2;
            int n = 0;
            int n2 = parameters2.size();
            while (n < n2) {
                int i;
                KtTypeParameter jetTypeParameter;
                String name2;
                String string2;
                String safeName = (string2 = (name2 = (jetTypeParameter = parameters2.get(i = n++)).getName())) == null ? "__no_name__" : string2;
                builder2.addParameter(new KtLightTypeParameter(owner, i, safeName));
            }
        }
        return builder2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010(\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B1\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0096\u0002R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/asJava/LightClassUtil$PropertyAccessorsPsiMethods;", "", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiMethod;", "getter", "setter", "backingField", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiField;", "additionalAccessors", "", "(Lcom/intellij/psi/PsiMethod;Lcom/intellij/psi/PsiMethod;Lcom/intellij/psi/PsiField;Ljava/util/List;)V", "allDeclarations", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiNamedElement;", "getAllDeclarations", "()Ljava/util/List;", "allMethods", "getBackingField", "()Lcom/intellij/psi/PsiField;", "getGetter", "()Lcom/intellij/psi/PsiMethod;", "getSetter", "iterator", "", "light-classes"})
    public static final class PropertyAccessorsPsiMethods
    implements Iterable<PsiMethod>,
    KMappedMarker {
        @Nullable
        private final PsiMethod getter;
        @Nullable
        private final PsiMethod setter;
        @Nullable
        private final PsiField backingField;
        @NotNull
        private final List<PsiMethod> allMethods;
        @NotNull
        private final List<PsiNamedElement> allDeclarations;

        /*
         * WARNING - void declaration
         */
        public PropertyAccessorsPsiMethods(@Nullable PsiMethod getter2, @Nullable PsiMethod setter2, @Nullable PsiField backingField2, @NotNull List<? extends PsiMethod> additionalAccessors) {
            void $this$filterIsInstanceTo$iv;
            Intrinsics.checkNotNullParameter(additionalAccessors, "additionalAccessors");
            this.getter = getter2;
            this.setter = setter2;
            this.backingField = backingField2;
            this.allMethods = new ArrayList();
            Object object = new PsiMethod[]{this.getter, this.setter};
            ArraysKt.filterNotNullTo(object, (Collection)this.allMethods);
            object = additionalAccessors;
            Collection destination$iv = this.allMethods;
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv : $this$filterIsInstanceTo$iv) {
                if (!(element$iv instanceof PsiMethod)) continue;
                destination$iv.add(element$iv);
            }
            this.allDeclarations = new ArrayList();
            object = new PsiNamedElement[]{this.getter, this.setter, this.backingField};
            ArraysKt.filterNotNullTo(object, (Collection)this.allDeclarations);
            ((ArrayList)this.allDeclarations).addAll((Collection)additionalAccessors);
        }

        @Nullable
        public final PsiMethod getGetter() {
            return this.getter;
        }

        @Nullable
        public final PsiMethod getSetter() {
            return this.setter;
        }

        @Nullable
        public final PsiField getBackingField() {
            return this.backingField;
        }

        @NotNull
        public final List<PsiNamedElement> getAllDeclarations() {
            return this.allDeclarations;
        }

        @Override
        @NotNull
        public Iterator<PsiMethod> iterator() {
            return this.allMethods.iterator();
        }
    }
}

