/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.BasicIrModuleDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.DeserializationStrategy;
import org.jetbrains.kotlin.backend.common.serialization.FileDeserializationState;
import org.jetbrains.kotlin.backend.common.serialization.IdSignatureDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrFileDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrFileDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.IrLibraryFileFromKlib;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrSymbolDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.KotlinIrLinker;
import org.jetbrains.kotlin.backend.common.serialization.ModuleDeserializationState;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.backend.common.serialization.proto.Actual;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrFile;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.impl.IrModuleFragmentImpl;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.library.IrLibrary;
import org.jetbrains.kotlin.library.KotlinAbiVersion;
import org.jetbrains.kotlin.protobuf.CodedInputStream;
import org.jetbrains.kotlin.protobuf.ExtensionRegistryLite;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020$H\u0016J\u0011\u0010-\u001a\u00020\r2\u0006\u0010,\u001a\u00020$H\u0096\u0002J(\u0010.\u001a\u00020\u00112\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00012\u0006\u00104\u001a\u00020\rH\u0002J\u0018\u00105\u001a\u0002062\u0006\u0010,\u001a\u00020$2\u0006\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u00020+H\u0016J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00120;H\u0016J\u0010\u0010<\u001a\u00020+2\u0006\u0010=\u001a\u00020\u0001H\u0016J\u0018\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u00112\u0006\u0010A\u001a\u00020$H\u0016J\u0018\u0010B\u001a\u00020C2\u0006\u0010@\u001a\u00020\u00112\u0006\u0010A\u001a\u00020$H\u0016J\u0010\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020GH\u0016J\f\u0010H\u001a\u00020+*\u00020IH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R \u0010#\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u0006J"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/BasicIrModuleDeserializer;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "linker", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "klib", "Lorg/jetbrains/kotlin/library/IrLibrary;", "strategy", "Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;", "libraryAbiVersion", "Lorg/jetbrains/kotlin/library/KotlinAbiVersion;", "containsErrorCode", "", "(Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/library/IrLibrary;Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;Lorg/jetbrains/kotlin/library/KotlinAbiVersion;Z)V", "fileToDeserializerMap", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrFileDeserializer;", "getKlib", "()Lorg/jetbrains/kotlin/library/IrLibrary;", "getLinker", "()Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "moduleDependencies", "", "getModuleDependencies", "()Ljava/util/List;", "moduleDependencies$delegate", "Lkotlin/Lazy;", "moduleDeserializationState", "Lorg/jetbrains/kotlin/backend/common/serialization/ModuleDeserializationState;", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "getModuleFragment", "()Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "moduleReversedFileIndex", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lorg/jetbrains/kotlin/backend/common/serialization/FileDeserializationState;", "getModuleReversedFileIndex$ir_serialization_common", "()Ljava/util/Map;", "getStrategy", "()Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;", "addModuleReachableTopLevel", "", "idSig", "contains", "deserializeIrFile", "fileProto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrFile;", "fileIndex", "", "moduleDeserializer", "allowErrorNodes", "deserializeIrSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "symbolKind", "Lorg/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData$SymbolKind;", "deserializeReachableDeclarations", "fileDeserializers", "", "init", "delegate", "referencePropertyByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "file", "idSignature", "referenceSimpleFunctionByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "signatureDeserializerForFile", "Lorg/jetbrains/kotlin/backend/common/serialization/IdSignatureDeserializer;", "fileName", "", "deserializeExpectActualMapping", "Lorg/jetbrains/kotlin/backend/common/serialization/IrSymbolDeserializer;", "ir.serialization.common"})
public abstract class BasicIrModuleDeserializer
extends IrModuleDeserializer {
    @NotNull
    private final KotlinIrLinker linker;
    @NotNull
    private final IrLibrary klib;
    @NotNull
    private final DeserializationStrategy strategy;
    private final boolean containsErrorCode;
    @NotNull
    private final Map<org.jetbrains.kotlin.ir.declarations.IrFile, IrFileDeserializer> fileToDeserializerMap;
    @NotNull
    private final ModuleDeserializationState moduleDeserializationState;
    @NotNull
    private final Map<IdSignature, FileDeserializationState> moduleReversedFileIndex;
    @NotNull
    private final Lazy moduleDependencies$delegate;
    @NotNull
    private final IrModuleFragment moduleFragment;

    public BasicIrModuleDeserializer(@NotNull KotlinIrLinker linker, @NotNull ModuleDescriptor moduleDescriptor, @NotNull IrLibrary klib, @NotNull DeserializationStrategy strategy, @NotNull KotlinAbiVersion libraryAbiVersion, boolean containsErrorCode) {
        Intrinsics.checkNotNullParameter(linker, "linker");
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(klib, "klib");
        Intrinsics.checkNotNullParameter((Object)strategy, "strategy");
        Intrinsics.checkNotNullParameter(libraryAbiVersion, "libraryAbiVersion");
        super(moduleDescriptor, libraryAbiVersion);
        this.linker = linker;
        this.klib = klib;
        this.strategy = strategy;
        this.containsErrorCode = containsErrorCode;
        this.fileToDeserializerMap = new LinkedHashMap();
        this.moduleDeserializationState = new ModuleDeserializationState(this.linker, this);
        this.moduleReversedFileIndex = new LinkedHashMap();
        this.moduleDependencies$delegate = LazyKt.lazy((Function0)new Function0<List<? extends IrModuleDeserializer>>(moduleDescriptor, this){
            final /* synthetic */ ModuleDescriptor $moduleDescriptor;
            final /* synthetic */ BasicIrModuleDeserializer this$0;
            {
                this.$moduleDescriptor = $moduleDescriptor;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<IrModuleDeserializer> invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                ModuleDescriptor it;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Iterable iterable = this.$moduleDescriptor.getAllDependencyModules();
                Object object = this.$moduleDescriptor;
                boolean $i$f$filter = false;
                void var4_4 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (ModuleDescriptor)element$iv$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual(it, object))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                object = this.this$0;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (ModuleDescriptor)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    IrModuleDeserializer irModuleDeserializer = ((BasicIrModuleDeserializer)object).getLinker().resolveModuleDeserializer(it, null);
                    collection.add(irModuleDeserializer);
                }
                return (List)destination$iv$iv;
            }
        });
        this.moduleFragment = new IrModuleFragmentImpl(moduleDescriptor, this.linker.getBuiltIns(), CollectionsKt.emptyList());
    }

    public /* synthetic */ BasicIrModuleDeserializer(KotlinIrLinker kotlinIrLinker, ModuleDescriptor moduleDescriptor, IrLibrary irLibrary, DeserializationStrategy deserializationStrategy, KotlinAbiVersion kotlinAbiVersion, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        this(kotlinIrLinker, moduleDescriptor, irLibrary, deserializationStrategy, kotlinAbiVersion, bl);
    }

    @NotNull
    public final KotlinIrLinker getLinker() {
        return this.linker;
    }

    @Override
    @NotNull
    public IrLibrary getKlib() {
        return this.klib;
    }

    @Override
    @NotNull
    public DeserializationStrategy getStrategy() {
        return this.strategy;
    }

    @NotNull
    public final Map<IdSignature, FileDeserializationState> getModuleReversedFileIndex$ir_serialization_common() {
        return this.moduleReversedFileIndex;
    }

    @NotNull
    public List<IrModuleDeserializer> getModuleDependencies() {
        Lazy lazy = this.moduleDependencies$delegate;
        Object var2_2 = null;
        return (List)lazy.getValue();
    }

    @Override
    @NotNull
    public Collection<IrFileDeserializer> fileDeserializers() {
        return this.fileToDeserializerMap.values();
    }

    @Override
    public void init(@NotNull IrModuleDeserializer delegate2) {
        Intrinsics.checkNotNullParameter(delegate2, "delegate");
        int fileCount = this.getKlib().fileCount();
        ArrayList<org.jetbrains.kotlin.ir.declarations.IrFile> files2 = new ArrayList<org.jetbrains.kotlin.ir.declarations.IrFile>(fileCount);
        int n = 0;
        while (n < fileCount) {
            int i = n++;
            CodedInputStream fileStream = BasicIrModuleDeserializerKt.getCodedInputStream(this.getKlib().file(i));
            IrFile fileProto = IrFile.parseFrom(fileStream, ExtensionRegistryLite.newInstance());
            Intrinsics.checkNotNullExpressionValue(fileProto, "fileProto");
            files2.add(this.deserializeIrFile(fileProto, i, delegate2, this.containsErrorCode));
        }
        this.getModuleFragment().getFiles().addAll((Collection<org.jetbrains.kotlin.ir.declarations.IrFile>)files2);
        Iterable $this$forEach$iv = this.fileToDeserializerMap.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrFileDeserializer it = (IrFileDeserializer)element$iv;
            boolean bl = false;
            this.deserializeExpectActualMapping(it.getSymbolDeserializer());
        }
    }

    private final void deserializeExpectActualMapping(IrSymbolDeserializer $this$deserializeExpectActualMapping) {
        Iterable $this$forEach$iv = $this$deserializeExpectActualMapping.getActuals();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            boolean bl;
            Actual it = (Actual)element$iv;
            boolean bl2 = false;
            long expectSymbol = $this$deserializeExpectActualMapping.parseSymbolData-9x8F8T0(it.getExpectSymbol());
            long actualSymbol = $this$deserializeExpectActualMapping.parseSymbolData-9x8F8T0(it.getActualSymbol());
            IdSignature expect = $this$deserializeExpectActualMapping.deserializeIdSignature(BinarySymbolData.getSignatureId-impl(expectSymbol));
            IdSignature actual = $this$deserializeExpectActualMapping.deserializeIdSignature(BinarySymbolData.getSignatureId-impl(actualSymbol));
            boolean bl3 = bl = this.getLinker().getExpectUniqIdToActualUniqId().get(expect) == null;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string2 = "Expect signature " + expect + " is already actualized by " + this.getLinker().getExpectUniqIdToActualUniqId().get(expect) + ", while we try to record " + actual;
                throw new AssertionError((Object)string2);
            }
            Object object2 = this.getLinker().getExpectUniqIdToActualUniqId();
            object2.put((IdSignature)expect, (IdSignature)actual);
            object2 = BasicIrModuleDeserializerKt.findModuleDeserializerForTopLevelId(this, actual);
            if (object2 == null) continue;
            Object md = object = object2;
            boolean bl5 = false;
            Map<IdSignature, IrModuleDeserializer> map2 = this.getLinker().getTopLevelActualUniqItToDeserializer();
            map2.put(actual, (IrModuleDeserializer)md);
        }
    }

    @Override
    @NotNull
    public IrSimpleFunctionSymbol referenceSimpleFunctionByLocalSignature(@NotNull org.jetbrains.kotlin.ir.declarations.IrFile file2, @NotNull IdSignature idSignature) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(idSignature, "idSignature");
        IrFileDeserializer irFileDeserializer = this.fileToDeserializerMap.get(file2);
        if (irFileDeserializer == null) {
            throw new IllegalStateException(("No deserializer for file " + file2 + " in module " + this.getModuleDescriptor().getName()).toString());
        }
        IrSymbolDeserializer irSymbolDeserializer = irFileDeserializer.getSymbolDeserializer();
        return irSymbolDeserializer.referenceSimpleFunctionByLocalSignature(idSignature);
    }

    @Override
    @NotNull
    public IrPropertySymbol referencePropertyByLocalSignature(@NotNull org.jetbrains.kotlin.ir.declarations.IrFile file2, @NotNull IdSignature idSignature) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(idSignature, "idSignature");
        IrFileDeserializer irFileDeserializer = this.fileToDeserializerMap.get(file2);
        if (irFileDeserializer == null) {
            throw new IllegalStateException(("No deserializer for file " + file2 + " in module " + this.getModuleDescriptor().getName()).toString());
        }
        IrSymbolDeserializer irSymbolDeserializer = irFileDeserializer.getSymbolDeserializer();
        return irSymbolDeserializer.referencePropertyByLocalSignature(idSignature);
    }

    @Override
    public boolean contains(@NotNull IdSignature idSig) {
        Map<IdSignature, FileDeserializationState> map2;
        Intrinsics.checkNotNullParameter(idSig, "idSig");
        Map<IdSignature, FileDeserializationState> map3 = map2 = this.moduleReversedFileIndex;
        return map3.containsKey(idSig);
    }

    @Override
    @NotNull
    public IrSymbol deserializeIrSymbol(@NotNull IdSignature idSig, @NotNull BinarySymbolData.SymbolKind symbolKind) {
        Intrinsics.checkNotNullParameter(idSig, "idSig");
        Intrinsics.checkNotNullParameter((Object)symbolKind, "symbolKind");
        IdSignature topLevelSignature = idSig.topLevelSignature();
        FileDeserializationState fileDeserializationState = this.moduleReversedFileIndex.get(topLevelSignature);
        if (fileDeserializationState == null) {
            throw new IllegalStateException(("No file for " + topLevelSignature + " (@ " + idSig + ") in module " + this.getModuleDescriptor()).toString());
        }
        FileDeserializationState fileLocalDeserializationState = fileDeserializationState;
        fileLocalDeserializationState.addIdSignature(topLevelSignature);
        this.moduleDeserializationState.enqueueFile(fileLocalDeserializationState);
        return fileLocalDeserializationState.getFileDeserializer().getSymbolDeserializer().deserializeIrSymbol(idSig, symbolKind);
    }

    @Override
    @NotNull
    public IrModuleFragment getModuleFragment() {
        return this.moduleFragment;
    }

    private final org.jetbrains.kotlin.ir.declarations.IrFile deserializeIrFile(IrFile fileProto, int fileIndex, IrModuleDeserializer moduleDeserializer, boolean allowErrorNodes) {
        IrLibraryFileFromKlib fileReader = new IrLibraryFileFromKlib(moduleDeserializer.getKlib(), fileIndex);
        org.jetbrains.kotlin.ir.declarations.IrFile file2 = IrFileDeserializerKt.createFile(fileReader, this.getModuleFragment(), fileProto);
        FileDeserializationState fileDeserializationState = new FileDeserializationState(this.linker, file2, fileReader, fileProto, this.getStrategy().getNeedBodies(), allowErrorNodes, this.getStrategy().getInlineBodies(), moduleDeserializer);
        Map<org.jetbrains.kotlin.ir.declarations.IrFile, IrFileDeserializer> map2 = this.fileToDeserializerMap;
        IrFileDeserializer irFileDeserializer = fileDeserializationState.getFileDeserializer();
        map2.put(file2, irFileDeserializer);
        Set<IdSignature> topLevelDeclarations = fileDeserializationState.getFileDeserializer().getReversedSignatureIndex().keySet();
        Iterable $this$forEach$iv = topLevelDeclarations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IdSignature it = (IdSignature)element$iv;
            boolean bl = false;
            this.getModuleReversedFileIndex$ir_serialization_common().putIfAbsent(it, fileDeserializationState);
        }
        if (this.getStrategy().getTheWholeWorld()) {
            fileDeserializationState.enqueueAllDeclarations();
        }
        if (this.getStrategy().getTheWholeWorld() || this.getStrategy().getExplicitlyExported()) {
            this.moduleDeserializationState.enqueueFile(fileDeserializationState);
        }
        return file2;
    }

    @Override
    public void addModuleReachableTopLevel(@NotNull IdSignature idSig) {
        Intrinsics.checkNotNullParameter(idSig, "idSig");
        this.moduleDeserializationState.addIdSignature(idSig);
    }

    @Override
    public void deserializeReachableDeclarations() {
        this.moduleDeserializationState.deserializeReachableDeclarations();
    }

    @Override
    @NotNull
    public IdSignatureDeserializer signatureDeserializerForFile(@NotNull String fileName) {
        Object v0;
        block2: {
            Iterable iterable;
            Intrinsics.checkNotNullParameter(fileName, "fileName");
            Iterable iterable2 = iterable = (Iterable)this.fileToDeserializerMap.entrySet();
            for (Object t : iterable2) {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(((org.jetbrains.kotlin.ir.declarations.IrFile)it.getKey()).getFileEntry().getName(), fileName)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        if (entry == null) {
            throw new IllegalStateException(Intrinsics.stringPlus("No file deserializer for ", fileName).toString());
        }
        IrFileDeserializer fileDeserializer = (IrFileDeserializer)entry.getValue();
        return fileDeserializer.getSymbolDeserializer().getSignatureDeserializer();
    }
}

