/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.inject.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Set;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.com.google.inject.Binder;
import org.jetbrains.kotlin.com.google.inject.ConfigurationException;
import org.jetbrains.kotlin.com.google.inject.Key;
import org.jetbrains.kotlin.com.google.inject.Provider;
import org.jetbrains.kotlin.com.google.inject.TypeLiteral;
import org.jetbrains.kotlin.com.google.inject.binder.AnnotatedBindingBuilder;
import org.jetbrains.kotlin.com.google.inject.binder.ScopedBindingBuilder;
import org.jetbrains.kotlin.com.google.inject.internal.AbstractBindingBuilder;
import org.jetbrains.kotlin.com.google.inject.internal.BindingImpl;
import org.jetbrains.kotlin.com.google.inject.internal.ConstructorBindingImpl;
import org.jetbrains.kotlin.com.google.inject.internal.InstanceBindingImpl;
import org.jetbrains.kotlin.com.google.inject.internal.LinkedBindingImpl;
import org.jetbrains.kotlin.com.google.inject.internal.LinkedProviderBindingImpl;
import org.jetbrains.kotlin.com.google.inject.internal.ProviderInstanceBindingImpl;
import org.jetbrains.kotlin.com.google.inject.internal.Scoping;
import org.jetbrains.kotlin.com.google.inject.spi.Element;
import org.jetbrains.kotlin.com.google.inject.spi.InjectionPoint;
import org.jetbrains.kotlin.com.google.inject.spi.Message;

public class BindingBuilder<T>
extends AbstractBindingBuilder<T>
implements AnnotatedBindingBuilder<T> {
    public BindingBuilder(Binder binder, List<Element> elements, Object source, Key<T> key) {
        super(binder, elements, source, key);
    }

    @Override
    public BindingBuilder<T> annotatedWith(Class<? extends Annotation> annotationType) {
        this.annotatedWithInternal(annotationType);
        return this;
    }

    @Override
    public BindingBuilder<T> annotatedWith(Annotation annotation2) {
        this.annotatedWithInternal(annotation2);
        return this;
    }

    @Override
    public BindingBuilder<T> to(Class<? extends T> implementation2) {
        return this.to((Key)Key.get(implementation2));
    }

    @Override
    public BindingBuilder<T> to(TypeLiteral<? extends T> implementation2) {
        return this.to((Key)Key.get(implementation2));
    }

    @Override
    public BindingBuilder<T> to(Key<? extends T> linkedKey) {
        Preconditions.checkNotNull(linkedKey, "linkedKey");
        this.checkNotTargetted();
        BindingImpl base2 = this.getBinding();
        this.setBinding(new LinkedBindingImpl<T>(base2.getSource(), base2.getKey(), base2.getScoping(), linkedKey));
        return this;
    }

    @Override
    public void toInstance(T instance) {
        Set injectionPoints;
        this.checkNotTargetted();
        if (instance != null) {
            try {
                injectionPoints = InjectionPoint.forInstanceMethodsAndFields(instance.getClass());
            }
            catch (ConfigurationException e) {
                this.copyErrorsToBinder(e);
                injectionPoints = (Set)e.getPartialValue();
            }
        } else {
            this.binder.addError("Binding to null instances is not allowed. Use toProvider(Providers.of(null)) if this is your intended behaviour.", new Object[0]);
            injectionPoints = ImmutableSet.of();
        }
        BindingImpl base2 = this.getBinding();
        this.setBinding(new InstanceBindingImpl(base2.getSource(), base2.getKey(), Scoping.EAGER_SINGLETON, injectionPoints, instance));
    }

    @Override
    public BindingBuilder<T> toProvider(Provider<? extends T> provider2) {
        return this.toProvider((javax.inject.Provider)provider2);
    }

    @Override
    public BindingBuilder<T> toProvider(javax.inject.Provider<? extends T> provider2) {
        Set injectionPoints;
        Preconditions.checkNotNull(provider2, "provider");
        this.checkNotTargetted();
        try {
            injectionPoints = InjectionPoint.forInstanceMethodsAndFields(provider2.getClass());
        }
        catch (ConfigurationException e) {
            this.copyErrorsToBinder(e);
            injectionPoints = (Set)e.getPartialValue();
        }
        BindingImpl base2 = this.getBinding();
        this.setBinding(new ProviderInstanceBindingImpl<T>(base2.getSource(), base2.getKey(), base2.getScoping(), injectionPoints, provider2));
        return this;
    }

    @Override
    public BindingBuilder<T> toProvider(Class<? extends javax.inject.Provider<? extends T>> providerType) {
        return this.toProvider((Key)Key.get(providerType));
    }

    @Override
    public BindingBuilder<T> toProvider(TypeLiteral<? extends javax.inject.Provider<? extends T>> providerType) {
        return this.toProvider((Key)Key.get(providerType));
    }

    @Override
    public BindingBuilder<T> toProvider(Key<? extends javax.inject.Provider<? extends T>> providerKey) {
        Preconditions.checkNotNull(providerKey, "providerKey");
        this.checkNotTargetted();
        BindingImpl base2 = this.getBinding();
        this.setBinding(new LinkedProviderBindingImpl(base2.getSource(), base2.getKey(), base2.getScoping(), providerKey));
        return this;
    }

    @Override
    public <S extends T> ScopedBindingBuilder toConstructor(Constructor<S> constructor2) {
        return this.toConstructor(constructor2, TypeLiteral.get(constructor2.getDeclaringClass()));
    }

    @Override
    public <S extends T> ScopedBindingBuilder toConstructor(Constructor<S> constructor2, TypeLiteral<? extends S> type2) {
        Set injectionPoints;
        Preconditions.checkNotNull(constructor2, "constructor");
        Preconditions.checkNotNull(type2, "type");
        this.checkNotTargetted();
        BindingImpl base2 = this.getBinding();
        try {
            injectionPoints = InjectionPoint.forInstanceMethodsAndFields(type2);
        }
        catch (ConfigurationException e) {
            this.copyErrorsToBinder(e);
            injectionPoints = (Set)e.getPartialValue();
        }
        try {
            InjectionPoint constructorPoint = InjectionPoint.forConstructor(constructor2, type2);
            this.setBinding(new ConstructorBindingImpl(base2.getKey(), base2.getSource(), base2.getScoping(), constructorPoint, injectionPoints));
        }
        catch (ConfigurationException e) {
            this.copyErrorsToBinder(e);
        }
        return this;
    }

    public String toString() {
        return "BindingBuilder<" + this.getBinding().getKey().getTypeLiteral() + ">";
    }

    private void copyErrorsToBinder(ConfigurationException e) {
        for (Message message2 : e.getErrorMessages()) {
            this.binder.addError(message2);
        }
    }
}

