/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.inject.internal.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;

public final class Classes {
    public static boolean isInnerClass(Class<?> clazz) {
        return !Modifier.isStatic(clazz.getModifiers()) && clazz.getEnclosingClass() != null;
    }

    public static boolean isConcrete(Class<?> clazz) {
        int modifiers2 = clazz.getModifiers();
        return !clazz.isInterface() && !Modifier.isAbstract(modifiers2);
    }

    public static String toString(Member member2) {
        Class<? extends Member> memberType = Classes.memberType(member2);
        if (memberType == Method.class) {
            return member2.getDeclaringClass().getName() + "." + member2.getName() + "()";
        }
        if (memberType == Field.class) {
            return member2.getDeclaringClass().getName() + "." + member2.getName();
        }
        if (memberType == Constructor.class) {
            return member2.getDeclaringClass().getName() + ".<init>()";
        }
        throw new AssertionError();
    }

    public static Class<? extends Member> memberType(Member member2) {
        Preconditions.checkNotNull(member2, "member");
        if (member2 instanceof Field) {
            return Field.class;
        }
        if (member2 instanceof Method) {
            return Method.class;
        }
        if (member2 instanceof Constructor) {
            return Constructor.class;
        }
        throw new IllegalArgumentException("Unsupported implementation class for Member, " + member2.getClass());
    }
}

