/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.backend.ConversionTypeContext;
import org.jetbrains.kotlin.fir.backend.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrBuiltIns;
import org.jetbrains.kotlin.fir.backend.Fir2IrClassifierStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrDeclarationStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrSignatureComposer;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrVisibilityConverter;
import org.jetbrains.kotlin.fir.backend.generators.AnnotationGenerator;
import org.jetbrains.kotlin.fir.backend.generators.CallAndReferenceGenerator;
import org.jetbrains.kotlin.fir.backend.generators.DelegatedMemberGenerator;
import org.jetbrains.kotlin.fir.backend.generators.FakeOverrideGenerator;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.substitution.AbstractConeSubstitutor;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeConflictingProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeApproximator;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.CustomAnnotationTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitAnyTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBooleanTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitIntTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitNothingTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitNullableAnyTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitNullableNothingTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitStringTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitUnitTypeRef;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrLock;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeAbbreviation;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.types.impl.IrStarProjectionImpl;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00ed\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000*\u0001S\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020]H\u0002J\u0014\u0010_\u001a\u0004\u0018\u00010\u00172\b\u0010`\u001a\u0004\u0018\u00010\u0016H\u0002J\u0014\u0010a\u001a\u0004\u0018\u00010\u00172\b\u0010`\u001a\u0004\u0018\u00010\u0016H\u0002J\u001a\u0010b\u001a\u00020c*\u00020]2\f\u0010d\u001a\b\u0012\u0004\u0012\u00020\u00120eH\u0002J.\u0010f\u001a\u00020\u0013*\u00020]2\b\b\u0002\u0010g\u001a\u00020h2\u000e\b\u0002\u0010i\u001a\b\u0012\u0004\u0012\u00020k0j2\b\b\u0002\u0010l\u001a\u00020cJ\u0014\u0010f\u001a\u00020\u0013*\u00020m2\b\b\u0002\u0010g\u001a\u00020hJ\u0014\u0010n\u001a\u00020o*\u00020p2\u0006\u0010g\u001a\u00020hH\u0002R\u0012\u0010\u0004\u001a\u00020\u0005X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00158@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R'\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00130\u00158@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001b\u001a\u0004\b\u001d\u0010\u0019R\u0012\u0010\u001f\u001a\u00020 X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010#\u001a\u00020$X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0012\u0010'\u001a\u00020(X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u001b\u0010+\u001a\u00020,8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010\u001b\u001a\u0004\b-\u0010.R\u0012\u00100\u001a\u000201X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0012\u00104\u001a\u000205X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0012\u00108\u001a\u000209X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0012\u0010<\u001a\u00020=X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0012\u0010@\u001a\u00020AX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR\u0012\u0010D\u001a\u00020EX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bF\u0010GR\u0012\u0010H\u001a\u00020IX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bJ\u0010KR\u0012\u0010L\u001a\u00020MX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bN\u0010OR\u000e\u0010P\u001a\u00020QX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010R\u001a\u00020SX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010TR\u0012\u0010U\u001a\u00020\u0000X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bV\u0010WR\u0012\u0010X\u001a\u00020YX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bZ\u0010[\u00a8\u0006q"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "components", "(Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;)V", "annotationGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "getAnnotationGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "builtIns", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltIns;", "callGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "getCallGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "capturedTypeCache", "", "Lorg/jetbrains/kotlin/fir/types/ConeCapturedType;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "classIdToSymbolMap", "", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getClassIdToSymbolMap$fir2ir", "()Ljava/util/Map;", "classIdToSymbolMap$delegate", "Lkotlin/Lazy;", "classIdToTypeMap", "getClassIdToTypeMap$fir2ir", "classIdToTypeMap$delegate", "classifierStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "getClassifierStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "declarationStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "getDeclarationStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "delegatedMemberGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/DelegatedMemberGenerator;", "getDelegatedMemberGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/DelegatedMemberGenerator;", "errorTypeForCapturedTypeStub", "Lorg/jetbrains/kotlin/ir/types/IrErrorType;", "getErrorTypeForCapturedTypeStub", "()Lorg/jetbrains/kotlin/ir/types/IrErrorType;", "errorTypeForCapturedTypeStub$delegate", "fakeOverrideGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/FakeOverrideGenerator;", "getFakeOverrideGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/FakeOverrideGenerator;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "getIrFactory", "()Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "lock", "Lorg/jetbrains/kotlin/ir/IrLock;", "getLock", "()Lorg/jetbrains/kotlin/ir/IrLock;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "signatureComposer", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrSignatureComposer;", "getSignatureComposer", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrSignatureComposer;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "typeApproximator", "Lorg/jetbrains/kotlin/fir/types/ConeTypeApproximator;", "typeApproximatorConfiguration", "org/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter$typeApproximatorConfiguration$1", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter$typeApproximatorConfiguration$1;", "typeConverter", "getTypeConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "visibilityConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "getVisibilityConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "approximateType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "type", "getArrayClassSymbol", "classId", "getBuiltInClassSymbol", "isRecursive", "", "visited", "", "toIrType", "typeContext", "Lorg/jetbrains/kotlin/fir/backend/ConversionTypeContext;", "annotations", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "hasFlexibleNullability", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "toIrTypeArgument", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "fir2ir"})
public final class Fir2IrTypeConverter
implements Fir2IrComponents {
    @NotNull
    private final Fir2IrComponents components;
    @NotNull
    private final Lazy classIdToSymbolMap$delegate;
    @NotNull
    private final Lazy classIdToTypeMap$delegate;
    @NotNull
    private final Map<ConeCapturedType, IrType> capturedTypeCache;
    @NotNull
    private final Lazy errorTypeForCapturedTypeStub$delegate;
    @NotNull
    private final ConeTypeApproximator typeApproximator;
    @NotNull
    private final typeApproximatorConfiguration.1 typeApproximatorConfiguration;

    public Fir2IrTypeConverter(@NotNull Fir2IrComponents components2) {
        Intrinsics.checkNotNullParameter(components2, "components");
        this.components = components2;
        this.classIdToSymbolMap$delegate = LazyKt.lazy((Function0)new Function0<Map<ClassId, ? extends IrClassSymbol>>(this){
            final /* synthetic */ Fir2IrTypeConverter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Map<ClassId, IrClassSymbol> invoke() {
                Pair[] pairArray = new Pair[]{TuplesKt.to(StandardClassIds.INSTANCE.getNothing(), this.this$0.getIrBuiltIns().getNothingClass()), TuplesKt.to(StandardClassIds.INSTANCE.getUnit(), this.this$0.getIrBuiltIns().getUnitClass()), TuplesKt.to(StandardClassIds.INSTANCE.getBoolean(), this.this$0.getIrBuiltIns().getBooleanClass()), TuplesKt.to(StandardClassIds.INSTANCE.getString(), this.this$0.getIrBuiltIns().getStringClass()), TuplesKt.to(StandardClassIds.INSTANCE.getAny(), this.this$0.getIrBuiltIns().getAnyClass()), TuplesKt.to(StandardClassIds.INSTANCE.getLong(), this.this$0.getIrBuiltIns().getLongClass()), TuplesKt.to(StandardClassIds.INSTANCE.getInt(), this.this$0.getIrBuiltIns().getIntClass()), TuplesKt.to(StandardClassIds.INSTANCE.getShort(), this.this$0.getIrBuiltIns().getShortClass()), TuplesKt.to(StandardClassIds.INSTANCE.getByte(), this.this$0.getIrBuiltIns().getByteClass()), TuplesKt.to(StandardClassIds.INSTANCE.getFloat(), this.this$0.getIrBuiltIns().getFloatClass()), TuplesKt.to(StandardClassIds.INSTANCE.getDouble(), this.this$0.getIrBuiltIns().getDoubleClass()), TuplesKt.to(StandardClassIds.INSTANCE.getChar(), this.this$0.getIrBuiltIns().getCharClass()), TuplesKt.to(StandardClassIds.INSTANCE.getArray(), this.this$0.getIrBuiltIns().getArrayClass())};
                return MapsKt.mapOf(pairArray);
            }
        });
        this.classIdToTypeMap$delegate = LazyKt.lazy((Function0)new Function0<Map<ClassId, ? extends IrType>>(this){
            final /* synthetic */ Fir2IrTypeConverter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Map<ClassId, IrType> invoke() {
                Pair[] pairArray = new Pair[]{TuplesKt.to(StandardClassIds.INSTANCE.getNothing(), this.this$0.getIrBuiltIns().getNothingType()), TuplesKt.to(StandardClassIds.INSTANCE.getUnit(), this.this$0.getIrBuiltIns().getUnitType()), TuplesKt.to(StandardClassIds.INSTANCE.getBoolean(), this.this$0.getIrBuiltIns().getBooleanType()), TuplesKt.to(StandardClassIds.INSTANCE.getString(), this.this$0.getIrBuiltIns().getStringType()), TuplesKt.to(StandardClassIds.INSTANCE.getAny(), this.this$0.getIrBuiltIns().getAnyType()), TuplesKt.to(StandardClassIds.INSTANCE.getLong(), this.this$0.getIrBuiltIns().getLongType()), TuplesKt.to(StandardClassIds.INSTANCE.getInt(), this.this$0.getIrBuiltIns().getIntType()), TuplesKt.to(StandardClassIds.INSTANCE.getShort(), this.this$0.getIrBuiltIns().getShortType()), TuplesKt.to(StandardClassIds.INSTANCE.getByte(), this.this$0.getIrBuiltIns().getByteType()), TuplesKt.to(StandardClassIds.INSTANCE.getFloat(), this.this$0.getIrBuiltIns().getFloatType()), TuplesKt.to(StandardClassIds.INSTANCE.getDouble(), this.this$0.getIrBuiltIns().getDoubleType()), TuplesKt.to(StandardClassIds.INSTANCE.getChar(), this.this$0.getIrBuiltIns().getCharType())};
                return MapsKt.mapOf(pairArray);
            }
        });
        this.capturedTypeCache = new LinkedHashMap();
        this.errorTypeForCapturedTypeStub$delegate = LazyKt.lazy(errorTypeForCapturedTypeStub.2.INSTANCE);
        this.typeApproximator = new ConeTypeApproximator(SessionUtilsKt.getTypeContext(this.getSession()), FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.getSession()));
        this.typeApproximatorConfiguration = new TypeApproximatorConfiguration.AllFlexibleSameValue(){

            public boolean getAllFlexible() {
                return true;
            }

            public boolean getErrorType() {
                return true;
            }

            public boolean getIntegerLiteralType() {
                return true;
            }

            public boolean getIntersectionTypesInContravariantPositions() {
                return true;
            }
        };
    }

    @Override
    @NotNull
    public AnnotationGenerator getAnnotationGenerator() {
        return this.components.getAnnotationGenerator();
    }

    @Override
    @NotNull
    public Fir2IrBuiltIns getBuiltIns() {
        return this.components.getBuiltIns();
    }

    @Override
    @NotNull
    public CallAndReferenceGenerator getCallGenerator() {
        return this.components.getCallGenerator();
    }

    @Override
    @NotNull
    public Fir2IrClassifierStorage getClassifierStorage() {
        return this.components.getClassifierStorage();
    }

    @Override
    @NotNull
    public Fir2IrDeclarationStorage getDeclarationStorage() {
        return this.components.getDeclarationStorage();
    }

    @Override
    @NotNull
    public DelegatedMemberGenerator getDelegatedMemberGenerator() {
        return this.components.getDelegatedMemberGenerator();
    }

    @Override
    @NotNull
    public FakeOverrideGenerator getFakeOverrideGenerator() {
        return this.components.getFakeOverrideGenerator();
    }

    @Override
    @NotNull
    public IrBuiltIns getIrBuiltIns() {
        return this.components.getIrBuiltIns();
    }

    @Override
    @NotNull
    public IrFactory getIrFactory() {
        return this.components.getIrFactory();
    }

    @Override
    @NotNull
    public IrLock getLock() {
        return this.components.getLock();
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        return this.components.getScopeSession();
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.components.getSession();
    }

    @Override
    @NotNull
    public Fir2IrSignatureComposer getSignatureComposer() {
        return this.components.getSignatureComposer();
    }

    @Override
    @NotNull
    public SymbolTable getSymbolTable() {
        return this.components.getSymbolTable();
    }

    @Override
    @NotNull
    public Fir2IrTypeConverter getTypeConverter() {
        return this.components.getTypeConverter();
    }

    @Override
    @NotNull
    public Fir2IrVisibilityConverter getVisibilityConverter() {
        return this.components.getVisibilityConverter();
    }

    @NotNull
    public final Map<ClassId, IrClassSymbol> getClassIdToSymbolMap$fir2ir() {
        Lazy lazy = this.classIdToSymbolMap$delegate;
        Object var2_2 = null;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final Map<ClassId, IrType> getClassIdToTypeMap$fir2ir() {
        Lazy lazy = this.classIdToTypeMap$delegate;
        Object var2_2 = null;
        return (Map)lazy.getValue();
    }

    private final IrErrorType getErrorTypeForCapturedTypeStub() {
        Lazy lazy = this.errorTypeForCapturedTypeStub$delegate;
        Object var2_2 = null;
        return (IrErrorType)lazy.getValue();
    }

    @NotNull
    public final IrType toIrType(@NotNull FirTypeRef $this$toIrType, @NotNull ConversionTypeContext typeContext) {
        Intrinsics.checkNotNullParameter($this$toIrType, "<this>");
        Intrinsics.checkNotNullParameter(typeContext, "typeContext");
        this.capturedTypeCache.clear();
        FirTypeRef firTypeRef = $this$toIrType;
        return !(firTypeRef instanceof FirResolvedTypeRef) ? (IrType)ConversionUtilsKt.createErrorType() : (!(firTypeRef instanceof FirImplicitBuiltinTypeRef) ? Fir2IrTypeConverter.toIrType$default(this, ((FirResolvedTypeRef)$this$toIrType).getType(), typeContext, $this$toIrType.getAnnotations(), false, 4, null) : (firTypeRef instanceof FirImplicitNothingTypeRef ? this.getIrBuiltIns().getNothingType() : (firTypeRef instanceof FirImplicitUnitTypeRef ? this.getIrBuiltIns().getUnitType() : (firTypeRef instanceof FirImplicitBooleanTypeRef ? this.getIrBuiltIns().getBooleanType() : (firTypeRef instanceof FirImplicitStringTypeRef ? this.getIrBuiltIns().getStringType() : (firTypeRef instanceof FirImplicitAnyTypeRef ? this.getIrBuiltIns().getAnyType() : (firTypeRef instanceof FirImplicitIntTypeRef ? this.getIrBuiltIns().getIntType() : (firTypeRef instanceof FirImplicitNullableAnyTypeRef ? this.getIrBuiltIns().getAnyNType() : (firTypeRef instanceof FirImplicitNullableNothingTypeRef ? this.getIrBuiltIns().getNothingNType() : Fir2IrTypeConverter.toIrType$default(this, ((FirImplicitBuiltinTypeRef)$this$toIrType).getType(), typeContext, $this$toIrType.getAnnotations(), false, 4, null))))))))));
    }

    public static /* synthetic */ IrType toIrType$default(Fir2IrTypeConverter fir2IrTypeConverter, FirTypeRef firTypeRef, ConversionTypeContext conversionTypeContext, int n, Object object) {
        if ((n & 1) != 0) {
            conversionTypeContext = ConversionTypeContext.Companion.getDEFAULT$fir2ir();
        }
        return fir2IrTypeConverter.toIrType(firTypeRef, conversionTypeContext);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IrType toIrType(@NotNull ConeKotlinType $this$toIrType, @NotNull ConversionTypeContext typeContext, @NotNull List<? extends FirAnnotationCall> annotations2, boolean hasFlexibleNullability) {
        IrType irType;
        Intrinsics.checkNotNullParameter($this$toIrType, "<this>");
        Intrinsics.checkNotNullParameter(typeContext, "typeContext");
        Intrinsics.checkNotNullParameter(annotations2, "annotations");
        ConeKotlinType coneKotlinType = $this$toIrType;
        if (coneKotlinType instanceof ConeClassErrorType) {
            irType = ConversionUtilsKt.createErrorType();
        } else if (coneKotlinType instanceof ConeLookupTagBasedType) {
            Collection<IrTypeArgument> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object;
            IrClassifierSymbol irSymbol2;
            IrClassifierSymbol irClassifierSymbol;
            Object object2;
            List typeAnnotations = new ArrayList();
            Collection collection2 = typeAnnotations;
            Object $this$toIrType_u24lambda_u2d0 = object2 = this.getAnnotationGenerator();
            boolean bl = false;
            object2 = ((AnnotationGenerator)$this$toIrType_u24lambda_u2d0).toIrAnnotations(annotations2);
            CollectionsKt.addAll(collection2, object2);
            object2 = this.getBuiltInClassSymbol(ConeTypeUtilsKt.getClassId($this$toIrType));
            if (object2 == null) {
                $this$toIrType_u24lambda_u2d0 = LookupTagUtilsKt.toSymbol(((ConeLookupTagBasedType)$this$toIrType).getLookupTag(), this.getSession());
                if ($this$toIrType_u24lambda_u2d0 == null) {
                    return ConversionUtilsKt.createErrorType();
                }
                irClassifierSymbol = ConversionUtilsKt.toSymbol($this$toIrType_u24lambda_u2d0, this.getSession(), this.getClassifierStorage(), typeContext, (Function1<? super List<? extends FirAnnotationCall>, Unit>)new Function1<List<? extends FirAnnotationCall>, Unit>((List<IrConstructorCall>)typeAnnotations, this){
                    final /* synthetic */ List<IrConstructorCall> $typeAnnotations;
                    final /* synthetic */ Fir2IrTypeConverter this$0;
                    {
                        this.$typeAnnotations = $typeAnnotations;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull List<? extends FirAnnotationCall> it) {
                        void $this$invoke_u24lambda_u2d0;
                        AnnotationGenerator annotationGenerator;
                        Intrinsics.checkNotNullParameter(it, "it");
                        AnnotationGenerator annotationGenerator2 = annotationGenerator = this.this$0.getAnnotationGenerator();
                        Collection collection = this.$typeAnnotations;
                        boolean bl = false;
                        List<IrConstructorCall> list2 = $this$invoke_u24lambda_u2d0.toIrAnnotations(it);
                        CollectionsKt.addAll(collection, (Iterable)list2);
                    }
                });
            } else {
                irClassifierSymbol = irSymbol2 = (IrClassifierSymbol)object2;
            }
            if (CompilerConeAttributesKt.getHasEnhancedNullability($this$toIrType)) {
                object2 = this.getBuiltIns().enhancedNullabilityAnnotationConstructorCall$fir2ir();
                if (object2 != null) {
                    Iterator<FirAnnotationCall> it = $this$toIrType_u24lambda_u2d0 = object2;
                    boolean bl2 = false;
                    object = typeAnnotations;
                    object.add(it);
                }
            } else if (hasFlexibleNullability && (object2 = this.getBuiltIns().flexibleNullabilityAnnotationConstructorCall$fir2ir()) != null) {
                Iterator<FirAnnotationCall> it = $this$toIrType_u24lambda_u2d0 = object2;
                boolean bl3 = false;
                object = typeAnnotations;
                object.add(it);
            }
            for (FirAnnotationCall attributeAnnotation : CustomAnnotationTypeAttributeKt.getCustomAnnotations($this$toIrType.getAttributes())) {
                IrConstructorCall $i$f$any2;
                boolean bl4;
                Iterable $this$any$iv;
                block35: {
                    $this$any$iv = annotations2;
                    boolean $i$f$any2 = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl4 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ClassId classId;
                            ClassId classId2;
                            ConeClassLikeType coneClassLikeType;
                            FirAnnotationCall it = (FirAnnotationCall)element$iv;
                            boolean bl5 = false;
                            FirAnnotationCall $this$classId$iv = it;
                            boolean $i$f$getClassId = false;
                            Object $this$coneClassLikeType$iv$iv = $this$classId$iv;
                            boolean $i$f$getConeClassLikeType = false;
                            FirTypeRef firTypeRef = ((FirAnnotationCall)$this$coneClassLikeType$iv$iv).getAnnotationTypeRef();
                            FirResolvedTypeRef firResolvedTypeRef = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
                            ConeKotlinType coneKotlinType2 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
                            ConeClassLikeType coneClassLikeType2 = coneClassLikeType = coneKotlinType2 instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType2 : null;
                            if (coneClassLikeType == null) {
                                classId2 = null;
                            } else {
                                $this$coneClassLikeType$iv$iv = coneClassLikeType.getLookupTag();
                                classId2 = ((ConeClassLikeLookupTag)$this$coneClassLikeType$iv$iv).getClassId();
                            }
                            $this$classId$iv = attributeAnnotation;
                            $i$f$getClassId = false;
                            $this$coneClassLikeType$iv$iv = $this$classId$iv;
                            $i$f$getConeClassLikeType = false;
                            firTypeRef = ((FirAnnotationCall)$this$coneClassLikeType$iv$iv).getAnnotationTypeRef();
                            firResolvedTypeRef = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
                            coneKotlinType2 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
                            ConeClassLikeType coneClassLikeType3 = coneClassLikeType = coneKotlinType2 instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType2 : null;
                            if (coneClassLikeType == null) {
                                classId = null;
                            } else {
                                $this$coneClassLikeType$iv$iv = coneClassLikeType.getLookupTag();
                                classId = ((ConeClassLikeLookupTag)$this$coneClassLikeType$iv$iv).getClassId();
                            }
                            if (!Intrinsics.areEqual(classId2, classId)) continue;
                            bl4 = true;
                            break block35;
                        }
                        bl4 = false;
                    }
                }
                if (bl4) continue;
                $this$any$iv = typeAnnotations;
                object = this.getCallGenerator().convertToIrConstructorCall(attributeAnnotation);
                IrConstructorCall irConstructorCall = $i$f$any2 = object instanceof IrConstructorCall ? (IrConstructorCall)object : null;
                if ($i$f$any2 == null) continue;
                $this$any$iv.add($i$f$any2);
            }
            ConeKotlinType expandedType2 = TypeExpansionUtilsKt.fullyExpandedType($this$toIrType, this.getSession());
            ConeKotlinType approximatedType = this.approximateType(expandedType2);
            ConeTypeProjection[] $this$any$iv = approximatedType.getTypeArguments();
            boolean bl6 = !typeContext.getDefinitelyNotNull$fir2ir() && ConeTypeUtilsKt.isMarkedNullable(approximatedType);
            IrClassifierSymbol irClassifierSymbol2 = irSymbol2;
            boolean $i$f$map = false;
            object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                void $i$f$getConeClassLikeType = item$iv$iv;
                collection = destination$iv$iv;
                boolean bl7 = false;
                IrTypeArgument irTypeArgument = this.toIrTypeArgument((ConeTypeProjection)it, typeContext);
                collection.add(irTypeArgument);
            }
            collection = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 16;
            IrTypeAbbreviation irTypeAbbreviation = null;
            List list2 = typeAnnotations;
            List list3 = collection;
            boolean bl8 = bl6;
            IrClassifierSymbol irClassifierSymbol3 = irClassifierSymbol2;
            irType = new IrSimpleTypeImpl(irClassifierSymbol3, bl8, list3, list2, irTypeAbbreviation, n, defaultConstructorMarker);
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            irType = Fir2IrTypeConverter.toIrType$default(this, ((ConeFlexibleType)$this$toIrType).getUpperBound(), typeContext, null, ((ConeFlexibleType)$this$toIrType).getLowerBound().getNullability() != ((ConeFlexibleType)$this$toIrType).getUpperBound().getNullability(), 2, null);
        } else if (coneKotlinType instanceof ConeCapturedType) {
            IrType cached2 = this.capturedTypeCache.get($this$toIrType);
            if (cached2 == null) {
                Object v9;
                Object object;
                Object object3;
                List<ConeKotlinType> supertypes2;
                KotlinTypeMarker approximatedType;
                block36: {
                    Map<ConeCapturedType, IrType> irSymbol2 = this.capturedTypeCache;
                    ConeKotlinType expandedType2 = $this$toIrType;
                    approximatedType = this.getErrorTypeForCapturedTypeStub();
                    irSymbol2.put((ConeCapturedType)expandedType2, (IrType)approximatedType);
                    List<ConeKotlinType> list4 = ((ConeCapturedType)$this$toIrType).getConstructor().getSupertypes();
                    Intrinsics.checkNotNull(list4);
                    supertypes2 = list4;
                    object = object3 = (Iterable)supertypes2;
                    Iterator iterator2 = object.iterator();
                    while (iterator2.hasNext()) {
                        Object t = iterator2.next();
                        ConeKotlinType it = (ConeKotlinType)t;
                        boolean bl = false;
                        ConeTypeProjection coneTypeProjection = ((ConeCapturedType)$this$toIrType).getConstructor().getProjection();
                        ConeKotlinTypeProjection coneKotlinTypeProjection = coneTypeProjection instanceof ConeKotlinTypeProjection ? (ConeKotlinTypeProjection)coneTypeProjection : null;
                        if (!Intrinsics.areEqual(it, coneKotlinTypeProjection == null ? null : coneKotlinTypeProjection.getType())) continue;
                        v9 = t;
                        break block36;
                    }
                    v9 = null;
                }
                approximatedType = v9;
                KotlinTypeMarker approximation = approximatedType == null ? CollectionsKt.first(supertypes2) : approximatedType;
                IrType irType2 = Fir2IrTypeConverter.toIrType$default(this, (ConeKotlinType)approximation, typeContext, null, false, 6, null);
                object3 = this.capturedTypeCache;
                object = $this$toIrType;
                object3.put(object, irType2);
                irType = irType2;
            } else {
                irType = cached2;
            }
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            irType = Fir2IrTypeConverter.toIrType$default(this, ((ConeDefinitelyNotNullType)$this$toIrType).getOriginal(), typeContext.definitelyNotNull(), null, false, 6, null);
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            irType = Fir2IrTypeConverter.toIrType$default(this, (ConeKotlinType)CollectionsKt.first((Iterable)((ConeIntersectionType)$this$toIrType).getIntersectedTypes()), typeContext, null, false, 6, null);
        } else if (coneKotlinType instanceof ConeStubType) {
            irType = ConversionUtilsKt.createErrorType();
        } else if (coneKotlinType instanceof ConeIntegerLiteralType) {
            irType = ConversionUtilsKt.createErrorType();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return irType;
    }

    public static /* synthetic */ IrType toIrType$default(Fir2IrTypeConverter fir2IrTypeConverter, ConeKotlinType coneKotlinType, ConversionTypeContext conversionTypeContext, List list2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            conversionTypeContext = ConversionTypeContext.Companion.getDEFAULT$fir2ir();
        }
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return fir2IrTypeConverter.toIrType(coneKotlinType, conversionTypeContext, list2, bl);
    }

    private final IrTypeArgument toIrTypeArgument(ConeTypeProjection $this$toIrTypeArgument, ConversionTypeContext typeContext) {
        IrTypeArgument irTypeArgument;
        ConeTypeProjection coneTypeProjection = $this$toIrTypeArgument;
        if (Intrinsics.areEqual(coneTypeProjection, ConeStarProjection.INSTANCE)) {
            irTypeArgument = IrStarProjectionImpl.INSTANCE;
        } else if (coneTypeProjection instanceof ConeKotlinTypeProjectionIn) {
            irTypeArgument = Fir2IrTypeConverter.toIrTypeArgument$toIrTypeArgument(this, typeContext, ((ConeKotlinTypeProjectionIn)$this$toIrTypeArgument).getType(), Variance.IN_VARIANCE);
        } else if (coneTypeProjection instanceof ConeKotlinTypeProjectionOut) {
            irTypeArgument = Fir2IrTypeConverter.toIrTypeArgument$toIrTypeArgument(this, typeContext, ((ConeKotlinTypeProjectionOut)$this$toIrTypeArgument).getType(), Variance.OUT_VARIANCE);
        } else if (coneTypeProjection instanceof ConeKotlinTypeConflictingProjection) {
            irTypeArgument = Fir2IrTypeConverter.toIrTypeArgument$toIrTypeArgument(this, typeContext, ((ConeKotlinTypeConflictingProjection)$this$toIrTypeArgument).getType(), Variance.INVARIANT);
        } else if (coneTypeProjection instanceof ConeKotlinType) {
            Map<ConeCapturedType, IrType> map2;
            if ($this$toIrTypeArgument instanceof ConeCapturedType && (map2 = this.capturedTypeCache).containsKey($this$toIrTypeArgument) && this.isRecursive((ConeKotlinType)$this$toIrTypeArgument, new LinkedHashSet())) {
                irTypeArgument = IrStarProjectionImpl.INSTANCE;
            } else {
                IrType irType = Fir2IrTypeConverter.toIrType$default(this, (ConeKotlinType)$this$toIrTypeArgument, typeContext, null, false, 6, null);
                irTypeArgument = IrSimpleTypeImplKt.makeTypeProjection(irType, Variance.INVARIANT);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return irTypeArgument;
    }

    private final boolean isRecursive(ConeKotlinType $this$isRecursive, Set<ConeCapturedType> visited2) {
        boolean bl;
        block21: {
            ConeKotlinType coneKotlinType = $this$isRecursive;
            if (coneKotlinType instanceof ConeLookupTagBasedType) {
                ConeTypeProjection[] $this$any$iv = $this$isRecursive.getTypeArguments();
                boolean $i$f$any = false;
                ConeTypeProjection[] coneTypeProjectionArray = $this$any$iv;
                int n = 0;
                int n2 = coneTypeProjectionArray.length;
                while (n < n2) {
                    ConeTypeProjection element$iv = coneTypeProjectionArray[n];
                    ++n;
                    ConeTypeProjection it = element$iv;
                    boolean bl2 = false;
                    ConeTypeProjection coneTypeProjection = it;
                    boolean bl3 = coneTypeProjection instanceof ConeKotlinType ? this.isRecursive((ConeKotlinType)it, visited2) : (coneTypeProjection instanceof ConeKotlinTypeProjectionIn ? this.isRecursive(((ConeKotlinTypeProjectionIn)it).getType(), visited2) : (coneTypeProjection instanceof ConeKotlinTypeProjectionOut ? this.isRecursive(((ConeKotlinTypeProjectionOut)it).getType(), visited2) : false));
                    if (!bl3) continue;
                    bl = true;
                    break block21;
                }
                bl = false;
            } else if (coneKotlinType instanceof ConeFlexibleType) {
                bl = this.isRecursive(((ConeFlexibleType)$this$isRecursive).getLowerBound(), visited2) || this.isRecursive(((ConeFlexibleType)$this$isRecursive).getUpperBound(), visited2);
            } else if (coneKotlinType instanceof ConeCapturedType) {
                if (visited2.add((ConeCapturedType)$this$isRecursive)) {
                    List<ConeKotlinType> $this$any$iv = ((ConeCapturedType)$this$isRecursive).getConstructor().getSupertypes();
                    if ($this$any$iv == null) {
                        bl = false;
                    } else {
                        boolean bl4;
                        block22: {
                            Iterable $this$any$iv2 = $this$any$iv;
                            boolean $i$f$any = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl4 = false;
                            } else {
                                for (Object element$iv : $this$any$iv2) {
                                    ConeKotlinType it = (ConeKotlinType)element$iv;
                                    boolean bl5 = false;
                                    if (!this.isRecursive(it, visited2)) continue;
                                    bl4 = true;
                                    break block22;
                                }
                                bl4 = false;
                            }
                        }
                        bl = bl4;
                    }
                } else {
                    bl = true;
                }
            } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
                bl = this.isRecursive(((ConeDefinitelyNotNullType)$this$isRecursive).getOriginal(), visited2);
            } else if (coneKotlinType instanceof ConeIntersectionType) {
                Iterable $this$any$iv = ((ConeIntersectionType)$this$isRecursive).getIntersectedTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ConeKotlinType it = (ConeKotlinType)element$iv;
                        boolean bl6 = false;
                        if (!this.isRecursive(it, visited2)) continue;
                        bl = true;
                        break block21;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final IrClassSymbol getArrayClassSymbol(ClassId classId) {
        Object object = StandardClassIds.INSTANCE.getElementTypeByPrimitiveArrayType();
        ClassId classId2 = object.get(classId);
        if (classId2 == null) {
            return null;
        }
        ClassId primitiveId = classId2;
        IrType irType = this.getClassIdToTypeMap$fir2ir().get(primitiveId);
        object = this.getIrBuiltIns().getPrimitiveArrayForType().get(irType);
        if (object == null) {
            String string2 = "Strange primitiveId " + primitiveId + " from array: " + classId;
            throw new IllegalStateException(string2.toString());
        }
        return object;
    }

    private final IrClassSymbol getBuiltInClassSymbol(ClassId classId) {
        Map<ClassId, IrClassSymbol> map2 = this.getClassIdToSymbolMap$fir2ir();
        IrClassSymbol irClassSymbol = map2.get(classId);
        return irClassSymbol == null ? this.getArrayClassSymbol(classId) : irClassSymbol;
    }

    private final ConeKotlinType approximateType(ConeKotlinType type2) {
        if (type2 instanceof ConeClassLikeType && type2.getTypeArguments().length == 0) {
            return type2;
        }
        Object object = SessionUtilsKt.getTypeContext(this.getSession());
        AbstractConeSubstitutor substitutor2 = new AbstractConeSubstitutor((ConeInferenceContext)object){

            @Nullable
            public ConeKotlinType substituteType(@NotNull ConeKotlinType type2) {
                ConeKotlinType coneKotlinType;
                Intrinsics.checkNotNullParameter(type2, "type");
                if (type2 instanceof ConeIntersectionType) {
                    ConeKotlinType coneKotlinType2 = ((ConeIntersectionType)type2).getAlternativeType();
                    if (coneKotlinType2 == null) {
                        coneKotlinType = null;
                    } else {
                        ConeKotlinType coneKotlinType3;
                        ConeKotlinType it = coneKotlinType3 = coneKotlinType2;
                        boolean bl = false;
                        coneKotlinType = this.substituteOrSelf(it);
                    }
                } else {
                    coneKotlinType = null;
                }
                return coneKotlinType;
            }
        };
        Object it = object = substitutor2.substituteOrSelf(type2);
        boolean bl = false;
        ConeKotlinType coneKotlinType = this.typeApproximator.approximateToSuperType((ConeKotlinType)it, (TypeApproximatorConfiguration)this.typeApproximatorConfiguration);
        return coneKotlinType == null ? it : coneKotlinType;
    }

    private static final IrTypeProjection toIrTypeArgument$toIrTypeArgument(Fir2IrTypeConverter this$0, ConversionTypeContext $typeContext, ConeKotlinType type2, Variance variance) {
        IrType irType = Fir2IrTypeConverter.toIrType$default(this$0, type2, $typeContext, null, false, 6, null);
        return IrSimpleTypeImplKt.makeTypeProjection(irType, $typeContext.getInvariantProjection$fir2ir() ? Variance.INVARIANT : variance);
    }
}

