/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirProvider;
import org.jetbrains.kotlin.fir.resolve.transformers.AbstractFirStatusResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.FirDesignatedStatusResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.FirStatusResolver;
import org.jetbrains.kotlin.fir.resolve.transformers.StatusComputationSession;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirPhaseManagerKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirTransformerUtilKt;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00e6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0004J\u0010\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020\u000bH\u0004J\u0010\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020$2\u0006\u0010'\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020$2\u0006\u0010'\u001a\u00020,H\u0004J\"\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u00112\f\u00101\u001a\b\u0012\u0004\u0012\u00020/02H\u0084\b\u00f8\u0001\u0000J\u001a\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u00108\u001a\u0002042\u0006\u00109\u001a\u00020:2\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010;\u001a\u0002042\u0006\u00100\u001a\u00020\u00112\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010<\u001a\u0002042\u0006\u0010=\u001a\u00020>2\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010?\u001a\u00020/2\u0006\u0010@\u001a\u00020/2\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010A\u001a\u00020/2\u0006\u0010@\u001a\u00020/2\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020C2\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010E\u001a\u0002042\u0006\u0010F\u001a\u00020G2\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010H\u001a\u0002042\u0006\u0010I\u001a\u00020J2\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020L2\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010N\u001a\u0002042\u0006\u0010O\u001a\u00020P2\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\u0018\u0010Q\u001a\u00020$2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020PH\u0002J\u001a\u0010U\u001a\u0002042\u0006\u0010'\u001a\u00020,2\b\u00107\u001a\u0004\u0018\u00010\u0002H&J\u001a\u0010V\u001a\u0002042\u0006\u0010%\u001a\u00020W2\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010X\u001a\u0002042\u0006\u0010Y\u001a\u00020Z2\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020^2\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010_\u001a\u0002042\u0006\u0010`\u001a\u00020a2\b\u00107\u001a\u0004\u0018\u00010\u0002H\u0016J\f\u0010b\u001a\u00020c*\u00020/H$J\f\u0010d\u001a\u00020c*\u00020/H$R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00118DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\"\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006e"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/AbstractFirStatusResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformer;", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "statusComputationSession", "Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;", "designationMapForLocalClasses", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "scopeForLocalClass", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;Ljava/util/Map;Lorg/jetbrains/kotlin/fir/scopes/FirScope;)V", "classes", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getClasses", "()Ljava/util/List;", "containingClass", "getContainingClass", "()Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getDesignationMapForLocalClasses", "()Ljava/util/Map;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getStatusComputationSession", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;", "statusResolver", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirStatusResolver;", "getStatusResolver", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/FirStatusResolver;", "calculateDeprecations", "", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "regularClass", "forceResolveStatusOfCorrespondingClass", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "forceResolveStatusesOfClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "forceResolveStatusesOfSupertypes", "storeClass", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "klass", "computeResult", "Lkotlin/Function0;", "transformAnonymousObject", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "data", "transformBlock", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "transformClass", "transformConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "transformDeclaration", "declaration", "transformDeclarationContent", "transformDeclarationStatus", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationStatus;", "declarationStatus", "transformEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "transformField", "field", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "transformFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "transformProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "transformPropertyAccessor", "propertyAccessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "containingProperty", "transformRegularClass", "transformSimpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "transformTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "transformTypeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRef;", "typeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "transformValueParameter", "valueParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "needResolveMembers", "", "needResolveNestedClassifiers", "resolve"})
public abstract class AbstractFirStatusResolveTransformer
extends FirAbstractTreeTransformer<FirResolvedDeclarationStatus> {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final StatusComputationSession statusComputationSession;
    @NotNull
    private final Map<FirClassLikeDeclaration, FirClassLikeDeclaration> designationMapForLocalClasses;
    @Nullable
    private final FirScope scopeForLocalClass;
    @NotNull
    private final List<FirClass> classes;
    @NotNull
    private final FirStatusResolver statusResolver;

    public AbstractFirStatusResolveTransformer(@NotNull FirSession session2, @NotNull ScopeSession scopeSession, @NotNull StatusComputationSession statusComputationSession, @NotNull Map<FirClassLikeDeclaration, ? extends FirClassLikeDeclaration> designationMapForLocalClasses, @Nullable FirScope scopeForLocalClass) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        Intrinsics.checkNotNullParameter(statusComputationSession, "statusComputationSession");
        Intrinsics.checkNotNullParameter(designationMapForLocalClasses, "designationMapForLocalClasses");
        super(FirResolvePhase.STATUS);
        this.session = session2;
        this.scopeSession = scopeSession;
        this.statusComputationSession = statusComputationSession;
        this.designationMapForLocalClasses = designationMapForLocalClasses;
        this.scopeForLocalClass = scopeForLocalClass;
        this.classes = new ArrayList();
        this.statusResolver = new FirStatusResolver(this.session, this.scopeSession);
    }

    @Override
    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    @NotNull
    protected final StatusComputationSession getStatusComputationSession() {
        return this.statusComputationSession;
    }

    @NotNull
    protected final Map<FirClassLikeDeclaration, FirClassLikeDeclaration> getDesignationMapForLocalClasses() {
        return this.designationMapForLocalClasses;
    }

    @NotNull
    protected final List<FirClass> getClasses() {
        return this.classes;
    }

    @NotNull
    protected final FirStatusResolver getStatusResolver() {
        return this.statusResolver;
    }

    @Nullable
    protected final FirClass getContainingClass() {
        return CollectionsKt.lastOrNull(this.classes);
    }

    protected abstract boolean needResolveMembers(@NotNull FirDeclaration var1);

    protected abstract boolean needResolveNestedClassifiers(@NotNull FirDeclaration var1);

    @Override
    @NotNull
    public FirFile transformFile(@NotNull FirFile file2, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        this.transformDeclarationContent(file2, data2);
        return file2;
    }

    @Override
    @NotNull
    public FirDeclarationStatus transformDeclarationStatus(@NotNull FirDeclarationStatus declarationStatus, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter(declarationStatus, "declarationStatus");
        FirResolvedDeclarationStatus firResolvedDeclarationStatus = data2;
        return firResolvedDeclarationStatus == null ? declarationStatus : (FirDeclarationStatus)firResolvedDeclarationStatus;
    }

    @NotNull
    protected final FirDeclaration storeClass(@NotNull FirClass klass, @NotNull Function0<? extends FirDeclaration> computeResult) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(computeResult, "computeResult");
        boolean $i$f$storeClass = false;
        AbstractFirStatusResolveTransformer abstractFirStatusResolveTransformer = this;
        Collection collection = abstractFirStatusResolveTransformer.classes;
        collection.add(klass);
        FirDeclaration result2 = computeResult.invoke();
        this.classes.remove(CollectionsKt.getLastIndex(this.classes));
        return result2;
    }

    @Override
    @NotNull
    public FirDeclaration transformDeclaration(@NotNull FirDeclaration declaration2, @Nullable FirResolvedDeclarationStatus data2) {
        FirDeclaration firDeclaration;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        FirDeclaration firDeclaration2 = declaration2;
        if (firDeclaration2 instanceof FirCallableDeclaration) {
            if (declaration2 instanceof FirFunction) {
                for (FirValueParameter valueParameter2 : ((FirFunction)declaration2).getValueParameters()) {
                    this.transformValueParameter(valueParameter2, data2);
                }
            }
            firDeclaration = declaration2;
        } else {
            firDeclaration = (FirDeclaration)this.transformElement((FirElement)declaration2, data2);
        }
        return firDeclaration;
    }

    @Override
    @NotNull
    public FirStatement transformTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
        Iterable $this$forEach$iv = typeAlias.getTypeParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirTypeParameter it = (FirTypeParameter)element$iv;
            boolean bl = false;
            this.transformDeclaration((FirDeclaration)it, data2);
        }
        typeAlias.transformStatus(this, this.statusResolver.resolveStatus(typeAlias, this.getContainingClass(), false));
        this.calculateDeprecations(typeAlias);
        return (FirTypeAlias)this.transformDeclaration((FirDeclaration)typeAlias, data2);
    }

    @Override
    @NotNull
    public abstract FirStatement transformRegularClass(@NotNull FirRegularClass var1, @Nullable FirResolvedDeclarationStatus var2);

    @Override
    @NotNull
    public FirStatement transformAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter(anonymousObject, "anonymousObject");
        return this.transformClass((FirClass)anonymousObject, data2);
    }

    @NotNull
    public FirDeclaration transformDeclarationContent(@NotNull FirDeclaration declaration2, @Nullable FirResolvedDeclarationStatus data2) {
        FirDeclaration it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        List<FirDeclaration> list2;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        FirDeclaration firDeclaration = declaration2;
        if (firDeclaration instanceof FirRegularClass) {
            list2 = ((FirRegularClass)declaration2).getDeclarations();
        } else if (firDeclaration instanceof FirAnonymousObject) {
            list2 = ((FirAnonymousObject)declaration2).getDeclarations();
        } else if (firDeclaration instanceof FirFile) {
            list2 = ((FirFile)declaration2).getDeclarations();
        } else {
            throw new IllegalStateException(Intrinsics.stringPlus("Not supported declaration ", Reflection.getOrCreateKotlinClass(declaration2.getClass()).getSimpleName()).toString());
        }
        List<FirDeclaration> declarations2 = list2;
        if (this.needResolveMembers(declaration2)) {
            $this$forEach$iv = declarations2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FirDeclaration)element$iv;
                boolean bl = false;
                if (it instanceof FirClassLikeDeclaration) continue;
                FirTransformerUtilKt.transformSingle((FirElement)it, this, data2);
            }
        }
        if (this.needResolveNestedClassifiers(declaration2)) {
            $this$forEach$iv = declarations2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FirDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof FirClassLikeDeclaration)) continue;
                FirTransformerUtilKt.transformSingle((FirElement)it, this, data2);
            }
        }
        return declaration2;
    }

    @Override
    @NotNull
    public FirStatement transformClass(@NotNull FirClass klass, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        AbstractFirStatusResolveTransformer this_$iv = this;
        boolean $i$f$storeClass = false;
        AbstractFirStatusResolveTransformer abstractFirStatusResolveTransformer = this_$iv;
        Collection collection = abstractFirStatusResolveTransformer.classes;
        collection.add(klass);
        boolean bl = false;
        Iterable $this$forEach$iv = klass.getTypeParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirTypeParameterRef it = (FirTypeParameterRef)element$iv;
            boolean bl2 = false;
            FirTransformerUtilKt.transformSingle((FirElement)it, this, data2);
        }
        FirDeclaration result$iv = this.transformDeclarationContent(klass, data2);
        this_$iv.classes.remove(CollectionsKt.getLastIndex(this_$iv.classes));
        return (FirStatement)((Object)result$iv);
    }

    protected final void forceResolveStatusesOfSupertypes(@NotNull FirRegularClass regularClass) {
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        for (FirTypeRef superTypeRef : regularClass.getSuperTypeRefs()) {
            this.forceResolveStatusOfCorrespondingClass(superTypeRef);
        }
    }

    private final void forceResolveStatusOfCorrespondingClass(FirTypeRef typeRef) {
        FirBasedSymbol<?> firBasedSymbol = TypeUtilsKt.toSymbol(FirTypeUtilsKt.getConeType(typeRef), this.session);
        Object superClass = firBasedSymbol == null ? null : firBasedSymbol.getFir();
        firBasedSymbol = superClass;
        if (firBasedSymbol != null) {
            FirPhaseManagerKt.ensureResolved(firBasedSymbol, FirResolvePhase.SUPER_TYPES);
        }
        firBasedSymbol = superClass;
        if (firBasedSymbol instanceof FirRegularClass) {
            this.forceResolveStatusesOfClass(superClass);
        } else if (firBasedSymbol instanceof FirTypeAlias) {
            this.forceResolveStatusOfCorrespondingClass(((FirTypeAlias)superClass).getExpandedTypeRef());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void forceResolveStatusesOfClass(FirRegularClass regularClass) {
        List designation2;
        List list2;
        Object object;
        Object object2;
        if (Intrinsics.areEqual(regularClass.getOrigin(), FirDeclarationOrigin.Java.INSTANCE)) {
            this.forceResolveStatusesOfSupertypes(regularClass);
            return;
        }
        if (!Intrinsics.areEqual(regularClass.getOrigin(), FirDeclarationOrigin.Source.INSTANCE)) {
            return;
        }
        StatusComputationSession.StatusComputationStatus statusComputationStatus = this.statusComputationSession.get(regularClass);
        if (!statusComputationStatus.getRequiresComputation()) {
            return;
        }
        if (regularClass.getStatus() instanceof FirResolvedDeclarationStatus && statusComputationStatus == StatusComputationSession.StatusComputationStatus.Computed) {
            this.statusComputationSession.endComputing(regularClass);
            return;
        }
        FirRegularClassSymbol symbol2 = regularClass.getSymbol();
        List<FirClassLikeDeclaration> $this$isLocal$iv = regularClass;
        boolean $i$f$isLocal = false;
        if (((FirClassLikeDeclaration)((Object)$this$isLocal$iv)).getSymbol().getClassId().isLocal()) {
            List<FirClassLikeDeclaration> $this$forceResolveStatusesOfClass_u24lambda_u2d6 = $this$isLocal$iv = CollectionsKt.createListBuilder();
            boolean bl = false;
            FirClassLikeDeclaration klass = regularClass;
            while (true) {
                Object object3;
                Object object4;
                $this$forceResolveStatusesOfClass_u24lambda_u2d6.add(klass);
                object2 = this.getDesignationMapForLocalClasses().get(klass);
                if (object2 == null) {
                    object4 = null;
                } else {
                    Object it = object = object2;
                    boolean bl2 = false;
                    object4 = object3 = !(it instanceof FirAnonymousObject) ? object : null;
                }
                if (object3 == null) break;
                klass = object3;
            }
            CollectionsKt.reverse($this$forceResolveStatusesOfClass_u24lambda_u2d6);
            list2 = CollectionsKt.build($this$isLocal$iv);
        } else {
            void destination$iv;
            void $this$mapTo$iv;
            List<FirClassLikeDeclaration> $this$forceResolveStatusesOfClass_u24lambda_u2d9 = $this$isLocal$iv = CollectionsKt.createListBuilder();
            boolean bl = false;
            FirProvider firProvider = MainSessionComponentsKt.getFirProvider(regularClass.getModuleData().getSession());
            object2 = SequencesKt.generateSequence(symbol2.getClassId(), (Function1)forceResolveStatusesOfClass.designation.2.outerClasses.1.INSTANCE);
            object = new ArrayList();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                ClassId classId = (ClassId)item$iv;
                void var15_19 = destination$iv;
                boolean bl3 = false;
                FirClassLikeDeclaration firClassLikeDeclaration = firProvider.getFirClassifierByFqName((ClassId)it);
                var15_19.add(firClassLikeDeclaration);
            }
            List outerClasses2 = (List)destination$iv;
            FirFile file2 = firProvider.getFirClassifierContainerFileIfAny(regularClass.getSymbol());
            if (file2 == null) {
                boolean bl4 = false;
                String string2 = Intrinsics.stringPlus("Containing file was not found for\n", FirRendererKt.render$default(regularClass, null, 1, null));
                throw new IllegalArgumentException(string2.toString());
            }
            CollectionsKt.addAll((Collection)$this$forceResolveStatusesOfClass_u24lambda_u2d9, CollectionsKt.asReversed(CollectionsKt.filterNotNull(outerClasses2)));
            list2 = designation2 = CollectionsKt.build($this$isLocal$iv);
        }
        if (designation2.isEmpty()) {
            return;
        }
        FirDesignatedStatusResolveTransformer transformer2 = new FirDesignatedStatusResolveTransformer(this.session, this.scopeSession, designation2.iterator(), regularClass, this.statusComputationSession, this.designationMapForLocalClasses, this.scopeForLocalClass);
        FirTransformerUtilKt.transformSingle((FirElement)CollectionsKt.first(designation2), transformer2, null);
        this.statusComputationSession.endComputing(regularClass);
    }

    private final void transformPropertyAccessor(FirPropertyAccessor propertyAccessor, FirProperty containingProperty) {
        propertyAccessor.transformStatus(this, this.statusResolver.resolveStatus(propertyAccessor, this.getContainingClass(), containingProperty, false));
        propertyAccessor.transformValueParameters(this, null);
    }

    @Override
    @NotNull
    public FirStatement transformConstructor(@NotNull FirConstructor constructor2, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter(constructor2, "constructor");
        constructor2.transformStatus(this, this.statusResolver.resolveStatus(constructor2, this.getContainingClass(), false));
        this.calculateDeprecations(constructor2);
        return (FirStatement)((Object)this.transformDeclaration((FirDeclaration)constructor2, data2));
    }

    @Override
    @NotNull
    public FirStatement transformSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
        FirResolvedDeclarationStatus resolvedStatus = this.statusResolver.resolveStatus(simpleFunction, this.getContainingClass(), false);
        simpleFunction.transformStatus(this, resolvedStatus);
        this.calculateDeprecations(simpleFunction);
        return (FirStatement)((Object)this.transformDeclaration((FirDeclaration)simpleFunction, data2));
    }

    @Override
    @NotNull
    public FirStatement transformProperty(@NotNull FirProperty property2, @Nullable FirResolvedDeclarationStatus data2) {
        FirPropertyAccessor it;
        FirPropertyAccessor firPropertyAccessor;
        Intrinsics.checkNotNullParameter(property2, "property");
        property2.transformStatus(this, this.statusResolver.resolveStatus(property2, this.getContainingClass(), false));
        FirPropertyAccessor firPropertyAccessor2 = property2.getGetter();
        if (firPropertyAccessor2 != null) {
            it = firPropertyAccessor = firPropertyAccessor2;
            boolean bl = false;
            this.transformPropertyAccessor(it, property2);
        }
        firPropertyAccessor2 = property2.getSetter();
        if (firPropertyAccessor2 != null) {
            it = firPropertyAccessor = firPropertyAccessor2;
            boolean bl = false;
            this.transformPropertyAccessor(it, property2);
        }
        this.calculateDeprecations(property2);
        return property2;
    }

    @Override
    @NotNull
    public FirStatement transformField(@NotNull FirField field2, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter(field2, "field");
        field2.transformStatus(this, this.statusResolver.resolveStatus(field2, this.getContainingClass(), false));
        this.calculateDeprecations(field2);
        return (FirField)this.transformDeclaration((FirDeclaration)field2, data2);
    }

    @Override
    @NotNull
    public FirStatement transformEnumEntry(@NotNull FirEnumEntry enumEntry, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter(enumEntry, "enumEntry");
        enumEntry.transformStatus(this, this.statusResolver.resolveStatus(enumEntry, this.getContainingClass(), false));
        this.calculateDeprecations(enumEntry);
        return (FirEnumEntry)this.transformDeclaration((FirDeclaration)enumEntry, data2);
    }

    @Override
    @NotNull
    public FirStatement transformValueParameter(@NotNull FirValueParameter valueParameter2, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter(valueParameter2, "valueParameter");
        this.calculateDeprecations(valueParameter2);
        return (FirStatement)((Object)this.transformDeclaration((FirDeclaration)valueParameter2, data2));
    }

    @Override
    @NotNull
    public FirTypeParameterRef transformTypeParameter(@NotNull FirTypeParameter typeParameter, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter(typeParameter, "typeParameter");
        return (FirTypeParameter)this.transformDeclaration((FirDeclaration)typeParameter, data2);
    }

    @Override
    @NotNull
    public FirStatement transformBlock(@NotNull FirBlock block, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter(block, "block");
        return block;
    }

    protected final void calculateDeprecations(@NotNull FirClassLikeDeclaration regularClass) {
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        if (regularClass.getDeprecation() == null) {
            regularClass.replaceDeprecation(DeprecationUtilsKt.getDeprecationInfos(regularClass, FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.session).getApiVersion()));
        }
    }

    protected final void calculateDeprecations(@NotNull FirCallableDeclaration simpleFunction) {
        Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
        if (simpleFunction.getDeprecation() == null) {
            simpleFunction.replaceDeprecation(DeprecationUtilsKt.getDeprecationInfos(simpleFunction, FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.session).getApiVersion()));
        }
    }
}

