/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.InlineClassesUtils;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.utils.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/JsInlineClassesUtils;", "Lorg/jetbrains/kotlin/ir/backend/js/InlineClassesUtils;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "boxIntrinsic", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getBoxIntrinsic", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "unboxIntrinsic", "getUnboxIntrinsic", "getInlinedClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isClassInlineLike", "", "klass", "isTypeInlined", "backend.js"})
public final class JsInlineClassesUtils
implements InlineClassesUtils {
    @NotNull
    private final JsIrBackendContext context;

    public JsInlineClassesUtils(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    @Override
    public boolean isTypeInlined(@NotNull IrType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return this.getInlinedClass(type2) != null;
    }

    @Override
    @Nullable
    public IrClass getInlinedClass(@NotNull IrType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return IrTypeUtilsKt.getJsInlinedClass(type2);
    }

    @Override
    public boolean isClassInlineLike(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        return klass.isInline();
    }

    @Override
    @NotNull
    public IrSimpleFunctionSymbol getBoxIntrinsic() {
        return this.context.getIntrinsics().getJsBoxIntrinsic();
    }

    @Override
    @NotNull
    public IrSimpleFunctionSymbol getUnboxIntrinsic() {
        return this.context.getIntrinsics().getJsUnboxIntrinsic();
    }

    @Override
    public boolean shouldValueParameterBeBoxed(@NotNull IrValueParameter parameter) {
        return InlineClassesUtils.DefaultImpls.shouldValueParameterBeBoxed(this, parameter);
    }
}

