/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.http.impl.cookie;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.kotlin.org.apache.http.conn.util.PublicSuffixMatcher;
import org.jetbrains.kotlin.org.apache.http.cookie.CommonCookieAttributeHandler;
import org.jetbrains.kotlin.org.apache.http.cookie.Cookie;
import org.jetbrains.kotlin.org.apache.http.cookie.CookieOrigin;
import org.jetbrains.kotlin.org.apache.http.cookie.MalformedCookieException;
import org.jetbrains.kotlin.org.apache.http.cookie.SetCookie;
import org.jetbrains.kotlin.org.apache.http.util.Args;

public class PublicSuffixDomainFilter
implements CommonCookieAttributeHandler {
    private final CommonCookieAttributeHandler handler;
    private final PublicSuffixMatcher publicSuffixMatcher;
    private final Map<String, Boolean> localDomainMap;

    private static Map<String, Boolean> createLocalDomainMap() {
        ConcurrentHashMap<String, Boolean> map2 = new ConcurrentHashMap<String, Boolean>();
        map2.put(".localhost.", Boolean.TRUE);
        map2.put(".test.", Boolean.TRUE);
        map2.put(".local.", Boolean.TRUE);
        map2.put(".local", Boolean.TRUE);
        map2.put(".localdomain", Boolean.TRUE);
        return map2;
    }

    public PublicSuffixDomainFilter(CommonCookieAttributeHandler handler2, PublicSuffixMatcher publicSuffixMatcher) {
        this.handler = Args.notNull(handler2, "Cookie handler");
        this.publicSuffixMatcher = Args.notNull(publicSuffixMatcher, "Public suffix matcher");
        this.localDomainMap = PublicSuffixDomainFilter.createLocalDomainMap();
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        String domain;
        String host = cookie.getDomain();
        if (host == null) {
            return false;
        }
        int i = host.indexOf(46);
        if (i >= 0 ? !this.localDomainMap.containsKey(domain = host.substring(i)) && this.publicSuffixMatcher.matches(host) : !host.equalsIgnoreCase(origin.getHost()) && this.publicSuffixMatcher.matches(host)) {
            return false;
        }
        return this.handler.match(cookie, origin);
    }

    @Override
    public void parse(SetCookie cookie, String value2) throws MalformedCookieException {
        this.handler.parse(cookie, value2);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        this.handler.validate(cookie, origin);
    }

    @Override
    public String getAttributeName() {
        return this.handler.getAttributeName();
    }

    public static CommonCookieAttributeHandler decorate(CommonCookieAttributeHandler handler2, PublicSuffixMatcher publicSuffixMatcher) {
        Args.notNull(handler2, "Cookie attribute handler");
        return publicSuffixMatcher != null ? new PublicSuffixDomainFilter(handler2, publicSuffixMatcher) : handler2;
    }
}

