/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.http.impl.cookie;

import org.jetbrains.kotlin.org.apache.http.conn.util.PublicSuffixMatcher;
import org.jetbrains.kotlin.org.apache.http.cookie.Cookie;
import org.jetbrains.kotlin.org.apache.http.cookie.CookieOrigin;
import org.jetbrains.kotlin.org.apache.http.cookie.CookieSpec;
import org.jetbrains.kotlin.org.apache.http.cookie.CookieSpecProvider;
import org.jetbrains.kotlin.org.apache.http.cookie.MalformedCookieException;
import org.jetbrains.kotlin.org.apache.http.impl.cookie.BasicDomainHandler;
import org.jetbrains.kotlin.org.apache.http.impl.cookie.BasicExpiresHandler;
import org.jetbrains.kotlin.org.apache.http.impl.cookie.BasicMaxAgeHandler;
import org.jetbrains.kotlin.org.apache.http.impl.cookie.BasicPathHandler;
import org.jetbrains.kotlin.org.apache.http.impl.cookie.BasicSecureHandler;
import org.jetbrains.kotlin.org.apache.http.impl.cookie.LaxExpiresHandler;
import org.jetbrains.kotlin.org.apache.http.impl.cookie.LaxMaxAgeHandler;
import org.jetbrains.kotlin.org.apache.http.impl.cookie.PublicSuffixDomainFilter;
import org.jetbrains.kotlin.org.apache.http.impl.cookie.RFC6265LaxSpec;
import org.jetbrains.kotlin.org.apache.http.impl.cookie.RFC6265StrictSpec;
import org.jetbrains.kotlin.org.apache.http.protocol.HttpContext;

public class RFC6265CookieSpecProvider
implements CookieSpecProvider {
    private final CompatibilityLevel compatibilityLevel;
    private final PublicSuffixMatcher publicSuffixMatcher;
    private volatile CookieSpec cookieSpec;

    public RFC6265CookieSpecProvider(CompatibilityLevel compatibilityLevel, PublicSuffixMatcher publicSuffixMatcher) {
        this.compatibilityLevel = compatibilityLevel != null ? compatibilityLevel : CompatibilityLevel.RELAXED;
        this.publicSuffixMatcher = publicSuffixMatcher;
    }

    public RFC6265CookieSpecProvider() {
        this(CompatibilityLevel.RELAXED, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CookieSpec create(HttpContext context2) {
        if (this.cookieSpec == null) {
            RFC6265CookieSpecProvider rFC6265CookieSpecProvider = this;
            synchronized (rFC6265CookieSpecProvider) {
                if (this.cookieSpec == null) {
                    switch (this.compatibilityLevel) {
                        case STRICT: {
                            this.cookieSpec = new RFC6265StrictSpec(new BasicPathHandler(), PublicSuffixDomainFilter.decorate(new BasicDomainHandler(), this.publicSuffixMatcher), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicExpiresHandler(RFC6265StrictSpec.DATE_PATTERNS));
                            break;
                        }
                        case IE_MEDIUM_SECURITY: {
                            this.cookieSpec = new RFC6265LaxSpec(new BasicPathHandler(){

                                @Override
                                public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
                                }
                            }, PublicSuffixDomainFilter.decorate(new BasicDomainHandler(), this.publicSuffixMatcher), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicExpiresHandler(RFC6265StrictSpec.DATE_PATTERNS));
                            break;
                        }
                        default: {
                            this.cookieSpec = new RFC6265LaxSpec(new BasicPathHandler(), PublicSuffixDomainFilter.decorate(new BasicDomainHandler(), this.publicSuffixMatcher), new LaxMaxAgeHandler(), new BasicSecureHandler(), new LaxExpiresHandler());
                        }
                    }
                }
            }
        }
        return this.cookieSpec;
    }

    public static final class CompatibilityLevel
    extends Enum<CompatibilityLevel> {
        public static final /* enum */ CompatibilityLevel STRICT = new CompatibilityLevel();
        public static final /* enum */ CompatibilityLevel RELAXED = new CompatibilityLevel();
        public static final /* enum */ CompatibilityLevel IE_MEDIUM_SECURITY = new CompatibilityLevel();
        private static final /* synthetic */ CompatibilityLevel[] $VALUES;

        public static CompatibilityLevel[] values() {
            return (CompatibilityLevel[])$VALUES.clone();
        }

        static {
            $VALUES = new CompatibilityLevel[]{STRICT, RELAXED, IE_MEDIUM_SECURITY};
        }
    }
}

