/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.repository.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.kotlin.org.apache.maven.model.Parent;
import org.jetbrains.kotlin.org.apache.maven.model.Repository;
import org.jetbrains.kotlin.org.apache.maven.model.building.FileModelSource;
import org.jetbrains.kotlin.org.apache.maven.model.building.ModelSource;
import org.jetbrains.kotlin.org.apache.maven.model.resolution.InvalidRepositoryException;
import org.jetbrains.kotlin.org.apache.maven.model.resolution.ModelResolver;
import org.jetbrains.kotlin.org.apache.maven.model.resolution.UnresolvableModelException;
import org.jetbrains.kotlin.org.apache.maven.repository.internal.ArtifactDescriptorUtils;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.RequestTrace;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.DefaultArtifact;
import org.jetbrains.kotlin.org.eclipse.aether.impl.ArtifactResolver;
import org.jetbrains.kotlin.org.eclipse.aether.impl.RemoteRepositoryManager;
import org.jetbrains.kotlin.org.eclipse.aether.impl.VersionRangeResolver;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactRequest;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactResolutionException;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.VersionRangeRequest;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.VersionRangeResult;

class DefaultModelResolver
implements ModelResolver {
    private final RepositorySystemSession session;
    private final RequestTrace trace;
    private final String context;
    private List<RemoteRepository> repositories;
    private final List<RemoteRepository> externalRepositories;
    private final ArtifactResolver resolver;
    private final VersionRangeResolver versionRangeResolver;
    private final RemoteRepositoryManager remoteRepositoryManager;
    private final Set<String> repositoryIds;

    DefaultModelResolver(RepositorySystemSession session2, RequestTrace trace, String context2, ArtifactResolver resolver, VersionRangeResolver versionRangeResolver, RemoteRepositoryManager remoteRepositoryManager, List<RemoteRepository> repositories) {
        this.session = session2;
        this.trace = trace;
        this.context = context2;
        this.resolver = resolver;
        this.versionRangeResolver = versionRangeResolver;
        this.remoteRepositoryManager = remoteRepositoryManager;
        this.repositories = repositories;
        this.externalRepositories = Collections.unmodifiableList(new ArrayList<RemoteRepository>(repositories));
        this.repositoryIds = new HashSet<String>();
    }

    private DefaultModelResolver(DefaultModelResolver original) {
        this.session = original.session;
        this.trace = original.trace;
        this.context = original.context;
        this.resolver = original.resolver;
        this.versionRangeResolver = original.versionRangeResolver;
        this.remoteRepositoryManager = original.remoteRepositoryManager;
        this.repositories = new ArrayList<RemoteRepository>(original.repositories);
        this.externalRepositories = original.externalRepositories;
        this.repositoryIds = new HashSet<String>(original.repositoryIds);
    }

    @Override
    public void addRepository(Repository repository, boolean replace2) throws InvalidRepositoryException {
        if (this.session.isIgnoreArtifactDescriptorRepositories()) {
            return;
        }
        if (!this.repositoryIds.add(repository.getId())) {
            if (!replace2) {
                return;
            }
            DefaultModelResolver.removeMatchingRepository(this.repositories, repository.getId());
        }
        List<RemoteRepository> newRepositories = Collections.singletonList(ArtifactDescriptorUtils.toRemoteRepository(repository));
        this.repositories = this.remoteRepositoryManager.aggregateRepositories(this.session, this.repositories, newRepositories, true);
    }

    private static void removeMatchingRepository(Iterable<RemoteRepository> repositories, String id) {
        Iterator<RemoteRepository> iterator2 = repositories.iterator();
        while (iterator2.hasNext()) {
            RemoteRepository remoteRepository = iterator2.next();
            if (!remoteRepository.getId().equals(id)) continue;
            iterator2.remove();
        }
    }

    @Override
    public ModelResolver newCopy() {
        return new DefaultModelResolver(this);
    }

    @Override
    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        Artifact pomArtifact = new DefaultArtifact(groupId, artifactId, "", "pom", version);
        try {
            ArtifactRequest request = new ArtifactRequest(pomArtifact, this.repositories, this.context);
            request.setTrace(this.trace);
            pomArtifact = this.resolver.resolveArtifact(this.session, request).getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new UnresolvableModelException(e.getMessage(), groupId, artifactId, version, e);
        }
        File pomFile = pomArtifact.getFile();
        return new FileModelSource(pomFile);
    }

    @Override
    public ModelSource resolveModel(Parent parent2) throws UnresolvableModelException {
        try {
            DefaultArtifact artifact = new DefaultArtifact(parent2.getGroupId(), parent2.getArtifactId(), "", "pom", parent2.getVersion());
            VersionRangeRequest versionRangeRequest = new VersionRangeRequest(artifact, this.repositories, this.context);
            versionRangeRequest.setTrace(this.trace);
            VersionRangeResult versionRangeResult = this.versionRangeResolver.resolveVersionRange(this.session, versionRangeRequest);
            if (versionRangeResult.getHighestVersion() == null) {
                throw new UnresolvableModelException(String.format("No versions matched the requested parent version range '%s'", parent2.getVersion()), parent2.getGroupId(), parent2.getArtifactId(), parent2.getVersion());
            }
            if (versionRangeResult.getVersionConstraint() != null && versionRangeResult.getVersionConstraint().getRange() != null && versionRangeResult.getVersionConstraint().getRange().getUpperBound() == null) {
                throw new UnresolvableModelException(String.format("The requested parent version range '%s' does not specify an upper bound", parent2.getVersion()), parent2.getGroupId(), parent2.getArtifactId(), parent2.getVersion());
            }
            parent2.setVersion(versionRangeResult.getHighestVersion().toString());
            return this.resolveModel(parent2.getGroupId(), parent2.getArtifactId(), parent2.getVersion());
        }
        catch (VersionRangeResolutionException e) {
            throw new UnresolvableModelException(e.getMessage(), parent2.getGroupId(), parent2.getArtifactId(), parent2.getVersion(), e);
        }
    }
}

