/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.settings.io.xpp3;

import java.io.IOException;
import java.io.Writer;
import org.jetbrains.kotlin.org.apache.maven.settings.Activation;
import org.jetbrains.kotlin.org.apache.maven.settings.ActivationFile;
import org.jetbrains.kotlin.org.apache.maven.settings.ActivationOS;
import org.jetbrains.kotlin.org.apache.maven.settings.ActivationProperty;
import org.jetbrains.kotlin.org.apache.maven.settings.Mirror;
import org.jetbrains.kotlin.org.apache.maven.settings.Profile;
import org.jetbrains.kotlin.org.apache.maven.settings.Proxy;
import org.jetbrains.kotlin.org.apache.maven.settings.Repository;
import org.jetbrains.kotlin.org.apache.maven.settings.RepositoryPolicy;
import org.jetbrains.kotlin.org.apache.maven.settings.Server;
import org.jetbrains.kotlin.org.apache.maven.settings.Settings;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class SettingsXpp3Writer {
    private static final String NAMESPACE = null;
    private String fileComment = null;

    public void write(Writer writer, Settings settings2) throws IOException {
        MXSerializer serializer2 = new MXSerializer();
        serializer2.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  ");
        serializer2.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n");
        serializer2.setOutput(writer);
        serializer2.startDocument(settings2.getModelEncoding(), null);
        this.writeSettings(settings2, "settings", serializer2);
        serializer2.endDocument();
    }

    private void writeActivation(Activation activation, String tagName, XmlSerializer serializer2) throws IOException {
        serializer2.startTag(NAMESPACE, tagName);
        if (activation.isActiveByDefault()) {
            serializer2.startTag(NAMESPACE, "activeByDefault").text(String.valueOf(activation.isActiveByDefault())).endTag(NAMESPACE, "activeByDefault");
        }
        if (activation.getJdk() != null) {
            serializer2.startTag(NAMESPACE, "jdk").text(activation.getJdk()).endTag(NAMESPACE, "jdk");
        }
        if (activation.getOs() != null) {
            this.writeActivationOS(activation.getOs(), "os", serializer2);
        }
        if (activation.getProperty() != null) {
            this.writeActivationProperty(activation.getProperty(), "property", serializer2);
        }
        if (activation.getFile() != null) {
            this.writeActivationFile(activation.getFile(), "file", serializer2);
        }
        serializer2.endTag(NAMESPACE, tagName);
    }

    private void writeActivationFile(ActivationFile activationFile, String tagName, XmlSerializer serializer2) throws IOException {
        serializer2.startTag(NAMESPACE, tagName);
        if (activationFile.getMissing() != null) {
            serializer2.startTag(NAMESPACE, "missing").text(activationFile.getMissing()).endTag(NAMESPACE, "missing");
        }
        if (activationFile.getExists() != null) {
            serializer2.startTag(NAMESPACE, "exists").text(activationFile.getExists()).endTag(NAMESPACE, "exists");
        }
        serializer2.endTag(NAMESPACE, tagName);
    }

    private void writeActivationOS(ActivationOS activationOS, String tagName, XmlSerializer serializer2) throws IOException {
        serializer2.startTag(NAMESPACE, tagName);
        if (activationOS.getName() != null) {
            serializer2.startTag(NAMESPACE, "name").text(activationOS.getName()).endTag(NAMESPACE, "name");
        }
        if (activationOS.getFamily() != null) {
            serializer2.startTag(NAMESPACE, "family").text(activationOS.getFamily()).endTag(NAMESPACE, "family");
        }
        if (activationOS.getArch() != null) {
            serializer2.startTag(NAMESPACE, "arch").text(activationOS.getArch()).endTag(NAMESPACE, "arch");
        }
        if (activationOS.getVersion() != null) {
            serializer2.startTag(NAMESPACE, "version").text(activationOS.getVersion()).endTag(NAMESPACE, "version");
        }
        serializer2.endTag(NAMESPACE, tagName);
    }

    private void writeActivationProperty(ActivationProperty activationProperty, String tagName, XmlSerializer serializer2) throws IOException {
        serializer2.startTag(NAMESPACE, tagName);
        if (activationProperty.getName() != null) {
            serializer2.startTag(NAMESPACE, "name").text(activationProperty.getName()).endTag(NAMESPACE, "name");
        }
        if (activationProperty.getValue() != null) {
            serializer2.startTag(NAMESPACE, "value").text(activationProperty.getValue()).endTag(NAMESPACE, "value");
        }
        serializer2.endTag(NAMESPACE, tagName);
    }

    private void writeMirror(Mirror mirror, String tagName, XmlSerializer serializer2) throws IOException {
        serializer2.startTag(NAMESPACE, tagName);
        if (mirror.getMirrorOf() != null) {
            serializer2.startTag(NAMESPACE, "mirrorOf").text(mirror.getMirrorOf()).endTag(NAMESPACE, "mirrorOf");
        }
        if (mirror.getName() != null) {
            serializer2.startTag(NAMESPACE, "name").text(mirror.getName()).endTag(NAMESPACE, "name");
        }
        if (mirror.getUrl() != null) {
            serializer2.startTag(NAMESPACE, "url").text(mirror.getUrl()).endTag(NAMESPACE, "url");
        }
        if (mirror.getLayout() != null && !mirror.getLayout().equals("default")) {
            serializer2.startTag(NAMESPACE, "layout").text(mirror.getLayout()).endTag(NAMESPACE, "layout");
        }
        if (mirror.getMirrorOfLayouts() != null && !mirror.getMirrorOfLayouts().equals("default,legacy")) {
            serializer2.startTag(NAMESPACE, "mirrorOfLayouts").text(mirror.getMirrorOfLayouts()).endTag(NAMESPACE, "mirrorOfLayouts");
        }
        if (mirror.isBlocked()) {
            serializer2.startTag(NAMESPACE, "blocked").text(String.valueOf(mirror.isBlocked())).endTag(NAMESPACE, "blocked");
        }
        if (mirror.getId() != null && !mirror.getId().equals("default")) {
            serializer2.startTag(NAMESPACE, "id").text(mirror.getId()).endTag(NAMESPACE, "id");
        }
        serializer2.endTag(NAMESPACE, tagName);
    }

    private void writeProfile(Profile profile, String tagName, XmlSerializer serializer2) throws IOException {
        serializer2.startTag(NAMESPACE, tagName);
        if (profile.getActivation() != null) {
            this.writeActivation(profile.getActivation(), "activation", serializer2);
        }
        if (profile.getProperties() != null && profile.getProperties().size() > 0) {
            serializer2.startTag(NAMESPACE, "properties");
            for (String string2 : profile.getProperties().keySet()) {
                String value2 = (String)profile.getProperties().get(string2);
                serializer2.startTag(NAMESPACE, string2).text(value2).endTag(NAMESPACE, string2);
            }
            serializer2.endTag(NAMESPACE, "properties");
        }
        if (profile.getRepositories() != null && profile.getRepositories().size() > 0) {
            serializer2.startTag(NAMESPACE, "repositories");
            for (Repository repository : profile.getRepositories()) {
                this.writeRepository(repository, "repository", serializer2);
            }
            serializer2.endTag(NAMESPACE, "repositories");
        }
        if (profile.getPluginRepositories() != null && profile.getPluginRepositories().size() > 0) {
            serializer2.startTag(NAMESPACE, "pluginRepositories");
            for (Repository repository : profile.getPluginRepositories()) {
                this.writeRepository(repository, "pluginRepository", serializer2);
            }
            serializer2.endTag(NAMESPACE, "pluginRepositories");
        }
        if (profile.getId() != null && !profile.getId().equals("default")) {
            serializer2.startTag(NAMESPACE, "id").text(profile.getId()).endTag(NAMESPACE, "id");
        }
        serializer2.endTag(NAMESPACE, tagName);
    }

    private void writeProxy(Proxy proxy, String tagName, XmlSerializer serializer2) throws IOException {
        serializer2.startTag(NAMESPACE, tagName);
        if (!proxy.isActive()) {
            serializer2.startTag(NAMESPACE, "active").text(String.valueOf(proxy.isActive())).endTag(NAMESPACE, "active");
        }
        if (proxy.getProtocol() != null && !proxy.getProtocol().equals("http")) {
            serializer2.startTag(NAMESPACE, "protocol").text(proxy.getProtocol()).endTag(NAMESPACE, "protocol");
        }
        if (proxy.getUsername() != null) {
            serializer2.startTag(NAMESPACE, "username").text(proxy.getUsername()).endTag(NAMESPACE, "username");
        }
        if (proxy.getPassword() != null) {
            serializer2.startTag(NAMESPACE, "password").text(proxy.getPassword()).endTag(NAMESPACE, "password");
        }
        if (proxy.getPort() != 8080) {
            serializer2.startTag(NAMESPACE, "port").text(String.valueOf(proxy.getPort())).endTag(NAMESPACE, "port");
        }
        if (proxy.getHost() != null) {
            serializer2.startTag(NAMESPACE, "host").text(proxy.getHost()).endTag(NAMESPACE, "host");
        }
        if (proxy.getNonProxyHosts() != null) {
            serializer2.startTag(NAMESPACE, "nonProxyHosts").text(proxy.getNonProxyHosts()).endTag(NAMESPACE, "nonProxyHosts");
        }
        if (proxy.getId() != null && !proxy.getId().equals("default")) {
            serializer2.startTag(NAMESPACE, "id").text(proxy.getId()).endTag(NAMESPACE, "id");
        }
        serializer2.endTag(NAMESPACE, tagName);
    }

    private void writeRepository(Repository repository, String tagName, XmlSerializer serializer2) throws IOException {
        serializer2.startTag(NAMESPACE, tagName);
        if (repository.getReleases() != null) {
            this.writeRepositoryPolicy(repository.getReleases(), "releases", serializer2);
        }
        if (repository.getSnapshots() != null) {
            this.writeRepositoryPolicy(repository.getSnapshots(), "snapshots", serializer2);
        }
        if (repository.getId() != null) {
            serializer2.startTag(NAMESPACE, "id").text(repository.getId()).endTag(NAMESPACE, "id");
        }
        if (repository.getName() != null) {
            serializer2.startTag(NAMESPACE, "name").text(repository.getName()).endTag(NAMESPACE, "name");
        }
        if (repository.getUrl() != null) {
            serializer2.startTag(NAMESPACE, "url").text(repository.getUrl()).endTag(NAMESPACE, "url");
        }
        if (repository.getLayout() != null && !repository.getLayout().equals("default")) {
            serializer2.startTag(NAMESPACE, "layout").text(repository.getLayout()).endTag(NAMESPACE, "layout");
        }
        serializer2.endTag(NAMESPACE, tagName);
    }

    private void writeRepositoryPolicy(RepositoryPolicy repositoryPolicy, String tagName, XmlSerializer serializer2) throws IOException {
        serializer2.startTag(NAMESPACE, tagName);
        if (!repositoryPolicy.isEnabled()) {
            serializer2.startTag(NAMESPACE, "enabled").text(String.valueOf(repositoryPolicy.isEnabled())).endTag(NAMESPACE, "enabled");
        }
        if (repositoryPolicy.getUpdatePolicy() != null) {
            serializer2.startTag(NAMESPACE, "updatePolicy").text(repositoryPolicy.getUpdatePolicy()).endTag(NAMESPACE, "updatePolicy");
        }
        if (repositoryPolicy.getChecksumPolicy() != null) {
            serializer2.startTag(NAMESPACE, "checksumPolicy").text(repositoryPolicy.getChecksumPolicy()).endTag(NAMESPACE, "checksumPolicy");
        }
        serializer2.endTag(NAMESPACE, tagName);
    }

    private void writeServer(Server server, String tagName, XmlSerializer serializer2) throws IOException {
        serializer2.startTag(NAMESPACE, tagName);
        if (server.getUsername() != null) {
            serializer2.startTag(NAMESPACE, "username").text(server.getUsername()).endTag(NAMESPACE, "username");
        }
        if (server.getPassword() != null) {
            serializer2.startTag(NAMESPACE, "password").text(server.getPassword()).endTag(NAMESPACE, "password");
        }
        if (server.getPrivateKey() != null) {
            serializer2.startTag(NAMESPACE, "privateKey").text(server.getPrivateKey()).endTag(NAMESPACE, "privateKey");
        }
        if (server.getPassphrase() != null) {
            serializer2.startTag(NAMESPACE, "passphrase").text(server.getPassphrase()).endTag(NAMESPACE, "passphrase");
        }
        if (server.getFilePermissions() != null) {
            serializer2.startTag(NAMESPACE, "filePermissions").text(server.getFilePermissions()).endTag(NAMESPACE, "filePermissions");
        }
        if (server.getDirectoryPermissions() != null) {
            serializer2.startTag(NAMESPACE, "directoryPermissions").text(server.getDirectoryPermissions()).endTag(NAMESPACE, "directoryPermissions");
        }
        if (server.getConfiguration() != null) {
            ((Xpp3Dom)server.getConfiguration()).writeToSerializer(NAMESPACE, serializer2);
        }
        if (server.getId() != null && !server.getId().equals("default")) {
            serializer2.startTag(NAMESPACE, "id").text(server.getId()).endTag(NAMESPACE, "id");
        }
        serializer2.endTag(NAMESPACE, tagName);
    }

    private void writeSettings(Settings settings2, String tagName, XmlSerializer serializer2) throws IOException {
        if (this.fileComment != null) {
            serializer2.comment(this.fileComment);
        }
        serializer2.setPrefix("", "http://maven.apache.org/SETTINGS/1.2.0");
        serializer2.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        serializer2.startTag(NAMESPACE, tagName);
        serializer2.attribute("", "xsi:schemaLocation", "http://maven.apache.org/SETTINGS/1.2.0 http://maven.apache.org/xsd/settings-1.2.0.xsd");
        if (settings2.getLocalRepository() != null) {
            serializer2.startTag(NAMESPACE, "localRepository").text(settings2.getLocalRepository()).endTag(NAMESPACE, "localRepository");
        }
        if (!settings2.isInteractiveMode()) {
            serializer2.startTag(NAMESPACE, "interactiveMode").text(String.valueOf(settings2.isInteractiveMode())).endTag(NAMESPACE, "interactiveMode");
        }
        if (settings2.isUsePluginRegistry()) {
            serializer2.startTag(NAMESPACE, "usePluginRegistry").text(String.valueOf(settings2.isUsePluginRegistry())).endTag(NAMESPACE, "usePluginRegistry");
        }
        if (settings2.isOffline()) {
            serializer2.startTag(NAMESPACE, "offline").text(String.valueOf(settings2.isOffline())).endTag(NAMESPACE, "offline");
        }
        if (settings2.getProxies() != null && settings2.getProxies().size() > 0) {
            serializer2.startTag(NAMESPACE, "proxies");
            for (Proxy proxy : settings2.getProxies()) {
                this.writeProxy(proxy, "proxy", serializer2);
            }
            serializer2.endTag(NAMESPACE, "proxies");
        }
        if (settings2.getServers() != null && settings2.getServers().size() > 0) {
            serializer2.startTag(NAMESPACE, "servers");
            for (Server server : settings2.getServers()) {
                this.writeServer(server, "server", serializer2);
            }
            serializer2.endTag(NAMESPACE, "servers");
        }
        if (settings2.getMirrors() != null && settings2.getMirrors().size() > 0) {
            serializer2.startTag(NAMESPACE, "mirrors");
            for (Mirror mirror : settings2.getMirrors()) {
                this.writeMirror(mirror, "mirror", serializer2);
            }
            serializer2.endTag(NAMESPACE, "mirrors");
        }
        if (settings2.getProfiles() != null && settings2.getProfiles().size() > 0) {
            serializer2.startTag(NAMESPACE, "profiles");
            for (Profile profile : settings2.getProfiles()) {
                this.writeProfile(profile, "profile", serializer2);
            }
            serializer2.endTag(NAMESPACE, "profiles");
        }
        if (settings2.getActiveProfiles() != null && settings2.getActiveProfiles().size() > 0) {
            serializer2.startTag(NAMESPACE, "activeProfiles");
            for (String string2 : settings2.getActiveProfiles()) {
                serializer2.startTag(NAMESPACE, "activeProfile").text(string2).endTag(NAMESPACE, "activeProfile");
            }
            serializer2.endTag(NAMESPACE, "activeProfiles");
        }
        if (settings2.getPluginGroups() != null && settings2.getPluginGroups().size() > 0) {
            serializer2.startTag(NAMESPACE, "pluginGroups");
            for (String string3 : settings2.getPluginGroups()) {
                serializer2.startTag(NAMESPACE, "pluginGroup").text(string3).endTag(NAMESPACE, "pluginGroup");
            }
            serializer2.endTag(NAMESPACE, "pluginGroups");
        }
        serializer2.endTag(NAMESPACE, tagName);
    }
}

