/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.wagon.providers.http;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.kotlin.org.apache.http.HttpEntity;
import org.jetbrains.kotlin.org.apache.http.HttpException;
import org.jetbrains.kotlin.org.apache.http.client.methods.CloseableHttpResponse;
import org.jetbrains.kotlin.org.apache.http.client.methods.HttpGet;
import org.jetbrains.kotlin.org.apache.http.util.EntityUtils;
import org.jetbrains.kotlin.org.apache.maven.wagon.ResourceDoesNotExistException;
import org.jetbrains.kotlin.org.apache.maven.wagon.TransferFailedException;
import org.jetbrains.kotlin.org.apache.maven.wagon.authorization.AuthorizationException;
import org.jetbrains.kotlin.org.apache.maven.wagon.shared.http.AbstractHttpClientWagon;
import org.jetbrains.kotlin.org.apache.maven.wagon.shared.http.HtmlFileListParser;
import org.jetbrains.kotlin.org.apache.maven.wagon.shared.http.HttpMessageUtils;

public class HttpWagon
extends AbstractHttpClientWagon {
    @Override
    public List<String> getFileList(String destinationDirectory) throws AuthorizationException, ResourceDoesNotExistException, TransferFailedException {
        return this.getFileList(this.getInitialBackoffSeconds(), destinationDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getFileList(int wait, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (destinationDirectory.length() > 0 && !destinationDirectory.endsWith("/")) {
            destinationDirectory = destinationDirectory + "/";
        }
        String url = this.getRepository().getUrl() + "/" + destinationDirectory;
        HttpGet getMethod = new HttpGet(url);
        try {
            CloseableHttpResponse response = this.execute(getMethod);
            try {
                String reasonPhrase = response.getStatusLine().getReasonPhrase();
                int statusCode = response.getStatusLine().getStatusCode();
                this.fireTransferDebug(HttpMessageUtils.formatTransferDebugMessage(url, statusCode, reasonPhrase, this.getProxyInfo()));
                switch (statusCode) {
                    case 200: {
                        break;
                    }
                    case 401: 
                    case 403: 
                    case 407: {
                        EntityUtils.consumeQuietly(response.getEntity());
                        throw new AuthorizationException(HttpMessageUtils.formatAuthorizationMessage(url, statusCode, reasonPhrase, this.getProxyInfo()));
                    }
                    case 404: 
                    case 410: {
                        EntityUtils.consumeQuietly(response.getEntity());
                        throw new ResourceDoesNotExistException(HttpMessageUtils.formatResourceDoesNotExistMessage(url, statusCode, reasonPhrase, this.getProxyInfo()));
                    }
                    case 429: {
                        EntityUtils.consumeQuietly(response.getEntity());
                        List<String> list2 = this.getFileList(this.backoff(wait, url), destinationDirectory);
                        return list2;
                    }
                    default: {
                        EntityUtils.consumeQuietly(response.getEntity());
                        throw new TransferFailedException(HttpMessageUtils.formatTransferFailedMessage(url, statusCode, reasonPhrase, this.getProxyInfo()));
                    }
                }
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    List<String> list3 = HtmlFileListParser.parseFileList(url, entity.getContent());
                    return list3;
                }
                List<String> list4 = Collections.emptyList();
                return list4;
            }
            finally {
                response.close();
            }
        }
        catch (IOException e) {
            throw new TransferFailedException("Could not read response body.", e);
        }
        catch (HttpException e) {
            throw new TransferFailedException("Could not read response body.", e);
        }
        catch (InterruptedException e) {
            throw new TransferFailedException("Unable to wait for resource.", e);
        }
    }
}

