/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.composite;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.ParameterizedConfigurationConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.composite.AbstractCollectionConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.jetbrains.kotlin.org.codehaus.plexus.configuration.PlexusConfiguration;

public class CollectionConverter
extends AbstractCollectionConverter
implements ParameterizedConfigurationConverter {
    @Override
    public boolean canConvert(Class<?> type2) {
        return Collection.class.isAssignableFrom(type2) && !Map.class.isAssignableFrom(type2);
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup2, PlexusConfiguration configuration2, Class<?> type2, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        return this.fromConfiguration(lookup2, configuration2, type2, null, enclosingType, loader, evaluator, listener);
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup2, PlexusConfiguration configuration2, Class<?> type2, Type[] typeArguments2, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object value2 = this.fromExpression(configuration2, evaluator);
        if (type2.isInstance(value2)) {
            return value2;
        }
        try {
            Collection<Object> elements;
            Class<?> elementType = CollectionConverter.findElementType(typeArguments2);
            if (value2 == null) {
                elements = this.fromChildren(lookup2, configuration2, type2, enclosingType, loader, evaluator, listener, elementType);
            } else if (value2 instanceof String) {
                PlexusConfiguration xml = CollectionConverter.csvToXml(configuration2, (String)value2);
                elements = this.fromChildren(lookup2, xml, type2, enclosingType, loader, evaluator, listener, elementType);
            } else if (value2 instanceof Object[]) {
                elements = this.instantiateCollection(configuration2, type2, loader);
                Collections.addAll(elements, (Object[])value2);
            } else {
                this.failIfNotTypeCompatible(value2, type2, configuration2);
                elements = Collections.emptyList();
            }
            return elements;
        }
        catch (ComponentConfigurationException e) {
            if (e.getFailedConfiguration() == null) {
                e.setFailedConfiguration(configuration2);
            }
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw new ComponentConfigurationException(configuration2, "Cannot store value into collection", e);
        }
    }

    @Override
    protected final Collection<Object> instantiateCollection(PlexusConfiguration configuration2, Class<?> type2, ClassLoader loader) throws ComponentConfigurationException {
        Class<?> implType = this.getClassForImplementationHint(type2, configuration2, loader);
        if (implType == null || Modifier.isAbstract(implType.getModifiers())) {
            if (Set.class.isAssignableFrom(type2)) {
                if (SortedSet.class.isAssignableFrom(type2)) {
                    return new TreeSet<Object>();
                }
                return new HashSet<Object>();
            }
            return new ArrayList<Object>();
        }
        Object impl = this.instantiateObject(implType);
        this.failIfNotTypeCompatible(impl, type2, configuration2);
        return (Collection)impl;
    }

    private static Class<?> findElementType(Type[] typeArguments2) {
        if (typeArguments2 != null && typeArguments2.length > 0 && typeArguments2[0] instanceof Class) {
            return (Class)typeArguments2[0];
        }
        return Object.class;
    }
}

