/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.connector.basic;

import javax.inject.Named;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.connector.basic.BasicRepositoryConnector;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.RepositoryConnector;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.checksum.ChecksumPolicyProvider;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.layout.RepositoryLayoutProvider;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.transport.TransporterProvider;
import org.jetbrains.kotlin.org.eclipse.aether.spi.io.FileProcessor;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.Service;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.ServiceLocator;
import org.jetbrains.kotlin.org.eclipse.aether.spi.log.Logger;
import org.jetbrains.kotlin.org.eclipse.aether.spi.log.LoggerFactory;
import org.jetbrains.kotlin.org.eclipse.aether.spi.log.NullLoggerFactory;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.NoRepositoryConnectorException;

@Named(value="basic")
public final class BasicRepositoryConnectorFactory
implements RepositoryConnectorFactory,
Service {
    private Logger logger = NullLoggerFactory.LOGGER;
    private TransporterProvider transporterProvider;
    private RepositoryLayoutProvider layoutProvider;
    private ChecksumPolicyProvider checksumPolicyProvider;
    private FileProcessor fileProcessor;
    private float priority;

    @Override
    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
        this.setTransporterProvider(locator.getService(TransporterProvider.class));
        this.setRepositoryLayoutProvider(locator.getService(RepositoryLayoutProvider.class));
        this.setChecksumPolicyProvider(locator.getService(ChecksumPolicyProvider.class));
        this.setFileProcessor(locator.getService(FileProcessor.class));
    }

    public BasicRepositoryConnectorFactory setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, BasicRepositoryConnector.class);
        return this;
    }

    public BasicRepositoryConnectorFactory setTransporterProvider(TransporterProvider transporterProvider) {
        if (transporterProvider == null) {
            throw new IllegalArgumentException("transporter provider has not been specified");
        }
        this.transporterProvider = transporterProvider;
        return this;
    }

    public BasicRepositoryConnectorFactory setRepositoryLayoutProvider(RepositoryLayoutProvider layoutProvider) {
        if (layoutProvider == null) {
            throw new IllegalArgumentException("repository layout provider has not been specified");
        }
        this.layoutProvider = layoutProvider;
        return this;
    }

    public BasicRepositoryConnectorFactory setChecksumPolicyProvider(ChecksumPolicyProvider checksumPolicyProvider) {
        if (checksumPolicyProvider == null) {
            throw new IllegalArgumentException("checksum policy provider has not been specified");
        }
        this.checksumPolicyProvider = checksumPolicyProvider;
        return this;
    }

    public BasicRepositoryConnectorFactory setFileProcessor(FileProcessor fileProcessor) {
        if (fileProcessor == null) {
            throw new IllegalArgumentException("file processor has not been specified");
        }
        this.fileProcessor = fileProcessor;
        return this;
    }

    @Override
    public float getPriority() {
        return this.priority;
    }

    @Override
    public RepositoryConnector newInstance(RepositorySystemSession session2, RemoteRepository repository) throws NoRepositoryConnectorException {
        return new BasicRepositoryConnector(session2, repository, this.transporterProvider, this.layoutProvider, this.checksumPolicyProvider, this.fileProcessor, this.logger);
    }
}

