/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.inject.Named;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.impl.RepositoryConnectorProvider;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.PrioritizedComponent;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.PrioritizedComponents;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.Utils;
import org.jetbrains.kotlin.org.eclipse.aether.repository.Authentication;
import org.jetbrains.kotlin.org.eclipse.aether.repository.Proxy;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.RepositoryConnector;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.Service;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.ServiceLocator;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DefaultRepositoryConnectorProvider
implements RepositoryConnectorProvider,
Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRepositoryConnectorProvider.class);
    private Collection<RepositoryConnectorFactory> connectorFactories = new ArrayList<RepositoryConnectorFactory>();

    @Override
    public void initService(ServiceLocator locator) {
        this.connectorFactories = locator.getServices(RepositoryConnectorFactory.class);
    }

    @Override
    public RepositoryConnector newRepositoryConnector(RepositorySystemSession session2, RemoteRepository repository) throws NoRepositoryConnectorException {
        Objects.requireNonNull(repository, "remote repository cannot be null");
        PrioritizedComponents<RepositoryConnectorFactory> factories = new PrioritizedComponents<RepositoryConnectorFactory>(session2);
        for (RepositoryConnectorFactory repositoryConnectorFactory : this.connectorFactories) {
            factories.add(repositoryConnectorFactory, repositoryConnectorFactory.getPriority());
        }
        ArrayList<NoRepositoryConnectorException> errors = new ArrayList<NoRepositoryConnectorException>();
        for (PrioritizedComponent prioritizedComponent : factories.getEnabled()) {
            try {
                RepositoryConnector connector = ((RepositoryConnectorFactory)prioritizedComponent.getComponent()).newInstance(session2, repository);
                if (LOGGER.isDebugEnabled()) {
                    Proxy proxy;
                    StringBuilder buffer = new StringBuilder(256);
                    buffer.append("Using connector ").append(connector.getClass().getSimpleName());
                    Utils.appendClassLoader(buffer, connector);
                    buffer.append(" with priority ").append(prioritizedComponent.getPriority());
                    buffer.append(" for ").append(repository.getUrl());
                    Authentication auth = repository.getAuthentication();
                    if (auth != null) {
                        buffer.append(" with ").append(auth);
                    }
                    if ((proxy = repository.getProxy()) != null) {
                        buffer.append(" via ").append(proxy.getHost()).append(':').append(proxy.getPort());
                        auth = proxy.getAuthentication();
                        if (auth != null) {
                            buffer.append(" with ").append(auth);
                        }
                    }
                    LOGGER.debug(buffer.toString());
                }
                return connector;
            }
            catch (NoRepositoryConnectorException e) {
                errors.add(e);
            }
        }
        if (LOGGER.isDebugEnabled() && errors.size() > 1) {
            for (Exception exception : errors) {
                LOGGER.debug("Could not obtain connector factory for {}", (Object)repository, (Object)exception);
            }
        }
        StringBuilder stringBuilder2 = new StringBuilder(256);
        if (factories.isEmpty()) {
            stringBuilder2.append("No connector factories available");
        } else {
            stringBuilder2.append("Cannot access ").append(repository.getUrl());
            stringBuilder2.append(" with type ").append(repository.getContentType());
            stringBuilder2.append(" using the available connector factories: ");
            factories.list(stringBuilder2);
        }
        throw new NoRepositoryConnectorException(repository, stringBuilder2.toString(), errors.size() == 1 ? (NoRepositoryConnectorException)errors.get(0) : null);
    }
}

