/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl;

import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;
import org.jetbrains.kotlin.org.eclipse.aether.impl.OfflineController;
import org.jetbrains.kotlin.org.eclipse.aether.metadata.Metadata;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ResolutionErrorPolicy;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ResolutionErrorPolicyRequest;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.RepositoryOfflineException;

final class Utils {
    Utils() {
    }

    public static int getPolicy(RepositorySystemSession session2, Artifact artifact, RemoteRepository repository) {
        ResolutionErrorPolicy rep = session2.getResolutionErrorPolicy();
        if (rep == null) {
            return 0;
        }
        return rep.getArtifactPolicy(session2, new ResolutionErrorPolicyRequest<Artifact>(artifact, repository));
    }

    public static int getPolicy(RepositorySystemSession session2, Metadata metadata2, RemoteRepository repository) {
        ResolutionErrorPolicy rep = session2.getResolutionErrorPolicy();
        if (rep == null) {
            return 0;
        }
        return rep.getMetadataPolicy(session2, new ResolutionErrorPolicyRequest<Metadata>(metadata2, repository));
    }

    public static void appendClassLoader(StringBuilder buffer, Object component) {
        ClassLoader loader = component.getClass().getClassLoader();
        if (loader != null && !loader.equals(Utils.class.getClassLoader())) {
            buffer.append(" from ").append(loader);
        }
    }

    public static void checkOffline(RepositorySystemSession session2, OfflineController offlineController, RemoteRepository repository) throws RepositoryOfflineException {
        if (session2.isOffline()) {
            offlineController.checkOffline(session2, repository);
        }
    }
}

