/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.util.artifact;

import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;

public final class ArtifactIdUtils {
    public static String toVersionlessId(Artifact artifact) {
        String id = null;
        if (artifact != null) {
            id = ArtifactIdUtils.toVersionlessId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier());
        }
        return id;
    }

    public static String toVersionlessId(String groupId, String artifactId, String extension, String classifier2) {
        return ArtifactIdUtils.concat(groupId, artifactId, extension, classifier2).toString();
    }

    private static StringBuilder concat(String groupId, String artifactId, String extension, String classifier2) {
        StringBuilder buffer = new StringBuilder(128);
        if (groupId != null) {
            buffer.append(groupId);
        }
        buffer.append(':');
        if (artifactId != null) {
            buffer.append(artifactId);
        }
        buffer.append(':');
        if (extension != null) {
            buffer.append(extension);
        }
        if (classifier2 != null && classifier2.length() > 0) {
            buffer.append(':').append(classifier2);
        }
        return buffer;
    }
}

