/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.inject;

import java.lang.annotation.Annotation;
import javax.inject.Provider;
import org.jetbrains.kotlin.com.google.inject.Binding;
import org.jetbrains.kotlin.com.google.inject.Key;
import org.jetbrains.kotlin.com.google.inject.name.Named;
import org.jetbrains.kotlin.com.google.inject.name.Names;
import org.jetbrains.kotlin.com.google.inject.spi.ConstructorBinding;
import org.jetbrains.kotlin.com.google.inject.spi.ProviderKeyBinding;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.Implementations;

enum QualifyingStrategy {
    UNRESTRICTED{

        @Override
        final Annotation qualifies(Key<?> requirement2, Binding<?> binding) {
            Annotation qualifier = 1.qualify(binding.getKey());
            return qualifier != null ? qualifier : BLANK_QUALIFIER;
        }
    }
    ,
    NAMED{

        @Override
        final Annotation qualifies(Key<?> requirement2, Binding<?> binding) {
            Annotation qualifier = 2.qualify(binding.getKey());
            return qualifier instanceof Named ? qualifier : null;
        }
    }
    ,
    NAMED_WITH_ATTRIBUTES{

        @Override
        final Annotation qualifies(Key<?> requirement2, Binding<?> binding) {
            Class<?> clazz;
            javax.inject.Named alias;
            Annotation qualifier = 3.qualify(binding.getKey());
            if (requirement2.getAnnotation().equals(qualifier)) {
                return qualifier;
            }
            if (binding instanceof ConstructorBinding && binding.getKey().getAnnotationType() == null && (alias = (clazz = binding.getKey().getTypeLiteral().getRawType()).getAnnotation(javax.inject.Named.class)) != null && alias.value().equals(((Named)requirement2.getAnnotation()).value()) && clazz.equals(Implementations.find(binding))) {
                return requirement2.getAnnotation();
            }
            return null;
        }
    }
    ,
    MARKED{

        @Override
        final Annotation qualifies(Key<?> requirement2, Binding<?> binding) {
            Annotation qualifier;
            final Class<Annotation> markerType = requirement2.getAnnotationType();
            if (markerType.isInstance(qualifier = 4.qualify(binding.getKey()))) {
                return qualifier;
            }
            if (markerType.equals(binding.getKey().getAnnotationType()) && markerType.getDeclaredMethods().length == 0) {
                return new Annotation(){

                    @Override
                    public Class<? extends Annotation> annotationType() {
                        return markerType;
                    }
                };
            }
            if (binding instanceof ProviderKeyBinding) {
                Key providerKey = ((ProviderKeyBinding)binding).getProviderKey();
                return providerKey.getTypeLiteral().getRawType().getAnnotation(markerType);
            }
            Class<?> implementation2 = Implementations.find(binding);
            return implementation2 != null ? implementation2.getAnnotation(markerType) : null;
        }
    }
    ,
    MARKED_WITH_ATTRIBUTES{

        @Override
        final Annotation qualifies(Key<?> requirement2, Binding<?> binding) {
            Annotation qualifier = MARKED.qualifies(requirement2, binding);
            return requirement2.getAnnotation().equals(qualifier) ? qualifier : null;
        }
    };

    static final Annotation DEFAULT_QUALIFIER;
    static final Annotation BLANK_QUALIFIER;

    static {
        DEFAULT_QUALIFIER = Names.named("default");
        BLANK_QUALIFIER = Names.named("");
    }

    private QualifyingStrategy() {
    }

    abstract Annotation qualifies(Key<?> var1, Binding<?> var2);

    static final QualifyingStrategy selectFor(Key<?> key) {
        Class<Annotation> qualifierType = key.getAnnotationType();
        if (qualifierType == null) {
            return UNRESTRICTED;
        }
        if (Named.class == qualifierType) {
            return key.hasAttributes() ? NAMED_WITH_ATTRIBUTES : NAMED;
        }
        return key.hasAttributes() ? MARKED_WITH_ATTRIBUTES : MARKED;
    }

    static final Annotation qualify(Key<?> key) {
        if (key.getAnnotationType() == null) {
            return DEFAULT_QUALIFIER;
        }
        Annotation qualifier = key.getAnnotation();
        if (qualifier instanceof Provider) {
            Object original = ((Provider)((Object)qualifier)).get();
            return original instanceof Annotation ? (Annotation)original : DEFAULT_QUALIFIER;
        }
        return qualifier;
    }

    /* synthetic */ QualifyingStrategy(String string2, int n, QualifyingStrategy qualifyingStrategy) {
        this();
    }
}

