/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.plexus;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jetbrains.kotlin.com.google.inject.TypeLiteral;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.ParameterizedConfigurationConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.jetbrains.kotlin.org.codehaus.plexus.configuration.PlexusConfiguration;
import org.jetbrains.kotlin.org.eclipse.sisu.bean.DeclaredMembers;

public final class CompositeBeanHelper {
    private static final Type[] NO_TYPES = new Type[0];
    private final ConverterLookup lookup;
    private final ClassLoader loader;
    private final ExpressionEvaluator evaluator;
    private final ConfigurationListener listener;

    public CompositeBeanHelper(ConverterLookup lookup2, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) {
        this.lookup = lookup2;
        this.loader = loader;
        this.evaluator = evaluator;
        this.listener = listener;
    }

    public void setDefault(Object bean, Object defaultValue2, PlexusConfiguration configuration2) throws ComponentConfigurationException {
        Type[] paramTypeHolder;
        Class<?> beanType = bean.getClass();
        Method setter2 = CompositeBeanHelper.findMethod(beanType, paramTypeHolder = new Type[1], "set");
        if (setter2 == null) {
            throw new ComponentConfigurationException(configuration2, "Cannot find default setter in " + beanType);
        }
        Object value2 = defaultValue2;
        TypeLiteral<?> paramType = TypeLiteral.get(paramTypeHolder[0]);
        if (!paramType.getRawType().isInstance(value2)) {
            if (configuration2.getChildCount() > 0) {
                throw new ComponentConfigurationException("Basic element '" + configuration2.getName() + "' must not contain child elements");
            }
            value2 = this.convertProperty(beanType, paramType.getRawType(), paramType.getType(), configuration2);
        }
        if (value2 != null) {
            try {
                if (this.listener != null) {
                    this.listener.notifyFieldChangeUsingSetter("", value2, bean);
                }
                setter2.invoke(bean, value2);
            }
            catch (Exception e) {
                throw new ComponentConfigurationException(configuration2, "Cannot set default", e);
            }
            catch (LinkageError e) {
                throw new ComponentConfigurationException(configuration2, "Cannot set default", e);
            }
        }
    }

    public void setProperty(Object bean, String propertyName, Class<?> valueType, PlexusConfiguration configuration2) throws ComponentConfigurationException {
        String reason;
        Field field2;
        Throwable problem;
        Method setter2;
        Class<?> beanType;
        block20: {
            String title;
            Type[] paramTypeHolder;
            beanType = bean.getClass();
            setter2 = CompositeBeanHelper.findMethod(beanType, paramTypeHolder = new Type[1], "set" + (title = String.valueOf(Character.toTitleCase(propertyName.charAt(0))) + propertyName.substring(1)));
            if (setter2 == null) {
                setter2 = CompositeBeanHelper.findMethod(beanType, paramTypeHolder, "add" + title);
            }
            problem = null;
            Object value2 = null;
            if (setter2 != null) {
                try {
                    TypeLiteral<?> paramType = TypeLiteral.get(paramTypeHolder[0]);
                    Class<?> rawPropertyType = paramType.getRawType();
                    if (valueType != null && rawPropertyType.isAssignableFrom(valueType)) {
                        rawPropertyType = valueType;
                    }
                    if ((value2 = this.convertProperty(beanType, rawPropertyType, paramType.getType(), configuration2)) != null) {
                        if (this.listener != null) {
                            this.listener.notifyFieldChangeUsingSetter(propertyName, value2, bean);
                        }
                        setter2.invoke(bean, value2);
                        return;
                    }
                }
                catch (Exception e) {
                    problem = e;
                }
                catch (LinkageError e) {
                    problem = e;
                }
            }
            if ((field2 = CompositeBeanHelper.findField(beanType, propertyName)) != null) {
                try {
                    TypeLiteral<?> fieldType = TypeLiteral.get(field2.getGenericType());
                    Class<?> rawPropertyType = fieldType.getRawType();
                    if (!rawPropertyType.isInstance(value2)) {
                        if (valueType != null && rawPropertyType.isAssignableFrom(valueType)) {
                            rawPropertyType = valueType;
                        }
                        value2 = this.convertProperty(beanType, rawPropertyType, fieldType.getType(), configuration2);
                    }
                    if (value2 != null) {
                        if (this.listener != null) {
                            this.listener.notifyFieldChangeUsingReflection(propertyName, value2, bean);
                        }
                        CompositeBeanHelper.setField(bean, field2, value2);
                        return;
                    }
                }
                catch (Exception e) {
                    if (problem == null) {
                        problem = e;
                    }
                }
                catch (LinkageError e) {
                    if (problem != null) break block20;
                    problem = e;
                }
            }
        }
        if (problem instanceof ComponentConfigurationException) {
            throw (ComponentConfigurationException)problem;
        }
        if (problem != null) {
            reason = "Cannot set '" + propertyName + "' in " + beanType;
            throw new ComponentConfigurationException(configuration2, reason, problem);
        }
        if (setter2 == null && field2 == null) {
            reason = "Cannot find '" + propertyName + "' in " + beanType;
            throw new ComponentConfigurationException(configuration2, reason);
        }
    }

    private Object convertProperty(Class<?> beanType, Class<?> rawPropertyType, Type genericPropertyType, PlexusConfiguration configuration2) throws ComponentConfigurationException {
        ConfigurationConverter converter = this.lookup.lookupConverterForType(rawPropertyType);
        if (!(genericPropertyType instanceof Class) && converter instanceof ParameterizedConfigurationConverter) {
            Type[] propertyTypeArgs = CompositeBeanHelper.getTypeArguments(genericPropertyType);
            return ((ParameterizedConfigurationConverter)converter).fromConfiguration(this.lookup, configuration2, rawPropertyType, propertyTypeArgs, beanType, this.loader, this.evaluator, this.listener);
        }
        return converter.fromConfiguration(this.lookup, configuration2, rawPropertyType, beanType, this.loader, this.evaluator, this.listener);
    }

    private static Type[] getTypeArguments(Type type2) {
        if (type2 instanceof ParameterizedType) {
            Type[] typeArguments2 = ((ParameterizedType)type2).getActualTypeArguments();
            int i = 0;
            while (i < typeArguments2.length) {
                typeArguments2[i] = CompositeBeanHelper.expandType(typeArguments2[i]);
                ++i;
            }
            return typeArguments2;
        }
        if (type2 instanceof GenericArrayType) {
            return new Type[]{CompositeBeanHelper.expandType(((GenericArrayType)type2).getGenericComponentType())};
        }
        return NO_TYPES;
    }

    private static Type expandType(Type type2) {
        if (type2 instanceof WildcardType) {
            return ((WildcardType)type2).getUpperBounds()[0];
        }
        if (type2 instanceof TypeVariable) {
            return ((TypeVariable)type2).getBounds()[0];
        }
        return type2;
    }

    private static Method findMethod(Class<?> beanType, Type[] paramTypeHolder, String methodName) {
        Method[] methodArray = beanType.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type[] paramTypes;
            Method m = methodArray[n2];
            if (methodName.equals(m.getName()) && !Modifier.isStatic(m.getModifiers()) && (paramTypes = m.getGenericParameterTypes()).length == 1) {
                paramTypeHolder[0] = paramTypes[0];
                return m;
            }
            ++n2;
        }
        return null;
    }

    private static Field findField(Class<?> beanType, String fieldName) {
        for (Member f : new DeclaredMembers(beanType, DeclaredMembers.View.FIELDS)) {
            if (!fieldName.equals(f.getName()) || Modifier.isStatic(f.getModifiers())) continue;
            return (Field)f;
        }
        return null;
    }

    private static void setField(Object bean, final Field field2, Object value2) throws Exception {
        if (!field2.isAccessible()) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    field2.setAccessible(true);
                    return null;
                }
            });
        }
        field2.set(bean, value2);
    }
}

