/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.plexus;

import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import org.jetbrains.kotlin.com.google.inject.Binder;
import org.jetbrains.kotlin.com.google.inject.Module;
import org.jetbrains.kotlin.org.codehaus.plexus.PlexusContainer;
import org.jetbrains.kotlin.org.codehaus.plexus.context.Context;
import org.jetbrains.kotlin.org.codehaus.plexus.context.ContextMapAdapter;
import org.jetbrains.kotlin.org.codehaus.plexus.context.DefaultContext;
import org.jetbrains.kotlin.org.codehaus.plexus.logging.LoggerManager;
import org.jetbrains.kotlin.org.eclipse.sisu.Parameters;
import org.jetbrains.kotlin.org.eclipse.sisu.bean.BeanManager;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.DeferredProvider;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.DefaultPlexusBeanLocator;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusAnnotatedBeanModule;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusBeanConverter;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusBeanLocator;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusBeanModule;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusBindingModule;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusLifecycleManager;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusXmlBeanConverter;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusXmlBeanModule;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PseudoPlexusContainer;
import org.jetbrains.kotlin.org.eclipse.sisu.space.BeanScanning;
import org.jetbrains.kotlin.org.eclipse.sisu.space.ClassSpace;

public final class PlexusSpaceModule
implements Module {
    private final ClassSpace space;
    private final BeanScanning scanning;
    private BeanManager delegate;

    public PlexusSpaceModule(ClassSpace space) {
        this(space, BeanScanning.OFF);
    }

    public PlexusSpaceModule(ClassSpace space, BeanScanning scanning) {
        this.space = space;
        this.scanning = scanning;
    }

    @Override
    public void configure(Binder binder) {
        ParameterizedContext context2 = new ParameterizedContext();
        binder.bind(Context.class).toInstance(context2);
        DeferredProvider<?> slf4jLoggerFactoryProvider = this.space.deferLoadClass("org.slf4j.ILoggerFactory").asProvider();
        binder.requestInjection(slf4jLoggerFactoryProvider);
        binder.bind(PlexusBeanConverter.class).to(PlexusXmlBeanConverter.class);
        binder.bind(PlexusBeanLocator.class).to(DefaultPlexusBeanLocator.class);
        binder.bind(PlexusContainer.class).to(PseudoPlexusContainer.class);
        BeanManager manager = this.delegate instanceof PlexusLifecycleManager ? this.delegate : new PlexusLifecycleManager(binder.getProvider(Context.class), binder.getProvider(LoggerManager.class), slf4jLoggerFactoryProvider, this.delegate);
        binder.bind(BeanManager.class).toInstance(manager);
        ArrayList<PlexusBeanModule> beanModules = new ArrayList<PlexusBeanModule>();
        ContextMapAdapter variables = new ContextMapAdapter(context2);
        beanModules.add(new PlexusXmlBeanModule(this.space, variables));
        beanModules.add(new PlexusAnnotatedBeanModule(this.space, variables, this.scanning));
        binder.install(new PlexusBindingModule(manager, beanModules));
    }

    public PlexusSpaceModule with(BeanManager manager) {
        this.delegate = manager;
        return this;
    }

    static final class ParameterizedContext
    extends DefaultContext {
        ParameterizedContext() {
        }

        @Inject
        protected void setParameters(@Parameters Map parameters2, PlexusContainer container) {
            this.contextData.putAll(parameters2);
            this.contextData.put("plexus", container);
        }
    }
}

