/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jline.terminal.impl.jna.linux;

import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.kotlin.org.jline.terminal.Attributes;
import org.jetbrains.kotlin.org.jline.terminal.Size;

public interface CLibrary
extends Library {
    public void tcgetattr(int var1, termios var2) throws LastErrorException;

    public void tcsetattr(int var1, int var2, termios var3) throws LastErrorException;

    public void ioctl(int var1, int var2, winsize var3) throws LastErrorException;

    public void ttyname_r(int var1, byte[] var2, int var3) throws LastErrorException;

    public static class termios
    extends Structure {
        public int c_iflag;
        public int c_oflag;
        public int c_cflag;
        public int c_lflag;
        public byte[] c_cc = new byte[32];

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList("c_iflag", "c_oflag", "c_cflag", "c_lflag", "c_line", "c_cc", "c_ispeed", "c_ospeed");
        }

        public termios() {
        }

        public termios(Attributes t) {
            this.c_iflag = this.setFlag(t.getInputFlag(Attributes.InputFlag.IGNBRK), 1, this.c_iflag);
            this.c_iflag = this.setFlag(t.getInputFlag(Attributes.InputFlag.BRKINT), 2, this.c_iflag);
            this.c_iflag = this.setFlag(t.getInputFlag(Attributes.InputFlag.IGNPAR), 4, this.c_iflag);
            this.c_iflag = this.setFlag(t.getInputFlag(Attributes.InputFlag.PARMRK), 8, this.c_iflag);
            this.c_iflag = this.setFlag(t.getInputFlag(Attributes.InputFlag.INPCK), 16, this.c_iflag);
            this.c_iflag = this.setFlag(t.getInputFlag(Attributes.InputFlag.ISTRIP), 32, this.c_iflag);
            this.c_iflag = this.setFlag(t.getInputFlag(Attributes.InputFlag.INLCR), 64, this.c_iflag);
            this.c_iflag = this.setFlag(t.getInputFlag(Attributes.InputFlag.IGNCR), 128, this.c_iflag);
            this.c_iflag = this.setFlag(t.getInputFlag(Attributes.InputFlag.ICRNL), 256, this.c_iflag);
            this.c_iflag = this.setFlag(t.getInputFlag(Attributes.InputFlag.IXON), 1024, this.c_iflag);
            this.c_iflag = this.setFlag(t.getInputFlag(Attributes.InputFlag.IXOFF), 4096, this.c_iflag);
            this.c_iflag = this.setFlag(t.getInputFlag(Attributes.InputFlag.IXANY), 2048, this.c_iflag);
            this.c_iflag = this.setFlag(t.getInputFlag(Attributes.InputFlag.IMAXBEL), 8192, this.c_iflag);
            this.c_iflag = this.setFlag(t.getInputFlag(Attributes.InputFlag.IUTF8), 16384, this.c_iflag);
            this.c_oflag = this.setFlag(t.getOutputFlag(Attributes.OutputFlag.OPOST), 1, this.c_oflag);
            this.c_oflag = this.setFlag(t.getOutputFlag(Attributes.OutputFlag.ONLCR), 4, this.c_oflag);
            this.c_oflag = this.setFlag(t.getOutputFlag(Attributes.OutputFlag.OCRNL), 8, this.c_oflag);
            this.c_oflag = this.setFlag(t.getOutputFlag(Attributes.OutputFlag.ONOCR), 16, this.c_oflag);
            this.c_oflag = this.setFlag(t.getOutputFlag(Attributes.OutputFlag.ONLRET), 32, this.c_oflag);
            this.c_oflag = this.setFlag(t.getOutputFlag(Attributes.OutputFlag.OFILL), 64, this.c_oflag);
            this.c_oflag = this.setFlag(t.getOutputFlag(Attributes.OutputFlag.NLDLY), 256, this.c_oflag);
            this.c_oflag = this.setFlag(t.getOutputFlag(Attributes.OutputFlag.TABDLY), 6144, this.c_oflag);
            this.c_oflag = this.setFlag(t.getOutputFlag(Attributes.OutputFlag.CRDLY), 1536, this.c_oflag);
            this.c_oflag = this.setFlag(t.getOutputFlag(Attributes.OutputFlag.FFDLY), 32768, this.c_oflag);
            this.c_oflag = this.setFlag(t.getOutputFlag(Attributes.OutputFlag.BSDLY), 8192, this.c_oflag);
            this.c_oflag = this.setFlag(t.getOutputFlag(Attributes.OutputFlag.VTDLY), 16384, this.c_oflag);
            this.c_oflag = this.setFlag(t.getOutputFlag(Attributes.OutputFlag.OFDEL), 128, this.c_oflag);
            this.c_cflag = this.setFlag(t.getControlFlag(Attributes.ControlFlag.CS5), 0, this.c_cflag);
            this.c_cflag = this.setFlag(t.getControlFlag(Attributes.ControlFlag.CS6), 16, this.c_cflag);
            this.c_cflag = this.setFlag(t.getControlFlag(Attributes.ControlFlag.CS7), 32, this.c_cflag);
            this.c_cflag = this.setFlag(t.getControlFlag(Attributes.ControlFlag.CS8), 48, this.c_cflag);
            this.c_cflag = this.setFlag(t.getControlFlag(Attributes.ControlFlag.CSTOPB), 64, this.c_cflag);
            this.c_cflag = this.setFlag(t.getControlFlag(Attributes.ControlFlag.CREAD), 128, this.c_cflag);
            this.c_cflag = this.setFlag(t.getControlFlag(Attributes.ControlFlag.PARENB), 256, this.c_cflag);
            this.c_cflag = this.setFlag(t.getControlFlag(Attributes.ControlFlag.PARODD), 512, this.c_cflag);
            this.c_cflag = this.setFlag(t.getControlFlag(Attributes.ControlFlag.HUPCL), 1024, this.c_cflag);
            this.c_cflag = this.setFlag(t.getControlFlag(Attributes.ControlFlag.CLOCAL), 2048, this.c_cflag);
            this.c_lflag = this.setFlag(t.getLocalFlag(Attributes.LocalFlag.ECHOKE), 2048, this.c_lflag);
            this.c_lflag = this.setFlag(t.getLocalFlag(Attributes.LocalFlag.ECHOE), 16, this.c_lflag);
            this.c_lflag = this.setFlag(t.getLocalFlag(Attributes.LocalFlag.ECHOK), 32, this.c_lflag);
            this.c_lflag = this.setFlag(t.getLocalFlag(Attributes.LocalFlag.ECHO), 8, this.c_lflag);
            this.c_lflag = this.setFlag(t.getLocalFlag(Attributes.LocalFlag.ECHONL), 64, this.c_lflag);
            this.c_lflag = this.setFlag(t.getLocalFlag(Attributes.LocalFlag.ECHOPRT), 1024, this.c_lflag);
            this.c_lflag = this.setFlag(t.getLocalFlag(Attributes.LocalFlag.ECHOCTL), 512, this.c_lflag);
            this.c_lflag = this.setFlag(t.getLocalFlag(Attributes.LocalFlag.ISIG), 1, this.c_lflag);
            this.c_lflag = this.setFlag(t.getLocalFlag(Attributes.LocalFlag.ICANON), 2, this.c_lflag);
            this.c_lflag = this.setFlag(t.getLocalFlag(Attributes.LocalFlag.EXTPROC), 65536, this.c_lflag);
            this.c_lflag = this.setFlag(t.getLocalFlag(Attributes.LocalFlag.TOSTOP), 256, this.c_lflag);
            this.c_lflag = this.setFlag(t.getLocalFlag(Attributes.LocalFlag.FLUSHO), 4096, this.c_lflag);
            this.c_lflag = this.setFlag(t.getLocalFlag(Attributes.LocalFlag.NOFLSH), 128, this.c_lflag);
            this.c_cc[4] = (byte)t.getControlChar(Attributes.ControlChar.VEOF);
            this.c_cc[11] = (byte)t.getControlChar(Attributes.ControlChar.VEOL);
            this.c_cc[16] = (byte)t.getControlChar(Attributes.ControlChar.VEOL2);
            this.c_cc[2] = (byte)t.getControlChar(Attributes.ControlChar.VERASE);
            this.c_cc[14] = (byte)t.getControlChar(Attributes.ControlChar.VWERASE);
            this.c_cc[3] = (byte)t.getControlChar(Attributes.ControlChar.VKILL);
            this.c_cc[12] = (byte)t.getControlChar(Attributes.ControlChar.VREPRINT);
            this.c_cc[0] = (byte)t.getControlChar(Attributes.ControlChar.VINTR);
            this.c_cc[1] = (byte)t.getControlChar(Attributes.ControlChar.VQUIT);
            this.c_cc[10] = (byte)t.getControlChar(Attributes.ControlChar.VSUSP);
            this.c_cc[8] = (byte)t.getControlChar(Attributes.ControlChar.VSTART);
            this.c_cc[9] = (byte)t.getControlChar(Attributes.ControlChar.VSTOP);
            this.c_cc[15] = (byte)t.getControlChar(Attributes.ControlChar.VLNEXT);
            this.c_cc[13] = (byte)t.getControlChar(Attributes.ControlChar.VDISCARD);
            this.c_cc[6] = (byte)t.getControlChar(Attributes.ControlChar.VMIN);
            this.c_cc[5] = (byte)t.getControlChar(Attributes.ControlChar.VTIME);
        }

        private int setFlag(boolean flag, int value2, int org) {
            return flag ? org | value2 : org;
        }

        public Attributes toAttributes() {
            Attributes attr = new Attributes();
            EnumSet<Attributes.InputFlag> iflag = attr.getInputFlags();
            this.addFlag(this.c_iflag, iflag, Attributes.InputFlag.IGNBRK, 1);
            this.addFlag(this.c_iflag, iflag, Attributes.InputFlag.IGNBRK, 1);
            this.addFlag(this.c_iflag, iflag, Attributes.InputFlag.BRKINT, 2);
            this.addFlag(this.c_iflag, iflag, Attributes.InputFlag.IGNPAR, 4);
            this.addFlag(this.c_iflag, iflag, Attributes.InputFlag.PARMRK, 8);
            this.addFlag(this.c_iflag, iflag, Attributes.InputFlag.INPCK, 16);
            this.addFlag(this.c_iflag, iflag, Attributes.InputFlag.ISTRIP, 32);
            this.addFlag(this.c_iflag, iflag, Attributes.InputFlag.INLCR, 64);
            this.addFlag(this.c_iflag, iflag, Attributes.InputFlag.IGNCR, 128);
            this.addFlag(this.c_iflag, iflag, Attributes.InputFlag.ICRNL, 256);
            this.addFlag(this.c_iflag, iflag, Attributes.InputFlag.IXON, 1024);
            this.addFlag(this.c_iflag, iflag, Attributes.InputFlag.IXOFF, 4096);
            this.addFlag(this.c_iflag, iflag, Attributes.InputFlag.IXANY, 2048);
            this.addFlag(this.c_iflag, iflag, Attributes.InputFlag.IMAXBEL, 8192);
            this.addFlag(this.c_iflag, iflag, Attributes.InputFlag.IUTF8, 16384);
            EnumSet<Attributes.OutputFlag> oflag = attr.getOutputFlags();
            this.addFlag(this.c_oflag, oflag, Attributes.OutputFlag.OPOST, 1);
            this.addFlag(this.c_oflag, oflag, Attributes.OutputFlag.ONLCR, 4);
            this.addFlag(this.c_oflag, oflag, Attributes.OutputFlag.OCRNL, 8);
            this.addFlag(this.c_oflag, oflag, Attributes.OutputFlag.ONOCR, 16);
            this.addFlag(this.c_oflag, oflag, Attributes.OutputFlag.ONLRET, 32);
            this.addFlag(this.c_oflag, oflag, Attributes.OutputFlag.OFILL, 64);
            this.addFlag(this.c_oflag, oflag, Attributes.OutputFlag.NLDLY, 256);
            this.addFlag(this.c_oflag, oflag, Attributes.OutputFlag.TABDLY, 6144);
            this.addFlag(this.c_oflag, oflag, Attributes.OutputFlag.CRDLY, 1536);
            this.addFlag(this.c_oflag, oflag, Attributes.OutputFlag.FFDLY, 32768);
            this.addFlag(this.c_oflag, oflag, Attributes.OutputFlag.BSDLY, 8192);
            this.addFlag(this.c_oflag, oflag, Attributes.OutputFlag.VTDLY, 16384);
            this.addFlag(this.c_oflag, oflag, Attributes.OutputFlag.OFDEL, 128);
            EnumSet<Attributes.ControlFlag> cflag = attr.getControlFlags();
            this.addFlag(this.c_cflag, cflag, Attributes.ControlFlag.CS5, 0);
            this.addFlag(this.c_cflag, cflag, Attributes.ControlFlag.CS6, 16);
            this.addFlag(this.c_cflag, cflag, Attributes.ControlFlag.CS7, 32);
            this.addFlag(this.c_cflag, cflag, Attributes.ControlFlag.CS8, 48);
            this.addFlag(this.c_cflag, cflag, Attributes.ControlFlag.CSTOPB, 64);
            this.addFlag(this.c_cflag, cflag, Attributes.ControlFlag.CREAD, 128);
            this.addFlag(this.c_cflag, cflag, Attributes.ControlFlag.PARENB, 256);
            this.addFlag(this.c_cflag, cflag, Attributes.ControlFlag.PARODD, 512);
            this.addFlag(this.c_cflag, cflag, Attributes.ControlFlag.HUPCL, 1024);
            this.addFlag(this.c_cflag, cflag, Attributes.ControlFlag.CLOCAL, 2048);
            EnumSet<Attributes.LocalFlag> lflag = attr.getLocalFlags();
            this.addFlag(this.c_lflag, lflag, Attributes.LocalFlag.ECHOKE, 2048);
            this.addFlag(this.c_lflag, lflag, Attributes.LocalFlag.ECHOE, 16);
            this.addFlag(this.c_lflag, lflag, Attributes.LocalFlag.ECHOK, 32);
            this.addFlag(this.c_lflag, lflag, Attributes.LocalFlag.ECHO, 8);
            this.addFlag(this.c_lflag, lflag, Attributes.LocalFlag.ECHONL, 64);
            this.addFlag(this.c_lflag, lflag, Attributes.LocalFlag.ECHOPRT, 1024);
            this.addFlag(this.c_lflag, lflag, Attributes.LocalFlag.ECHOCTL, 512);
            this.addFlag(this.c_lflag, lflag, Attributes.LocalFlag.ISIG, 1);
            this.addFlag(this.c_lflag, lflag, Attributes.LocalFlag.ICANON, 2);
            this.addFlag(this.c_lflag, lflag, Attributes.LocalFlag.EXTPROC, 65536);
            this.addFlag(this.c_lflag, lflag, Attributes.LocalFlag.TOSTOP, 256);
            this.addFlag(this.c_lflag, lflag, Attributes.LocalFlag.FLUSHO, 4096);
            this.addFlag(this.c_lflag, lflag, Attributes.LocalFlag.NOFLSH, 128);
            EnumMap<Attributes.ControlChar, Integer> cc = attr.getControlChars();
            cc.put(Attributes.ControlChar.VEOF, Integer.valueOf(this.c_cc[4]));
            cc.put(Attributes.ControlChar.VEOL, Integer.valueOf(this.c_cc[11]));
            cc.put(Attributes.ControlChar.VEOL2, Integer.valueOf(this.c_cc[16]));
            cc.put(Attributes.ControlChar.VERASE, Integer.valueOf(this.c_cc[2]));
            cc.put(Attributes.ControlChar.VWERASE, Integer.valueOf(this.c_cc[14]));
            cc.put(Attributes.ControlChar.VKILL, Integer.valueOf(this.c_cc[3]));
            cc.put(Attributes.ControlChar.VREPRINT, Integer.valueOf(this.c_cc[12]));
            cc.put(Attributes.ControlChar.VINTR, Integer.valueOf(this.c_cc[0]));
            cc.put(Attributes.ControlChar.VQUIT, Integer.valueOf(this.c_cc[1]));
            cc.put(Attributes.ControlChar.VSUSP, Integer.valueOf(this.c_cc[10]));
            cc.put(Attributes.ControlChar.VSTART, Integer.valueOf(this.c_cc[8]));
            cc.put(Attributes.ControlChar.VSTOP, Integer.valueOf(this.c_cc[9]));
            cc.put(Attributes.ControlChar.VLNEXT, Integer.valueOf(this.c_cc[15]));
            cc.put(Attributes.ControlChar.VDISCARD, Integer.valueOf(this.c_cc[13]));
            cc.put(Attributes.ControlChar.VMIN, Integer.valueOf(this.c_cc[6]));
            cc.put(Attributes.ControlChar.VTIME, Integer.valueOf(this.c_cc[5]));
            return attr;
        }

        private <T extends Enum<T>> void addFlag(int value2, EnumSet<T> flags, T flag, int v) {
            if ((value2 & v) != 0) {
                flags.add(flag);
            }
        }
    }

    public static class winsize
    extends Structure {
        public short ws_row;
        public short ws_col;

        public winsize() {
        }

        public winsize(Size ws) {
            this.ws_row = (short)ws.getRows();
            this.ws_col = (short)ws.getColumns();
        }

        public Size toSize() {
            return new Size(this.ws_col, this.ws_row);
        }

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList("ws_row", "ws_col", "ws_xpixel", "ws_ypixel");
        }
    }
}

