/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import gnu.trove.TIntArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.LiteralTextEscaper;
import org.jetbrains.kotlin.com.intellij.psi.PsiLanguageInjectionHost;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016J\b\u0010\u0012\u001a\u00020\bH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/psi/KotlinStringLiteralTextEscaper;", "Lorg/jetbrains/kotlin/com/intellij/psi/LiteralTextEscaper;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "host", "(Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;)V", "sourceOffsets", "", "decode", "", "rangeInsideHost", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/TextRange;", "outChars", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getOffsetInHost", "", "offsetInDecoded", "getRelevantTextRange", "isOneLine", "psi"})
public final class KotlinStringLiteralTextEscaper
extends LiteralTextEscaper<KtStringTemplateExpression> {
    @Nullable
    private int[] sourceOffsets;

    public KotlinStringLiteralTextEscaper(@NotNull KtStringTemplateExpression host) {
        Intrinsics.checkNotNullParameter(host, "host");
        super((PsiLanguageInjectionHost)host);
    }

    @Override
    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        Intrinsics.checkNotNullParameter(rangeInsideHost, "rangeInsideHost");
        Intrinsics.checkNotNullParameter(outChars, "outChars");
        TIntArrayList sourceOffsetsList = new TIntArrayList();
        int sourceOffset = 0;
        KtStringTemplateEntry[] ktStringTemplateEntryArray = ((KtStringTemplateExpression)this.myHost).getEntries();
        Intrinsics.checkNotNullExpressionValue(ktStringTemplateEntryArray, "myHost.entries");
        KtStringTemplateEntry[] ktStringTemplateEntryArray2 = ktStringTemplateEntryArray;
        int n = 0;
        int n2 = ktStringTemplateEntryArray2.length;
        while (n < n2) {
            int it;
            int n3;
            int n4;
            int n5;
            KtStringTemplateEntry child = ktStringTemplateEntryArray2[n];
            ++n;
            Object object = TextRange.from(child.getStartOffsetInParent(), child.getTextLength());
            Intrinsics.checkNotNullExpressionValue(object, "from(child.startOffsetInParent, child.textLength)");
            TextRange childRange = object;
            if (rangeInsideHost.getEndOffset() <= childRange.getStartOffset()) break;
            if (childRange.getEndOffset() <= rangeInsideHost.getStartOffset()) continue;
            object = child;
            if (object instanceof KtEscapeStringTemplateEntry) {
                if (!rangeInsideHost.contains(childRange)) {
                    sourceOffsetsList.add(sourceOffset);
                    this.sourceOffsets = sourceOffsetsList.toNativeArray();
                    return false;
                }
                String unescaped = ((KtEscapeStringTemplateEntry)child).getUnescapedValue();
                outChars.append(unescaped);
                n5 = unescaped.length();
                n4 = 0;
                while (n4 < n5) {
                    it = n3 = n4++;
                    boolean bl = false;
                    sourceOffsetsList.add(sourceOffset);
                }
                sourceOffset += child.getTextLength();
                continue;
            }
            TextRange textRange = rangeInsideHost.intersection(childRange);
            Intrinsics.checkNotNull(textRange);
            TextRange textRange2 = textRange.shiftRight(-childRange.getStartOffset());
            Intrinsics.checkNotNullExpressionValue(textRange2, "rangeInsideHost.intersec\u2026(-childRange.startOffset)");
            TextRange textRange3 = textRange2;
            outChars.append(child.getText(), textRange3.getStartOffset(), textRange3.getEndOffset());
            n5 = textRange3.getLength();
            n4 = 0;
            while (n4 < n5) {
                it = n3 = n4++;
                boolean bl = false;
                int n6 = sourceOffset;
                sourceOffset = n6 + 1;
                sourceOffsetsList.add(n6);
            }
        }
        sourceOffsetsList.add(sourceOffset);
        this.sourceOffsets = sourceOffsetsList.toNativeArray();
        return true;
    }

    @Override
    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        Intrinsics.checkNotNullParameter(rangeInsideHost, "rangeInsideHost");
        int[] offsets = this.sourceOffsets;
        if (offsets == null || offsetInDecoded >= offsets.length) {
            return -1;
        }
        return Math.min(offsets[offsetInDecoded], rangeInsideHost.getLength()) + rangeInsideHost.getStartOffset();
    }

    @Override
    @NotNull
    public TextRange getRelevantTextRange() {
        PsiLanguageInjectionHost psiLanguageInjectionHost = this.myHost;
        Intrinsics.checkNotNullExpressionValue(psiLanguageInjectionHost, "myHost");
        return KtPsiUtilKt.getContentRange((KtStringTemplateExpression)psiLanguageInjectionHost);
    }

    @Override
    public boolean isOneLine() {
        PsiLanguageInjectionHost psiLanguageInjectionHost = this.myHost;
        Intrinsics.checkNotNullExpressionValue(psiLanguageInjectionHost, "myHost");
        return KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)psiLanguageInjectionHost);
    }
}

