/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters;

import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.util.ReflectionUtil;

public class ClassFilter
implements ElementFilter {
    private final Class myFilter;
    private final boolean myAcceptableFlag;

    public ClassFilter(Class filter) {
        this(filter, true);
    }

    public ClassFilter(Class filter, boolean acceptableFlag) {
        this.myFilter = filter;
        this.myAcceptableFlag = acceptableFlag;
    }

    public boolean isClassAcceptable(Class hintClass) {
        return this.myAcceptableFlag == this.filterMatches(hintClass);
    }

    @Override
    public boolean isAcceptable(Object element, PsiElement context) {
        return element != null && this.myAcceptableFlag == this.filterMatches(element.getClass());
    }

    private boolean filterMatches(Class hintClass) {
        return ReflectionUtil.isAssignable(this.myFilter, hintClass);
    }

    @Override
    public String toString() {
        return "class(" + this.myFilter.getName() + ")";
    }
}

