/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.preprocessor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrOverridableMember;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.preprocessor.IrInterpreterPreprocessor;
import org.jetbrains.kotlin.ir.interpreter.preprocessor.IrInterpreterPreprocessorData;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterKCallableNamePreprocessor;", "Lorg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterPreprocessor;", "<init>", "()V", "visitCall", "Lorg/jetbrains/kotlin/ir/IrElement;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "data", "Lorg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterPreprocessorData;", "Companion", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nIrInterpreterKCallableNamePreprocessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrInterpreterKCallableNamePreprocessor.kt\norg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterKCallableNamePreprocessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,81:1\n1557#2:82\n1628#2,3:83\n37#3:86\n36#3,3:87\n350#4,12:90\n*S KotlinDebug\n*F\n+ 1 IrInterpreterKCallableNamePreprocessor.kt\norg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterKCallableNamePreprocessor\n*L\n39#1:82\n39#1:83,3\n42#1:86\n42#1:87,3\n47#1:90,12\n*E\n"})
public final class IrInterpreterKCallableNamePreprocessor
extends IrInterpreterPreprocessor {
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrElement visitCall(@NotNull IrCall expression2, @NotNull IrInterpreterPreprocessorData data) {
        void $this$single$iv;
        Sequence<IrProperty> kFunction;
        Object object;
        SpreadBuilder $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!Companion.isKCallableNameCall(expression2, data.getIrBuiltIns())) {
            return super.visitCall(expression2, data);
        }
        IrExpression irExpression = expression2.getDispatchReceiver();
        IrCallableReference irCallableReference = irExpression instanceof IrCallableReference ? (IrCallableReference)irExpression : null;
        if (irCallableReference == null) {
            return super.visitCall(expression2, data);
        }
        IrCallableReference callableReference = irCallableReference;
        IrExpression irExpression2 = callableReference.getDispatchReceiver();
        if (irExpression2 == null && (irExpression2 = callableReference.getExtensionReceiver()) == null) {
            return expression2;
        }
        IrExpression receiver = irExpression2;
        IrType irType = callableReference.getType();
        Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        Iterable $this$map$iv = ((IrSimpleType)irType).getArguments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            IrType irType2 = IrTypesKt.getTypeOrNull((IrTypeArgument)it);
            Intrinsics.checkNotNull((Object)irType2);
            object.add(irType2);
        }
        List typeArguments = (List)destination$iv$iv;
        if (IrTypeUtilsKt.isKFunction(callableReference.getType())) {
            kFunction = data.getIrBuiltIns().kFunctionN(typeArguments.size());
            $this$mapTo$iv$iv = new SpreadBuilder(2);
            $this$mapTo$iv$iv.add((Object)receiver.getType());
            Collection $this$toTypedArray$iv = typeArguments;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            $this$mapTo$iv$iv.addSpread((Object)thisCollection$iv.toArray(new IrType[0]));
            IrSimpleType newType = IrTypesKt.typeWith(kFunction, (IrType[])$this$mapTo$iv$iv.toArray((Object[])new IrType[$this$mapTo$iv$iv.size()]));
            callableReference.setType(newType);
        }
        kFunction = IrUtilsKt.getProperties((IrDeclarationContainer)data.getIrBuiltIns().getKCallableClass().getOwner());
        object = expression2;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrProperty it = (IrProperty)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)"name")) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunction irSimpleFunction = ((IrProperty)single$iv).getGetter();
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        ((IrCall)object).setSymbol(irSimpleFunction.getSymbol());
        callableReference.setDispatchReceiver(null);
        callableReference.setExtensionReceiver(null);
        if (receiver instanceof IrGetValue && Intrinsics.areEqual((Object)((IrGetValue)receiver).getSymbol().getOwner().getName(), (Object)SpecialNames.THIS)) {
            return expression2;
        }
        Object[] objectArray = new IrExpression[]{receiver, expression2};
        return new IrCompositeImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), null, CollectionsKt.listOf((Object[])objectArray));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\n\u0010\t\u001a\u00020\u0005*\u00020\u0006\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterKCallableNamePreprocessor$Companion;", "", "<init>", "()V", "isKCallableNameCall", "", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "isEnumName", "ir.interpreter"})
    @SourceDebugExtension(value={"SMAP\nIrInterpreterKCallableNamePreprocessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrInterpreterKCallableNamePreprocessor.kt\norg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterKCallableNamePreprocessor$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isKCallableNameCall(@NotNull IrCall $this$isKCallableNameCall, @NotNull IrBuiltIns irBuiltIns) {
            Name name2;
            Intrinsics.checkNotNullParameter((Object)$this$isKCallableNameCall, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
            if (!($this$isKCallableNameCall.getDispatchReceiver() instanceof IrCallableReference)) {
                return false;
            }
            IrSimpleFunction it = (IrSimpleFunction)$this$isKCallableNameCall.getSymbol().getOwner();
            boolean bl = false;
            IrProperty irProperty = UtilsKt.getProperty(it);
            IrOverridableMember directMember = (IrOverridableMember)(irProperty != null ? (IrElement)irProperty : (IrElement)it);
            IrElement irElement = directMember.getParent();
            IrClass irClass = irElement instanceof IrClass ? (IrClass)irElement : null;
            if (irClass == null) {
                return false;
            }
            IrClass irClass2 = irClass;
            if (!IrUtilsKt.isSubclassOf(irClass2, (IrClass)irBuiltIns.getKCallableClass().getOwner())) {
                return false;
            }
            irElement = directMember;
            if (irElement instanceof IrSimpleFunction) {
                name2 = directMember.getName();
            } else if (irElement instanceof IrProperty) {
                name2 = directMember.getName();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Name name3 = name2;
            return Intrinsics.areEqual((Object)name3.asString(), (Object)"name");
        }

        public final boolean isEnumName(@NotNull IrCall $this$isEnumName) {
            Intrinsics.checkNotNullParameter((Object)$this$isEnumName, (String)"<this>");
            IrSimpleFunction owner = (IrSimpleFunction)$this$isEnumName.getSymbol().getOwner();
            if (owner.getExtensionReceiverParameter() != null || !((Collection)owner.getValueParameters()).isEmpty()) {
                return false;
            }
            IrProperty irProperty = UtilsKt.getProperty(owner);
            if (irProperty == null) {
                return false;
            }
            IrProperty property2 = irProperty;
            return $this$isEnumName.getDispatchReceiver() instanceof IrGetEnumValue && Intrinsics.areEqual((Object)property2.getName().asString(), (Object)"name");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

