/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.library.metadata.DeserializedSourceFile;
import org.jetbrains.kotlin.library.metadata.KlibMetadataDeserializedPackageFragment;
import org.jetbrains.kotlin.library.metadata.KlibMetadataProtoBuf;
import org.jetbrains.kotlin.library.metadata.KlibModuleOriginKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.OptionalAnnotationUtil;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedClassConstructorDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedClassDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedPropertyDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedSimpleFunctionDescriptor;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u0002\u001a\r\u0010\u0010\u001a\u00020\u0011*\u00020\u0002H\u0086\u0010\u001a\n\u0010\u0012\u001a\u00020\t*\u00020\u000b\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\"\u0018\u0010\u0007\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0003\u00a8\u0006\u0013"}, d2={"isExpectMember", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z", "isForwardDeclarationModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)Z", "isSerializableExpectClass", "sourceByIndex", "Lorg/jetbrains/kotlin/descriptors/SourceFile;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "index", "", "extractSerializedKdocString", "", "findPackage", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "findSourceFile", "ir.serialization.common"})
public final class LegacyDescriptorUtilsKt {
    public static final boolean isExpectMember(@NotNull DeclarationDescriptor $this$isExpectMember) {
        Intrinsics.checkNotNullParameter((Object)$this$isExpectMember, (String)"<this>");
        return $this$isExpectMember instanceof MemberDescriptor && ((MemberDescriptor)$this$isExpectMember).isExpect();
    }

    public static final boolean isSerializableExpectClass(@NotNull DeclarationDescriptor $this$isSerializableExpectClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isSerializableExpectClass, (String)"<this>");
        return $this$isSerializableExpectClass instanceof ClassDescriptor && OptionalAnnotationUtil.shouldGenerateExpectClass((ClassDescriptor)$this$isSerializableExpectClass);
    }

    @NotNull
    public static final PackageFragmentDescriptor findPackage(@NotNull DeclarationDescriptor $this$findPackage) {
        Intrinsics.checkNotNullParameter((Object)$this$findPackage, (String)"<this>");
        while (!($this$findPackage instanceof PackageFragmentDescriptor)) {
            Intrinsics.checkNotNull((Object)$this$findPackage.getContainingDeclaration());
        }
        return (PackageFragmentDescriptor)$this$findPackage;
    }

    public static final boolean isForwardDeclarationModule(@NotNull ModuleDescriptor $this$isForwardDeclarationModule) {
        Intrinsics.checkNotNullParameter((Object)$this$isForwardDeclarationModule, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isForwardDeclarationModule.getName(), (Object)Name.special("<forward declarations>"));
    }

    private static final SourceFile sourceByIndex(CallableMemberDescriptor descriptor2, int index2) {
        PackageFragmentDescriptor packageFragmentDescriptor = LegacyDescriptorUtilsKt.findPackage(descriptor2);
        Intrinsics.checkNotNull((Object)packageFragmentDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.library.metadata.KlibMetadataDeserializedPackageFragment");
        KlibMetadataDeserializedPackageFragment fragment = (KlibMetadataDeserializedPackageFragment)packageFragmentDescriptor;
        String fileName = (String)fragment.getProto().getStrings().getStringList().get(index2);
        Intrinsics.checkNotNullExpressionValue((Object)fileName, (String)"fileName");
        return new DeserializedSourceFile(fileName, KlibModuleOriginKt.getKotlinLibrary(DescriptorUtilsKt.getModule(descriptor2)));
    }

    @NotNull
    public static final SourceFile findSourceFile(@NotNull CallableMemberDescriptor $this$findSourceFile) {
        SourceFile sourceFile;
        Intrinsics.checkNotNullParameter((Object)$this$findSourceFile, (String)"<this>");
        SourceFile sourceFile2 = $this$findSourceFile.getSource().getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)sourceFile2, (String)"this.source.containingFile");
        SourceFile source = sourceFile2;
        if (!Intrinsics.areEqual((Object)source, (Object)SourceFile.NO_SOURCE_FILE)) {
            return source;
        }
        if ($this$findSourceFile instanceof DeserializedSimpleFunctionDescriptor && ((DeserializedSimpleFunctionDescriptor)$this$findSourceFile).getProto().hasExtension(KlibMetadataProtoBuf.functionFile)) {
            Integer n = ((DeserializedSimpleFunctionDescriptor)$this$findSourceFile).getProto().getExtension(KlibMetadataProtoBuf.functionFile);
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"proto.getExtension(KlibM\u2026ataProtoBuf.functionFile)");
            sourceFile = LegacyDescriptorUtilsKt.sourceByIndex($this$findSourceFile, ((Number)n).intValue());
        } else if ($this$findSourceFile instanceof DeserializedPropertyDescriptor && ((DeserializedPropertyDescriptor)$this$findSourceFile).getProto().hasExtension(KlibMetadataProtoBuf.propertyFile)) {
            Integer n = ((DeserializedPropertyDescriptor)$this$findSourceFile).getProto().getExtension(KlibMetadataProtoBuf.propertyFile);
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"proto.getExtension(KlibM\u2026ataProtoBuf.propertyFile)");
            sourceFile = LegacyDescriptorUtilsKt.sourceByIndex($this$findSourceFile, ((Number)n).intValue());
        } else {
            throw new NotImplementedError(null, 1, null);
        }
        return sourceFile;
    }

    @Nullable
    public static final String extractSerializedKdocString(@NotNull DeclarationDescriptor $this$extractSerializedKdocString) {
        Intrinsics.checkNotNullParameter((Object)$this$extractSerializedKdocString, (String)"<this>");
        DeclarationDescriptor declarationDescriptor = $this$extractSerializedKdocString;
        return declarationDescriptor instanceof DeserializedClassDescriptor ? ((DeserializedClassDescriptor)$this$extractSerializedKdocString).getClassProto().getExtension(KlibMetadataProtoBuf.classKdoc) : (declarationDescriptor instanceof DeserializedSimpleFunctionDescriptor ? ((DeserializedSimpleFunctionDescriptor)$this$extractSerializedKdocString).getProto().getExtension(KlibMetadataProtoBuf.functionKdoc) : (declarationDescriptor instanceof DeserializedPropertyDescriptor ? ((DeserializedPropertyDescriptor)$this$extractSerializedKdocString).getProto().getExtension(KlibMetadataProtoBuf.propertyKdoc) : (declarationDescriptor instanceof DeserializedClassConstructorDescriptor ? ((DeserializedClassConstructorDescriptor)$this$extractSerializedKdocString).getProto().getExtension(KlibMetadataProtoBuf.constructorKdoc) : null)));
    }
}

