/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt.util;

import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.javacs.kt.LoggerKt;
import org.javacs.kt.util.DebouncerKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J/\u0010\u000b\u001a\u00020\f2'\u0010\r\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\f0\u000eJ\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0010J/\u0010\u0016\u001a\u00020\f2'\u0010\r\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\f0\u000eJ\u0006\u0010\u0017\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/javacs/kt/util/Debouncer;", "", "delay", "Ljava/time/Duration;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "(Ljava/time/Duration;Ljava/util/concurrent/ScheduledExecutorService;)V", "delayMs", "", "pendingTask", "Ljava/util/concurrent/Future;", "schedule", "", "task", "Lkotlin/Function1;", "Lkotlin/Function0;", "", "Lkotlin/ParameterName;", "name", "cancelCallback", "shutdown", "awaitTermination", "submitImmediately", "waitForPendingTask", "shared"})
public final class Debouncer {
    @NotNull
    private final Duration delay;
    @NotNull
    private final ScheduledExecutorService executor;
    private final long delayMs;
    @Nullable
    private Future<?> pendingTask;

    public Debouncer(@NotNull Duration delay, @NotNull ScheduledExecutorService executor) {
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.delay = delay;
        this.executor = executor;
        this.delayMs = this.delay.toMillis();
    }

    public /* synthetic */ Debouncer(Duration duration, ScheduledExecutorService scheduledExecutorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ScheduledExecutorService scheduledExecutorService2 = Executors.newScheduledThreadPool(1, Debouncer::_init_$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService2, (String)"newScheduledThreadPool(...)");
            scheduledExecutorService = scheduledExecutorService2;
        }
        this(duration, scheduledExecutorService);
    }

    public final void submitImmediately(@NotNull Function1<? super Function0<Boolean>, Unit> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        Future<?> future = this.pendingTask;
        if (future != null) {
            future.cancel(false);
        }
        AtomicReference currentTaskRef = new AtomicReference();
        Future<?> currentTask2 = this.executor.submit(() -> Debouncer.submitImmediately$lambda$1(task, currentTaskRef));
        currentTaskRef.set(currentTask2);
        this.pendingTask = currentTask2;
    }

    public final void schedule(@NotNull Function1<? super Function0<Boolean>, Unit> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        Future<?> future = this.pendingTask;
        if (future != null) {
            future.cancel(false);
        }
        AtomicReference currentTaskRef = new AtomicReference();
        ScheduledFuture<?> currentTask2 = this.executor.schedule(() -> Debouncer.schedule$lambda$2(task, currentTaskRef), this.delayMs, TimeUnit.MILLISECONDS);
        currentTaskRef.set(currentTask2);
        this.pendingTask = currentTask2;
    }

    public final void waitForPendingTask() {
        block0: {
            Future<?> future = this.pendingTask;
            if (future == null) break block0;
            future.get();
        }
    }

    public final void shutdown(boolean awaitTermination) {
        this.executor.shutdown();
        if (awaitTermination) {
            LoggerKt.getLOG().info("Awaiting debouncer termination...", new Object[0]);
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
    }

    private static final Thread _init_$lambda$0(Runnable it) {
        int n = DebouncerKt.access$getThreadCount$p();
        DebouncerKt.access$setThreadCount$p(n + 1);
        return new Thread(it, "debounce" + n);
    }

    private static final void submitImmediately$lambda$1(Function1 $task, AtomicReference $currentTaskRef) {
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        Intrinsics.checkNotNullParameter((Object)$currentTaskRef, (String)"$currentTaskRef");
        $task.invoke((Object)new Function0<Boolean>($currentTaskRef){
            final /* synthetic */ AtomicReference<Future<?>> $currentTaskRef;
            {
                this.$currentTaskRef = $currentTaskRef;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Future<?> future = this.$currentTaskRef.get();
                return future != null ? future.isCancelled() : false;
            }
        });
    }

    private static final void schedule$lambda$2(Function1 $task, AtomicReference $currentTaskRef) {
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        Intrinsics.checkNotNullParameter((Object)$currentTaskRef, (String)"$currentTaskRef");
        $task.invoke((Object)new Function0<Boolean>($currentTaskRef){
            final /* synthetic */ AtomicReference<Future<?>> $currentTaskRef;
            {
                this.$currentTaskRef = $currentTaskRef;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Future<?> future = this.$currentTaskRef.get();
                return future != null ? future.isCancelled() : false;
            }
        });
    }
}

