/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.util.List;
import java.util.Optional;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.NodeValidator;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.reflect.validation.Severity;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationProblem;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.gradle.internal.reflect.validation.UserManualReference;

public class DefaultNodeValidator
implements NodeValidator {
    @Override
    public boolean hasValidationProblems(LocalTaskNode node) {
        WorkValidationContext validationContext = node.getValidationContext();
        Class taskType = GeneratedSubclasses.unpackType((Object)node.getTask());
        TypeValidationContext taskValidationContext = validationContext.forType(taskType, false);
        node.getTaskProperties().validateType(taskValidationContext);
        List problems = validationContext.getProblems();
        problems.stream().filter(problem -> ((Severity)problem.getSeverity()).isWarning()).forEach(problem -> {
            Optional userManualReference = problem.getUserManualReference();
            String docId = "more_about_tasks";
            String section = "sec:up_to_date_checks";
            if (userManualReference.isPresent()) {
                UserManualReference docref = (UserManualReference)userManualReference.get();
                docId = docref.getId();
                section = docref.getSection();
            }
            String warning = TypeValidationProblemRenderer.convertToSingleLine((String)TypeValidationProblemRenderer.renderMinimalInformationAbout((TypeValidationProblem)problem, (boolean)false, (boolean)false));
            ((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour((String)warning).withContext("Execution optimizations are disabled to ensure correctness.")).willBeRemovedInGradle8().withUserManual(docId, section).nagUser();
        });
        return !problems.isEmpty();
    }
}

