# lua-language-server

![build](https://img.shields.io/github/actions/workflow/status/LuaLS/lua-language-server/.github%2Fworkflows%2Fbuild.yml)
![Version (including pre-releases)](https://img.shields.io/visual-studio-marketplace/v/sumneko.lua)
![Installs](https://img.shields.io/visual-studio-marketplace/i/sumneko.lua)
![Downloads](https://img.shields.io/visual-studio-marketplace/d/sumneko.lua)


***Lua development just got a whole lot better*** 🧠

The Lua language server provides various language features for Lua to make development easier and faster. With nearly a million installs in Visual Studio Code, it is the most popular extension for Lua language support.

[See our website for more info](https://luals.github.io).

## Features

- ⚙️ Supports `Lua 5.5`, `Lua 5.4`, `Lua 5.3`, `Lua 5.2`, `Lua 5.1`, and `LuaJIT`
- 📄 Over 20 supported [annotations](https://luals.github.io/wiki/annotations/) for documenting your code
- ↪ Go to definition
- 🦺 Dynamic [type checking](https://luals.github.io/wiki/type-checking/)
- 🔍 Find references
- ⚠️ [Diagnostics/Warnings](https://luals.github.io/wiki/diagnostics/)
- 🕵️ [Syntax checking](https://luals.github.io/wiki/syntax-errors/)
- 📝 Element renaming
- 🗨️ Hover to view details on variables, functions, and more
- 🖊️ Autocompletion
- 📚 Support for [libraries](https://luals.github.io/wiki/settings/#workspacelibrary)
- 💅 [Code formatting](https://luals.github.io/wiki/formatter/)
- 💬 [Spell checking](https://luals.github.io/wiki/diagnostics/#spell-check)
- 🛠️ Custom [plugins](https://luals.github.io/wiki/plugins/)
- 📖 [Documentation Generation](https://luals.github.io/wiki/export-docs/)

## Install
The language server can be installed for use in Visual Studio Code, NeoVim, and any [other clients](https://microsoft.github.io/language-server-protocol/implementors/tools/) that support the [Language Server Protocol](https://microsoft.github.io/language-server-protocol/).

See [installation instructions on our website](https://luals.github.io/#install).

[![Install in VS Code](https://img.shields.io/badge/VS%20Code-Install-blue?style=for-the-badge&logo=visualstudiocode "Install in VS Code")](https://luals.github.io/#vscode-install)
[![Install for NeoVim](https://img.shields.io/badge/NeoVim-Install-blue?style=for-the-badge&logo=neovim "Install for NeoVim")](https://luals.github.io/#neovim-install)
[![Other](https://img.shields.io/badge/Other-Install-blue?style=for-the-badge&logo=windowsterminal "Install for command line")](https://luals.github.io/#other-install)

### Community Install Methods
The install methods below are maintained by community members.

[asdf plugin](https://github.com/bellini666/asdf-lua-language-server)

## Links
- [Changelog](https://github.com/LuaLS/lua-language-server/blob/master/changelog.md)
- [Wiki](https://luals.github.io/wiki)
- [FAQ](https://luals.github.io/wiki/faq)
- [Report an issue][issues]
- [Suggest a feature][issues]
- [Discuss](https://github.com/LuaLS/lua-language-server/discussions)

> If you find any mistakes, please [report it][issues] or open a [pull request][pulls] if you have a fix of your own ❤️
>
> 如果你发现了任何错误，请[告诉我][issues]或使用[Pull Requests][pulls]来直接修复。❤️

[issues]: https://github.com/LuaLS/lua-language-server/issues
[pulls]: https://github.com/LuaLS/lua-language-server/pulls

## Available Languages

- `en-us` 🇺🇸
- `zh-cn` 🇨🇳
- `zh-tw` 🇹🇼
- `pt-br` 🇧🇷
- `ja-jp` 🇯🇵
- `es-419` 🇪🇸


> **Note**
> All translations are provided and collaborated on by the community. If you find an inappropriate or harmful translation, [please report it immediately](https://github.com/LuaLS/lua-language-server/issues).

Are you able to [provide a translation](https://luals.github.io/wiki/translations)? It would be greatly appreciated!

Thank you to [all contributors of translations](https://github.com/LuaLS/lua-language-server/commits/master/locale)!


## Privacy
The language server had **opt-in** telemetry that collected usage data and sent it to the development team to help improve the extension. Read our [privacy policy](https://luals.github.io/privacy#language-server) to learn more. Telemetry was removed in `v3.6.5` and is no longer part of the language server.


## Contributors
![GitHub Contributors Image](https://contrib.rocks/image?repo=sumneko/lua-language-server)

## Credit
Software that the language server (or the development of it) uses:

* [bee.lua](https://github.com/actboy168/bee.lua)
* [luamake](https://github.com/actboy168/luamake)
* [LPegLabel](https://github.com/sqmedeiros/lpeglabel)
* [LuaParser](https://github.com/LuaLS/LuaParser)
* [ScreenToGif](https://github.com/NickeManarin/ScreenToGif)
* [vscode-languageclient](https://github.com/microsoft/vscode-languageserver-node)
* [lua.tmbundle](https://github.com/textmate/lua.tmbundle)
* [EmmyLua](https://emmylua.github.io)
* [lua-glob](https://github.com/LuaLS/lua-glob)
* [utility](https://github.com/LuaLS/utility)
* [vscode-lua-doc](https://github.com/actboy168/vscode-lua-doc)
* [json.lua](https://github.com/actboy168/json.lua)
* [EmmyLuaCodeStyle](https://github.com/CppCXY/EmmyLuaCodeStyle)
* [inspect.lua](https://github.com/kikito/inspect.lua)
