/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cli.profile.commands;

import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import io.micronaut.cli.config.CodeGenConfig;
import io.micronaut.cli.config.ConfigMap;
import io.micronaut.cli.console.logging.MicronautConsole;
import io.micronaut.cli.profile.Command;
import io.micronaut.cli.profile.ExecutionContext;
import io.micronaut.cli.profile.Feature;
import io.micronaut.cli.profile.Profile;
import io.micronaut.cli.profile.ProfileRepository;
import io.micronaut.cli.profile.ProfileRepositoryAware;
import io.micronaut.cli.profile.ProjectContext;
import io.micronaut.cli.profile.commands.ArgumentCompletingCommand;
import io.micronaut.cli.profile.commands.CommonOptionsMixin;
import io.micronaut.cli.profile.commands.ProfileCompletionCandidates;
import java.io.File;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import picocli.CommandLine;

@CommandLine.Command(name="profile-info", description={"Display information about a given profile"})
public class ProfileInfoCommand
extends ArgumentCompletingCommand
implements ProfileRepositoryAware {
    public static final String NAME = "profile-info";
    private final String name;
    @CommandLine.Parameters(arity="1", completionCandidates=ProfileCompletionCandidates.class, paramLabel="PROFILE-NAME", description={"The name or coordinates of the profile"})
    private String profileName;
    @CommandLine.Option(paramLabel="ENHANCED-INFO", names={"-e", "--enhancedInfo"}, description={"Display additional information about what is included in a profile."})
    private boolean enhancedInfo;
    @CommandLine.Mixin
    private CommonOptionsMixin commonOptionsMixin;
    private ProfileRepository profileRepository;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public ProfileInfoCommand() {
        MetaClass metaClass;
        String string;
        this.name = string = NAME;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    @CommandLine.Spec
    public void setCommandSpec(CommandLine.Model.CommandSpec commandSpec) {
        super.setCommandSpec(commandSpec);
        ProfileCompletionCandidates.updateCommandArguments(commandSpec, this.profileRepository);
    }

    @Override
    public void setProfileRepository(ProfileRepository profileRepository) {
        ProfileRepository profileRepository2;
        this.profileRepository = profileRepository2 = profileRepository;
    }

    @Override
    public boolean handle(ExecutionContext executionContext) {
        Reference<MicronautConsole> console = new Reference<MicronautConsole>(executionContext.getConsole());
        if (this.profileRepository == null) {
            console.get().error("No profile repository provided");
            return false;
        }
        Profile profile = this.profileRepository.getProfile(this.profileName);
        if (profile == null) {
            console.get().error(ShortTypeHandling.castToString(new GStringImpl(new Object[]{this.profileName}, new String[]{"Profile not found for name [", "]"})));
        } else {
            console.get().addStatus(ShortTypeHandling.castToString(new GStringImpl(new Object[]{profile.getName()}, new String[]{"Profile: ", ""})));
            console.get().log("--------------------");
            console.get().log(profile.getDescription());
            console.get().log("");
            List<Feature> defaultFeaturesList = DefaultGroovyMethods.toList(profile.getDefaultFeatures());
            List<Feature> requiredFeaturesList = DefaultGroovyMethods.toList(profile.getRequiredFeatures());
            if (this.enhancedInfo) {
                if (DefaultTypeTransformation.booleanUnbox(defaultFeaturesList)) {
                    console.get().addStatus("Default Features:");
                    console.get().log("--------------------");
                    public final class _handle_closure1
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference console;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _handle_closure1(Object _outerInstance, Object _thisObject, Reference console) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.console = reference = console;
                        }

                        public Object doCall(Object it) {
                            ((MicronautConsole)this.console.get()).log(ShortTypeHandling.castToString(new GStringImpl(new Object[]{((Feature)it).getName()}, new String[]{"  ", ""})));
                            return null;
                        }

                        public Object getConsole() {
                            return this.console.get();
                        }

                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        @Override
                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (this.getClass() != _handle_closure1.class) {
                                return ScriptBytecodeAdapter.initMetaClass(this);
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    DefaultGroovyMethods.each(defaultFeaturesList, (Closure)new _handle_closure1(this, this, console));
                    console.get().log("");
                }
                if (DefaultTypeTransformation.booleanUnbox(requiredFeaturesList)) {
                    console.get().addStatus("Required Features:");
                    console.get().log("--------------------");
                    public final class _handle_closure2
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference console;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _handle_closure2(Object _outerInstance, Object _thisObject, Reference console) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.console = reference = console;
                        }

                        public Object doCall(Object it) {
                            ((MicronautConsole)this.console.get()).log(ShortTypeHandling.castToString(new GStringImpl(new Object[]{((Feature)it).getName()}, new String[]{"  ", ""})));
                            return null;
                        }

                        public Object getConsole() {
                            return this.console.get();
                        }

                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        @Override
                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (this.getClass() != _handle_closure2.class) {
                                return ScriptBytecodeAdapter.initMetaClass(this);
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    DefaultGroovyMethods.each(requiredFeaturesList, (Closure)new _handle_closure2(this, this, console));
                    console.get().log("");
                }
            }
            console.get().addStatus("Provided Commands:");
            console.get().log("--------------------");
            public final class _handle_closure3
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _handle_closure3(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Command c) {
                    return c.getName();
                }

                public Object call(Command c) {
                    return this.doCall(c);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != _handle_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            public final class _handle_closure4
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _handle_closure4(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ((Command)it).getName();
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Override
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != _handle_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            List<Command> commands = DefaultGroovyMethods.sort(DefaultGroovyMethods.toUnique(this.findCommands(profile, console.get()), (Closure)new _handle_closure3(this, this)), (Closure)new _handle_closure4(this, this));
            if (!commands.isEmpty()) {
                public final class _handle_closure5
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _handle_closure5(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ((Command)it).getName();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Override
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _handle_closure5.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                public final class _handle_closure6
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _handle_closure6(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ((String)it).length();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Override
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _handle_closure6.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                int padding = ((String)DefaultGroovyMethods.max(DefaultGroovyMethods.collect(commands, new _handle_closure5(this, this)), (Closure)new _handle_closure6(this, this))).length();
                public final class _handle_closure7
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _handle_closure7(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ((Command)it).getName();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Override
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _handle_closure7.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                public final class _handle_closure8
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _handle_closure8(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ((String)it).length();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Override
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _handle_closure8.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                int width = Math.min(padding, ((String)DefaultGroovyMethods.last(DefaultGroovyMethods.sort(DefaultGroovyMethods.collect(commands, new _handle_closure7(this, this)), (Closure)new _handle_closure8(this, this)))).length());
                String separator = StringGroovyMethods.padRight((CharSequence)String.format("%n", new Object[0]), (Number)width);
                Command cmd2 = null;
                for (Command cmd2 : commands) {
                    String[] stringArray;
                    CommandLine.Model.CommandSpec spec = cmd2.getCommandSpec();
                    console.get().log(ShortTypeHandling.castToString(new GStringImpl(new Object[]{StringGroovyMethods.padRight((CharSequence)spec.name(), (Number)width), (stringArray = spec.usageMessage().description()) != null ? DefaultGroovyMethods.join((Object[])ScriptBytecodeAdapter.castToType(stringArray, Object[].class), separator) : null}, new String[]{"  ", "  ", ""})));
                }
            }
            console.get().log("");
            console.get().addStatus("Provided Features:");
            console.get().addStatus("(+) denotes features included by default.");
            console.get().log("--------------------");
            public final class _handle_closure9
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _handle_closure9(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ((Feature)it).getName();
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Override
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != _handle_closure9.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            List<Feature> features = DefaultGroovyMethods.sort(profile.getFeatures(), (Closure)new _handle_closure9(this, this));
            if (!features.isEmpty()) {
                public final class _handle_closure10
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _handle_closure10(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ((Feature)it).getName();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Override
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _handle_closure10.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                public final class _handle_closure11
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _handle_closure11(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ((String)it).length();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Override
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _handle_closure11.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                int padding = ((String)DefaultGroovyMethods.max(DefaultGroovyMethods.collect(features, new _handle_closure10(this, this)), (Closure)new _handle_closure11(this, this))).length();
                public final class _handle_closure12
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _handle_closure12(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ((Feature)it).getName();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Override
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _handle_closure12.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                public final class _handle_closure13
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _handle_closure13(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ((String)it).length();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Override
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _handle_closure13.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                int width = Math.min(padding, ((String)DefaultGroovyMethods.last(DefaultGroovyMethods.sort(DefaultGroovyMethods.collect(features, new _handle_closure12(this, this)), (Closure)new _handle_closure13(this, this)))).length());
                Feature feature2 = null;
                for (Feature feature2 : features) {
                    if (defaultFeaturesList.contains(feature2) || requiredFeaturesList.contains(feature2)) {
                        String fname = StringGroovyMethods.plus(feature2.getName(), (CharSequence)" (+)");
                        console.get().log(ShortTypeHandling.castToString(new GStringImpl(new Object[]{StringGroovyMethods.padRight((CharSequence)fname, (Number)width), feature2.getDescription()}, new String[]{"\u001b[1m  ", "  ", "\u001b[0m"})));
                        if (!this.enhancedInfo) continue;
                        Iterable<Feature> dependentFeatures = feature2.getDependentFeatures(profile);
                        if (DefaultGroovyMethods.size(dependentFeatures) > 0) {
                            console.get().log("\u001b[1m       Dependent features:");
                            public final class _handle_closure14
                            extends Closure
                            implements GeneratedClosure {
                                private /* synthetic */ Reference console;
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _handle_closure14(Object _outerInstance, Object _thisObject, Reference console) {
                                    super(_outerInstance, _thisObject);
                                    Reference reference;
                                    this.console = reference = console;
                                }

                                public Object doCall(Object it) {
                                    ((MicronautConsole)this.console.get()).log(ShortTypeHandling.castToString(new GStringImpl(new Object[]{((Feature)it).getName()}, new String[]{"                            ", " (+)"})));
                                    return null;
                                }

                                public Object getConsole() {
                                    return this.console.get();
                                }

                                public Object call(Object args) {
                                    return this.doCall(args);
                                }

                                @Override
                                public Object call() {
                                    return this.doCall(null);
                                }

                                @Generated
                                public Object doCall() {
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (this.getClass() != _handle_closure14.class) {
                                        return ScriptBytecodeAdapter.initMetaClass(this);
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }
                            }
                            DefaultGroovyMethods.each(dependentFeatures, (Closure)new _handle_closure14(this, this, console));
                            console.get().log("\u001b[0m  ------------------");
                        }
                        Iterable<String> evictedFeatures = feature2.getEvictedFeatureNames();
                        if (DefaultGroovyMethods.size(evictedFeatures) > 0) {
                            console.get().log("\u001b[1m       Evicted features:");
                            public final class _handle_closure15
                            extends Closure
                            implements GeneratedClosure {
                                private /* synthetic */ Reference console;
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _handle_closure15(Object _outerInstance, Object _thisObject, Reference console) {
                                    super(_outerInstance, _thisObject);
                                    Reference reference;
                                    this.console = reference = console;
                                }

                                public Object doCall(Object it) {
                                    ((MicronautConsole)this.console.get()).log(ShortTypeHandling.castToString(new GStringImpl(new Object[]{it}, new String[]{"                            ", " (-)"})));
                                    return null;
                                }

                                public Object getConsole() {
                                    return this.console.get();
                                }

                                public Object call(Object args) {
                                    return this.doCall(args);
                                }

                                @Override
                                public Object call() {
                                    return this.doCall(null);
                                }

                                @Generated
                                public Object doCall() {
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (this.getClass() != _handle_closure15.class) {
                                        return ScriptBytecodeAdapter.initMetaClass(this);
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }
                            }
                            DefaultGroovyMethods.each(evictedFeatures, (Closure)new _handle_closure15(this, this, console));
                            console.get().log("\u001b[0m  ------------------");
                        }
                        Iterable<Feature> defaultFeatures = feature2.getDefaultFeatures(profile);
                        if (!(DefaultGroovyMethods.size(defaultFeatures) > 0)) continue;
                        console.get().log("\u001b[1m       Default features:");
                        public final class _handle_closure16
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference console;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _handle_closure16(Object _outerInstance, Object _thisObject, Reference console) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.console = reference = console;
                            }

                            public Object doCall(Object it) {
                                ((MicronautConsole)this.console.get()).log(ShortTypeHandling.castToString(new GStringImpl(new Object[]{((Feature)it).getName()}, new String[]{"                            ", " (+)"})));
                                return null;
                            }

                            public Object getConsole() {
                                return this.console.get();
                            }

                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            @Override
                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (this.getClass() != _handle_closure16.class) {
                                    return ScriptBytecodeAdapter.initMetaClass(this);
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        DefaultGroovyMethods.each(defaultFeatures, (Closure)new _handle_closure16(this, this, console));
                        console.get().log("\u001b[0m  ------------------");
                        continue;
                    }
                    console.get().log(ShortTypeHandling.castToString(new GStringImpl(new Object[]{StringGroovyMethods.padRight((CharSequence)feature2.getName(), (Number)width), feature2.getDescription()}, new String[]{"  ", "  ", ""})));
                    if (!this.enhancedInfo) continue;
                    Iterable<Feature> dependentFeatures = feature2.getDependentFeatures(profile);
                    if (DefaultGroovyMethods.size(dependentFeatures) > 0) {
                        console.get().log("       Dependent features:");
                        public final class _handle_closure17
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference console;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _handle_closure17(Object _outerInstance, Object _thisObject, Reference console) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.console = reference = console;
                            }

                            public Object doCall(Object it) {
                                ((MicronautConsole)this.console.get()).log(ShortTypeHandling.castToString(new GStringImpl(new Object[]{((Feature)it).getName()}, new String[]{"                            ", ""})));
                                return null;
                            }

                            public Object getConsole() {
                                return this.console.get();
                            }

                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            @Override
                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (this.getClass() != _handle_closure17.class) {
                                    return ScriptBytecodeAdapter.initMetaClass(this);
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        DefaultGroovyMethods.each(dependentFeatures, (Closure)new _handle_closure17(this, this, console));
                        console.get().log("  ------------------");
                    }
                    Iterable<String> evictedFeatures = feature2.getEvictedFeatureNames();
                    if (DefaultGroovyMethods.size(evictedFeatures) > 0) {
                        console.get().log("       Evicted features:");
                        public final class _handle_closure18
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference console;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _handle_closure18(Object _outerInstance, Object _thisObject, Reference console) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.console = reference = console;
                            }

                            public Object doCall(Object it) {
                                ((MicronautConsole)this.console.get()).log(ShortTypeHandling.castToString(new GStringImpl(new Object[]{it}, new String[]{"                            ", ""})));
                                return null;
                            }

                            public Object getConsole() {
                                return this.console.get();
                            }

                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            @Override
                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (this.getClass() != _handle_closure18.class) {
                                    return ScriptBytecodeAdapter.initMetaClass(this);
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        DefaultGroovyMethods.each(evictedFeatures, (Closure)new _handle_closure18(this, this, console));
                        console.get().log("  ------------------");
                    }
                    Iterable<Feature> defaultFeatures = feature2.getDefaultFeatures(profile);
                    if (!(DefaultGroovyMethods.size(defaultFeatures) > 0)) continue;
                    console.get().log("       Default features:");
                    public final class _handle_closure19
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference console;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _handle_closure19(Object _outerInstance, Object _thisObject, Reference console) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.console = reference = console;
                        }

                        public Object doCall(Object it) {
                            ((MicronautConsole)this.console.get()).log(ShortTypeHandling.castToString(new GStringImpl(new Object[]{((Feature)it).getName()}, new String[]{"                            ", ""})));
                            return null;
                        }

                        public Object getConsole() {
                            return this.console.get();
                        }

                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        @Override
                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (this.getClass() != _handle_closure19.class) {
                                return ScriptBytecodeAdapter.initMetaClass(this);
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    DefaultGroovyMethods.each(defaultFeatures, (Closure)new _handle_closure19(this, this, console));
                    console.get().log("  ------------------");
                }
            }
        }
        return true;
    }

    public Iterable<Command> findCommands(Profile profile, MicronautConsole console) {
        Reference<MicronautConsole> console2 = new Reference<MicronautConsole>(console);
        Iterable<Command> commands = profile.getCommands(new ProjectContext(this, console2){
            public /* synthetic */ Reference console;
            public /* synthetic */ ProfileInfoCommand this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                Reference reference;
                ProfileInfoCommand profileInfoCommand;
                this.this$0 = profileInfoCommand = p0;
                this.console = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public MicronautConsole getConsole() {
                return (MicronautConsole)ScriptBytecodeAdapter.castToType(this.console.get(), MicronautConsole.class);
            }

            @Override
            public File getBaseDir() {
                return new File(".");
            }

            @Override
            public ConfigMap getConfig() {
                return new CodeGenConfig();
            }

            @Override
            public String navigateConfig(String ... path) {
                return ShortTypeHandling.castToString(this.getConfig().navigate(path));
            }

            @Override
            public <T> T navigateConfigForType(Class<T> requiredType, String ... path) {
                return (T)this.getConfig().navigate(path);
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$2(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(1.class, ProfileInfoCommand.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                this.this$0.this$dist$set$2(name, val);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty(object, null, ProfileInfoCommand.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$2(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(1.class, ProfileInfoCommand.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Override
            @Generated
            @Internal
            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Override
            @Generated
            @Internal
            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            @Override
            @Generated
            @Internal
            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            @Override
            @Generated
            @Internal
            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty(this, string);
            }

            @Override
            @Generated
            @Internal
            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty(this, string, object);
            }
        });
        return commands;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ProfileInfoCommand.class) {
            return ScriptBytecodeAdapter.initMetaClass(this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ProfileInfoCommand.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty(object, ProfileInfoCommand.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ProfileInfoCommand.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Override
    @Generated
    public final String getName() {
        return this.name;
    }

    @Generated
    public String getProfileName() {
        return this.profileName;
    }

    @Generated
    public void setProfileName(String string) {
        this.profileName = string;
    }

    @Generated
    public boolean getEnhancedInfo() {
        return this.enhancedInfo;
    }

    @Generated
    public boolean isEnhancedInfo() {
        return this.enhancedInfo;
    }

    @Generated
    public void setEnhancedInfo(boolean bl) {
        this.enhancedInfo = bl;
    }

    @Generated
    public CommonOptionsMixin getCommonOptionsMixin() {
        return this.commonOptionsMixin;
    }

    @Generated
    public void setCommonOptionsMixin(CommonOptionsMixin commonOptionsMixin) {
        this.commonOptionsMixin = commonOptionsMixin;
    }

    @Generated
    public ProfileRepository getProfileRepository() {
        return this.profileRepository;
    }
}

