/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.ant;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.io.Reader;
import java.math.BigDecimal;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.types.selectors.SelectSelector;
import org.apache.tools.ant.types.selectors.TypeSelector;

public class JUnitTestReportAggregator
extends MatchingTask {
    private String commonTest = "Common Tests";
    private File srcdir = null;
    private File destdir = null;
    DirSet dirset = new DirSet();

    public void setsrcdir(File d) {
        this.srcdir = d;
    }

    public void setdestdir(File d) {
        this.destdir = d;
    }

    public String getcommonTest() {
        return this.commonTest;
    }

    public void setcommonTest(String commonTest) {
        this.commonTest = commonTest;
    }

    public void execute() throws BuildException {
        PrintWriter pw;
        this.log("Begin of JUnitTestReportAggregator task ", 4);
        if (this.srcdir == null) {
            throw new BuildException("'srcdir' parameter is not defined in the task JUnitTestReportAggregator");
        }
        this.log("Source dir=" + this.srcdir, 4);
        if (this.destdir == null) {
            this.log("no dest dir, use the src dir", 4);
            this.destdir = this.srcdir;
        }
        this.log("Dest dir=" + this.destdir, 4);
        TypeSelector ts = new TypeSelector();
        TypeSelector.FileType type = new TypeSelector.FileType();
        type.setValue("dir");
        ts.setType(type);
        SelectSelector ss = new SelectSelector();
        ss.appendSelector((FileSelector)ts);
        super.addSelector(ss);
        String[] in_files = super.getDirectoryScanner(this.srcdir).getIncludedFiles();
        if (in_files == null || in_files.length == 0) {
            super.createInclude().setName("**");
            in_files = super.getDirectoryScanner(this.srcdir).getIncludedFiles();
        }
        TestInfo[] infos = new TestInfo[in_files.length + 1];
        infos[in_files.length] = new TestInfo();
        infos[in_files.length].time = new BigDecimal(0.0);
        infos[in_files.length].time.setScale(3, 3);
        for (int i = 0; i < in_files.length; ++i) {
            this.log("Extract info from " + in_files[i], 4);
            infos[i] = this.extractInfos(in_files[i]);
            infos[in_files.length].nbTests += infos[i].nbTests;
            infos[in_files.length].nbErrors += infos[i].nbErrors;
            infos[in_files.length].nbFailures += infos[i].nbFailures;
            infos[in_files.length].time = infos[in_files.length].time.add(infos[i].time);
            if (infos[i].parsingOK) continue;
            this.log("Parsing of " + in_files[i] + " failed", 1);
        }
        File destfile = new File(this.destdir, "index.html");
        this.log("Creating the file " + destfile, 2);
        try {
            pw = new PrintWriter(new FileOutputStream(destfile));
        }
        catch (FileNotFoundException e) {
            this.log(e.getMessage(), 0);
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        this.log("Writing HTML code", 4);
        this.printHeader(pw);
        pw.println("<tr valign=\"top\" class=\"Pass\">");
        pw.println("<td>" + infos[in_files.length].nbTests + "</td><td>" + infos[in_files.length].nbFailures + "</td><td>" + infos[in_files.length].nbErrors + "</td><td>" + infos[in_files.length].getRate() + "%</td><td>" + infos[in_files.length].time.toString() + "</td>");
        pw.println("</tr>");
        this.printMiddle(pw);
        for (int i = 0; i < in_files.length; ++i) {
            pw.println("<tr valign=\"top\" class=\"Pass\">");
            if (infos[i].parsingOK) {
                pw.println("<td><a href=\"" + this.srcdir + File.separator + infos[i].indexhtml + "\">" + infos[i].testName + "</a></td><td>" + infos[i].nbTests + "</td><td>" + infos[i].nbErrors + "</td><td>" + infos[i].nbFailures + "</td><td>" + infos[i].time.toString() + "</td>");
            } else {
                pw.println("<td colspan=\"4\">Parsing of <a href=\"" + this.srcdir + File.separator + infos[i].indexhtml + "\">" + infos[i].indexhtml + "</a> failed");
            }
            pw.println("</tr>");
        }
        this.printTrailer(pw);
        pw.flush();
        pw.close();
        this.log("End of JUnitTestReportAggregator task", 4);
    }

    private TestInfo extractInfos(String fn) {
        TestInfo res = new TestInfo();
        res.testName = fn.length() == 0 || ".".equals(fn) ? this.commonTest : fn.replace('/', '.').replace('\\', '.');
        res.indexhtml = fn + File.separatorChar + "index.html";
        try {
            PushbackReader fr = new PushbackReader(new FileReader(this.srcdir + File.separator + fn), 10);
            this.locateNextString(fr, "<table");
            this.locateNextString(fr, "<table");
            this.locateNextString(fr, "<tr");
            this.locateNextString(fr, "<tr");
            this.locateNextString(fr, "<td>");
            res.nbTests = Integer.parseInt(this.getString2ClosingTag(fr));
            this.locateNextString(fr, "<td>");
            res.nbFailures = Integer.parseInt(this.getString2ClosingTag(fr));
            this.locateNextString(fr, "<td>");
            res.nbErrors = Integer.parseInt(this.getString2ClosingTag(fr));
            this.locateNextString(fr, "<td>");
            this.locateNextString(fr, "<td>");
            res.time = new BigDecimal(this.getString2ClosingTag(fr));
            res.time.setScale(3);
        }
        catch (FileNotFoundException e) {
            res.parsingOK = false;
        }
        catch (IOException e) {
            res.parsingOK = false;
        }
        return res;
    }

    private void locateNextString(PushbackReader fr, String s) throws IOException {
        int next = fr.read();
        char[] buf = null;
        while (next != -1) {
            if (next == s.charAt(0)) {
                int pos;
                if (buf == null) {
                    buf = new char[s.length() - 1];
                }
                int next2 = fr.read();
                for (pos = 1; next2 != -1 && pos < s.length(); ++pos) {
                    buf[pos - 1] = (char)next2;
                    if (next2 == s.charAt(pos)) {
                        next2 = fr.read();
                        continue;
                    }
                    fr.unread(buf, 0, pos);
                    break;
                }
                if (pos == s.length()) {
                    buf[0] = (char)next2;
                    fr.unread(buf, 0, 1);
                    return;
                }
            }
            next = fr.read();
        }
        throw new IOException("Wrong format in test result for JORM - string not found: " + s);
    }

    private String getString2ClosingTag(Reader fr) throws IOException {
        int next = fr.read();
        StringBuffer sb = new StringBuffer();
        while (next != -1 && next != 60) {
            sb.append((char)next);
            next = fr.read();
        }
        return sb.toString();
    }

    private void printHeader(PrintWriter pw) {
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=US-ASCII\">");
        pw.println("<title>Unit Test Results: Summary</title>");
        pw.println("<link title=\"Style\" type=\"text/css\" rel=\"stylesheet\" href=\"stylesheet.css\">");
        pw.println("</head>");
        pw.println("<body>");
        pw.println("<h1>JORM Unit Test Results</h1>");
        pw.println("<table width=\"100%\">");
        pw.println("<tr>");
        pw.println("<td align=\"left\"></td><td align=\"right\">Designed for use with <a href=\"http://www.junit.org/\">JUnit</a> and <a href=\"http://jakarta.apache.org/\">Ant</a>.</td>");
        pw.println("</tr>");
        pw.println("</table>");
        pw.println("<hr size=\"1\">");
        pw.println("<h2>Summary</h2>");
        pw.println("<table width=\"95%\" cellspacing=\"2\" cellpadding=\"5\" border=\"0\" class=\"details\">");
        pw.println("<tr valign=\"top\">");
        pw.println("<th>Tests</th><th>Failures</th><th>Errors</th><th>Success rate</th><th>Time</th>");
        pw.println("</tr>");
    }

    private void printMiddle(PrintWriter pw) {
        pw.println("</table>");
        pw.println("<table width=\"95%\" border=\"0\">");
        pw.println("<tr>");
        pw.println("<td style=\"text-align: justify;\">");
        pw.println("Note: <em>failures</em> are anticipated and checked for with assertions while <em>errors</em> are unanticipated.");
        pw.println("</td>");
        pw.println("</tr>");
        pw.println("</table>");
        pw.println("<h2>Tested area</h2>");
        pw.println("<table width=\"95%\" cellspacing=\"2\" cellpadding=\"5\" border=\"0\" class=\"details\">");
        pw.println("<tr valign=\"top\">");
        pw.println("<th width=\"80%\">Name</th><th>Tests</th><th>Errors</th><th>Failures</th><th nowrap=\"nowrap\">Time(s)</th>");
        pw.println("</tr>");
    }

    private void printTrailer(PrintWriter pw) {
        pw.println("</table>");
        pw.println("</body>");
        pw.println("</html>");
    }

    private static class TestInfo {
        public String indexhtml;
        public String testName;
        public int nbTests = 0;
        public int nbErrors = 0;
        public int nbFailures = 0;
        public BigDecimal time;
        public boolean parsingOK = true;

        private TestInfo() {
        }

        public BigDecimal getRate() {
            BigDecimal cent = new BigDecimal(100.0);
            BigDecimal rate = new BigDecimal((double)(this.nbErrors + this.nbFailures));
            rate.setScale(2);
            rate = rate.divide(new BigDecimal((double)this.nbTests), 2, 3);
            rate = cent.multiply(rate);
            rate = cent.subtract(rate);
            return rate;
        }
    }
}

