/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.creole.Neutron;
import net.sourceforge.plantuml.creole.NeutronType;
import net.sourceforge.plantuml.creole.Stripe;
import net.sourceforge.plantuml.creole.atom.AbstractAtom;
import net.sourceforge.plantuml.creole.atom.Atom;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class Fission {
    private final Stripe stripe;
    private final LineBreakStrategy maxWidth;

    public Fission(Stripe stripe, LineBreakStrategy maxWidth) {
        this.stripe = stripe;
        this.maxWidth = Objects.requireNonNull(maxWidth);
    }

    public List<Stripe> getSplitted(StringBounder stringBounder) {
        double valueMaxWidth = Math.abs(this.maxWidth.getMaxWidth());
        if (valueMaxWidth == 0.0) {
            return Arrays.asList(this.stripe);
        }
        ArrayList<StripeSimpleInternal> result = new ArrayList<StripeSimpleInternal>();
        StripeSimpleInternal line = new StripeSimpleInternal(false, stringBounder, this.stripe.getLHeader());
        result.add(line);
        ArrayDeque<Neutron> all = new ArrayDeque<Neutron>();
        for (Atom atom : this.noHeader()) {
            for (Neutron n : atom.getNeutrons()) {
                all.addLast(n);
            }
        }
        if (((Neutron)all.peekLast()).getType() != NeutronType.ZWSP_SEPARATOR) {
            all.addLast(Neutron.zwspSeparator());
        }
        while (all.size() > 0) {
            Neutron current = (Neutron)all.removeFirst();
            if (current.getType() == NeutronType.ZWSP_SEPARATOR && line.getWidth() > valueMaxWidth) {
                all.addFirst(current);
                List<Neutron> list = line.slightyShorten();
                for (int i = list.size() - 1; i >= 0; --i) {
                    all.addFirst(list.get(i));
                }
                line = new StripeSimpleInternal(true, stringBounder, Fission.blank(this.stripe.getLHeader()));
                result.add(line);
                continue;
            }
            line.addNeutron(current);
        }
        for (Stripe stripe : result) {
            ((StripeSimpleInternal)stripe).removeFinalSpaces();
        }
        while (result.size() > 1 && ((StripeSimpleInternal)result.get(result.size() - 1)).isWhite()) {
            result.remove(result.size() - 1);
        }
        return Collections.unmodifiableList(result);
    }

    private List<Atom> noHeader() {
        List<Atom> atoms = this.stripe.getAtoms();
        if (this.stripe.getLHeader() == null) {
            return atoms;
        }
        return atoms.subList(1, atoms.size());
    }

    private static Atom blank(final Atom header) {
        if (header == null) {
            return null;
        }
        return new AbstractAtom(){

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return header.calculateDimension(stringBounder);
            }

            @Override
            public double getStartingAltitude(StringBounder stringBounder) {
                return header.getStartingAltitude(stringBounder);
            }

            @Override
            public void drawU(UGraphic ug) {
            }
        };
    }

    static class StripeSimpleInternal
    implements Stripe {
        private final boolean removeInitialSpaces;
        private final Atom header;
        private final List<Neutron> neutrons = new ArrayList<Neutron>();
        private final StringBounder stringBounder;
        private double width;

        private StripeSimpleInternal(boolean removeInitialSpaces, StringBounder stringBounder, Atom header) {
            this.removeInitialSpaces = removeInitialSpaces;
            this.stringBounder = stringBounder;
            this.header = header;
            if (header != null) {
                this.width += header.calculateDimension(stringBounder).getWidth();
            }
        }

        public double getWidth() {
            if (this.width == -1.0) {
                throw new IllegalStateException();
            }
            return this.width;
        }

        public String toString() {
            if (this.header != null) {
                return this.header.toString() + " " + this.neutrons;
            }
            return this.neutrons.toString();
        }

        public List<Neutron> slightyShorten() {
            if (this.neutrons.size() == 0) {
                throw new IllegalStateException();
            }
            int lastZwsp = this.lastZwsp();
            if (lastZwsp == -1) {
                return Collections.emptyList();
            }
            this.width = -1.0;
            ArrayList<Neutron> removed = new ArrayList<Neutron>(this.neutrons.subList(lastZwsp, this.neutrons.size()));
            while (this.neutrons.size() > lastZwsp) {
                this.neutrons.remove(this.neutrons.size() - 1);
            }
            return removed;
        }

        private boolean isWhite() {
            for (Neutron n : this.neutrons) {
                if (n.getType() == NeutronType.ZWSP_SEPARATOR || n.getType() == NeutronType.SPACE) continue;
                return false;
            }
            return true;
        }

        private void removeFinalSpaces() {
            while (this.neutrons.size() > 0 && this.neutrons.get(0).getType() == NeutronType.ZWSP_SEPARATOR) {
                this.neutrons.remove(0);
            }
            while (this.neutrons.size() > 1 && (this.last().getType() == NeutronType.SPACE || this.last().getType() == NeutronType.ZWSP_SEPARATOR)) {
                this.neutrons.remove(this.neutrons.size() - 1);
            }
        }

        private Neutron last() {
            return this.neutrons.get(this.neutrons.size() - 1);
        }

        private int lastZwsp() {
            for (int i = this.neutrons.size() - 1; i >= 0; --i) {
                if (this.neutrons.get(i).getType() != NeutronType.ZWSP_SEPARATOR) continue;
                return i;
            }
            return -1;
        }

        @Override
        public List<Atom> getAtoms() {
            ArrayList<Atom> result = new ArrayList<Atom>();
            if (this.header != null) {
                result.add(this.header);
            }
            for (Neutron n : this.neutrons) {
                if (n.getType() == NeutronType.ZWSP_SEPARATOR || this.removeInitialSpaces && result.size() == 0 && n.getType() == NeutronType.SPACE) continue;
                result.add(n.asAtom());
            }
            return Collections.unmodifiableList(result);
        }

        private void addNeutron(Neutron neutron) {
            if (this.width == -1.0) {
                throw new IllegalStateException();
            }
            if (neutron.getType() == NeutronType.ZWSP_SEPARATOR && this.neutrons.size() == 0) {
                return;
            }
            if (neutron.getType() == NeutronType.ZWSP_SEPARATOR && this.neutrons.size() > 0 && this.last().getType() == NeutronType.ZWSP_SEPARATOR) {
                return;
            }
            if (this.removeInitialSpaces && this.neutrons.size() == 0 && neutron.getType() == NeutronType.SPACE) {
                return;
            }
            this.neutrons.add(neutron);
            this.width += neutron.getWidth(this.stringBounder);
        }

        @Override
        public Atom getLHeader() {
            return null;
        }
    }
}

