/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Iterator;
import net.sourceforge.plantuml.EmbeddedDiagram;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.BodyEnhancedAbstract;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.TextBlockVertical2;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;

public class BodyEnhanced2
extends BodyEnhancedAbstract {
    private final Display rawBody;
    private final ISkinSimple skinParam;
    private final LineBreakStrategy lineBreakStrategy;

    BodyEnhanced2(Display rawBody, ISkinSimple skinParam, HorizontalAlignment align, FontConfiguration titleConfig, LineBreakStrategy lineBreakStrategy, Style style) {
        super(align, titleConfig, style);
        this.rawBody = rawBody;
        this.lineBreakStrategy = lineBreakStrategy;
        this.skinParam = skinParam;
    }

    @Override
    protected double getMarginX() {
        return 0.0;
    }

    @Override
    protected TextBlock getArea(StringBounder stringBounder) {
        if (this.area != null) {
            return this.area;
        }
        ArrayList<TextBlock> blocks = new ArrayList<TextBlock>();
        char separator = '\u0000';
        TextBlock title = null;
        Display display = Display.empty();
        Iterator it = this.rawBody.iterator();
        while (it.hasNext()) {
            CharSequence s = (CharSequence)it.next();
            String type = EmbeddedDiagram.getEmbeddedType(StringUtils.trinNoTrace(s));
            if (type != null) {
                display = display.add(s);
                display = BodyEnhanced2.addOneSingleLineManageEmbedded2(it, display);
                continue;
            }
            if (BodyEnhanced2.isBlockSeparator(s.toString())) {
                blocks.add(this.decorate(this.getTextBlock(display), separator, title, stringBounder));
                separator = s.charAt(0);
                title = this.getTitle(s.toString(), this.skinParam);
                display = Display.empty();
                continue;
            }
            display = display.add(s);
        }
        blocks.add(this.decorate(this.getTextBlock(display), separator, title, stringBounder));
        this.area = blocks.size() == 1 ? (TextBlock)blocks.get(0) : new TextBlockVertical2(blocks, this.align);
        double minClassWidth = this.getStyle().value(PName.MinimumWidth).asDouble();
        if (minClassWidth > 0.0) {
            this.area = TextBlockUtils.withMinWidth(this.area, minClassWidth, this.align);
        }
        return this.area;
    }

    private static Display addOneSingleLineManageEmbedded2(Iterator<CharSequence> it, Display display) {
        int nested = 1;
        while (it.hasNext()) {
            CharSequence s = it.next();
            display = display.add(s);
            if (EmbeddedDiagram.getEmbeddedType(StringUtils.trinNoTrace(s)) != null) {
                ++nested;
                continue;
            }
            if (!StringUtils.trinNoTrace(s).equals("}}") || --nested != 0) continue;
            return display;
        }
        return display;
    }

    private TextBlock getTextBlock(Display display) {
        TextBlock result = display.create9(this.titleConfig, this.align, this.skinParam, this.lineBreakStrategy);
        return result;
    }
}

